/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.factoryBot.lang.findUsages;

import com.intellij.CommonBundle;
import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.find.findUsages.FindUsagesHandlerFactory;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import java.util.List;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.factoryBot.codeInsight.callTypes.RubyFactoryBotModelCallType;
import org.jetbrains.plugins.ruby.factoryBot.lang.findUsages.RubyFactoryBotFindUsagesHandler;
import org.jetbrains.plugins.ruby.factoryBot.lang.findUsages.RubyFactoryBotFindUsagesProvider;
import org.jetbrains.plugins.ruby.factoryBot.lang.psi.impl.methodCall.RubyFactoryBotCallNavigator;
import org.jetbrains.plugins.ruby.factoryBot.lang.psi.util.RubyFactoryBotPsiUtil;
import org.jetbrains.plugins.ruby.ruby.interpret.RubyInterpretUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;

public final class RubyFactoryBotFindUsagesHandlerFactory
extends FindUsagesHandlerFactory {
    public boolean canFindUsages(@NotNull PsiElement element) {
        if (element == null) {
            RubyFactoryBotFindUsagesHandlerFactory.$$$reportNull$$$0(0);
        }
        return new RubyFactoryBotFindUsagesProvider().canFindUsagesFor(element);
    }

    @Nullable
    public FindUsagesHandler createFindUsagesHandler(@NotNull PsiElement element, boolean forHighlightUsages) {
        if (element == null) {
            RubyFactoryBotFindUsagesHandlerFactory.$$$reportNull$$$0(1);
        }
        return this.createFindUsagesHandler(element, forHighlightUsages ? FindUsagesHandlerFactory.OperationMode.HIGHLIGHT_USAGES : FindUsagesHandlerFactory.OperationMode.USAGES_WITH_DEFAULT_OPTIONS);
    }

    @Nullable
    public FindUsagesHandler createFindUsagesHandler(@NotNull PsiElement element, @NotNull FindUsagesHandlerFactory.OperationMode operationMode) {
        RCall call;
        if (element == null) {
            RubyFactoryBotFindUsagesHandlerFactory.$$$reportNull$$$0(2);
        }
        if (operationMode == null) {
            RubyFactoryBotFindUsagesHandlerFactory.$$$reportNull$$$0(3);
        }
        if ((call = RubyFactoryBotCallNavigator.getModelCallByNameOrAliasArgument(element)) != null) {
            return new RubyFactoryBotFindUsagesHandler(call, operationMode == FindUsagesHandlerFactory.OperationMode.USAGES_WITH_DEFAULT_OPTIONS ? RubyFactoryBotFindUsagesHandlerFactory.getTargetArgument(call, element) : element);
        }
        return null;
    }

    @NotNull
    private static PsiElement getTargetArgument(@NotNull RCall call, @NotNull PsiElement element) {
        if (call == null) {
            RubyFactoryBotFindUsagesHandlerFactory.$$$reportNull$$$0(4);
        }
        if (element == null) {
            RubyFactoryBotFindUsagesHandlerFactory.$$$reportNull$$$0(5);
        }
        if (RubyFactoryBotFindUsagesHandlerFactory.isAlias(call, element) && RubyFactoryBotFindUsagesHandlerFactory.askShouldSearchForOriginalModel(call, element)) {
            PsiElement psiElement = (PsiElement)Objects.requireNonNull(RubyFactoryBotPsiUtil.getModelNameElement((RPossibleCall)call));
            if (psiElement == null) {
                RubyFactoryBotFindUsagesHandlerFactory.$$$reportNull$$$0(6);
            }
            return psiElement;
        }
        PsiElement psiElement = element;
        if (psiElement == null) {
            RubyFactoryBotFindUsagesHandlerFactory.$$$reportNull$$$0(7);
        }
        return psiElement;
    }

    private static boolean askShouldSearchForOriginalModel(@NotNull RCall call, @NotNull PsiElement element) {
        if (call == null) {
            RubyFactoryBotFindUsagesHandlerFactory.$$$reportNull$$$0(8);
        }
        if (element == null) {
            RubyFactoryBotFindUsagesHandlerFactory.$$$reportNull$$$0(9);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return false;
        }
        String aliasName = RubyInterpretUtil.evaluateStringOrSymbolElement(element);
        String originalName = RubyFactoryBotModelCallType.getName((RPossibleCall)call);
        if (aliasName == null || originalName == null || aliasName.equals(originalName)) {
            return false;
        }
        String command = call.getCallType().getCommandName();
        String message = RBundle.message((String)"ruby.factoryBot.findUsages.search.for.original.message", (Object[])new Object[]{StringUtil.toTitleCase((String)command), command, aliasName, originalName});
        return Messages.showOkCancelDialog((Project)call.getProject(), (String)message, (String)RBundle.message((String)"ruby.factoryBot.findUsages.search.for.original.title"), (String)CommonBundle.getYesButtonText(), (String)CommonBundle.getNoButtonText(), (Icon)Messages.getQuestionIcon()) == 0;
    }

    private static boolean isAlias(@NotNull RCall call, @NotNull PsiElement element) {
        if (call == null) {
            RubyFactoryBotFindUsagesHandlerFactory.$$$reportNull$$$0(10);
        }
        if (element == null) {
            RubyFactoryBotFindUsagesHandlerFactory.$$$reportNull$$$0(11);
        }
        List<? extends RPsiElement> elements = RubyFactoryBotPsiUtil.getModelAliasElements((RPossibleCall)call);
        return elements.contains(element);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operationMode";
                break;
            }
            case 4: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/factoryBot/lang/findUsages/RubyFactoryBotFindUsagesHandlerFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/factoryBot/lang/findUsages/RubyFactoryBotFindUsagesHandlerFactory";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetArgument";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "canFindUsages";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createFindUsagesHandler";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getTargetArgument";
                break;
            }
            case 6: 
            case 7: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "askShouldSearchForOriginalModel";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isAlias";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7 -> new IllegalStateException(string);
        };
    }
}

