/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.factoryBot.codeInsight.symbols;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.factoryBot.codeInsight.symbols.fqn.RubyFactoryBotFqns;
import org.jetbrains.plugins.ruby.factoryBot.model.RubyFactoryBotFactory;
import org.jetbrains.plugins.ruby.factoryGirl.codeInsight.symbols.fqn.RubyFactoryGirlFqns;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.RubySymbolProvider;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.TypeSet;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.TypedPsiElementSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.Context;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RTypeFactory;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.impl.REmptyType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.impl.RSymbolTypeImpl;
import org.jetbrains.plugins.ruby.ruby.interpret.RubyInterpretUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;

public final class RubyFactoryBotSymbolProvider
implements RubySymbolProvider {
    private static final List<FQN> HASH_FQNS = Arrays.asList(RubyFactoryBotFqns.FACTORY_BOT_SYNTAX_METHODS_ATTRIBUTES_FOR, RubyFactoryGirlFqns.FACTORY_GIRL_SYNTAX_METHODS_ATTRIBUTES_FOR);
    private static final List<FQN> ARRAY_OF_HASH_FQNS = Arrays.asList(RubyFactoryBotFqns.FACTORY_BOT_SYNTAX_METHODS_ATTRIBUTES_FOR_LIST, RubyFactoryBotFqns.FACTORY_BOT_SYNTAX_METHODS_ATTRIBUTES_FOR_PAIR, RubyFactoryGirlFqns.FACTORY_GIRL_SYNTAX_METHODS_ATTRIBUTES_FOR_LIST);
    private static final List<FQN> INSTANCE_FQNS = Arrays.asList(RubyFactoryBotFqns.FACTORY_BOT_SYNTAX_METHODS_BUILD, RubyFactoryBotFqns.FACTORY_BOT_SYNTAX_METHODS_BUILD_STUBBED, RubyFactoryBotFqns.FACTORY_BOT_SYNTAX_METHODS_CREATE, RubyFactoryGirlFqns.FACTORY_GIRL_SYNTAX_METHODS_BUILD, RubyFactoryGirlFqns.FACTORY_GIRL_SYNTAX_METHODS_BUILD_STUBBED, RubyFactoryGirlFqns.FACTORY_GIRL_SYNTAX_METHODS_CREATE);
    private static final List<FQN> ARRAY_OF_INSTANCE_FQNS = Arrays.asList(RubyFactoryBotFqns.FACTORY_BOT_SYNTAX_METHODS_BUILD_LIST, RubyFactoryBotFqns.FACTORY_BOT_SYNTAX_METHODS_BUILD_PAIR, RubyFactoryBotFqns.FACTORY_BOT_SYNTAX_METHODS_BUILD_STUBBED_LIST, RubyFactoryBotFqns.FACTORY_BOT_SYNTAX_METHODS_BUILD_STUBBED_PAIR, RubyFactoryBotFqns.FACTORY_BOT_SYNTAX_METHODS_CREATE_LIST, RubyFactoryBotFqns.FACTORY_BOT_SYNTAX_METHODS_CREATE_PAIR, RubyFactoryGirlFqns.FACTORY_GIRL_SYNTAX_METHODS_BUILD_LIST, RubyFactoryGirlFqns.FACTORY_GIRL_SYNTAX_METHODS_BUILD_STUBBED_LIST, RubyFactoryGirlFqns.FACTORY_GIRL_SYNTAX_METHODS_CREATE_LIST);
    private static final List<FQN> FQNS = ContainerUtil.concat((List[])new List[]{HASH_FQNS, ARRAY_OF_HASH_FQNS, INSTANCE_FQNS, ARRAY_OF_INSTANCE_FQNS});
    private static final List<String> FQN_SHORT_NAMES = ContainerUtil.map(FQNS, FQN::getShortName);

    @Override
    public Symbol findSymbol(@NotNull Symbol anchor, @NotNull FQN fqn, @NotNull TypeSet types, @Nullable PsiElement invocationPoint) {
        if (anchor == null) {
            RubyFactoryBotSymbolProvider.$$$reportNull$$$0(0);
        }
        if (fqn == null) {
            RubyFactoryBotSymbolProvider.$$$reportNull$$$0(1);
        }
        if (types == null) {
            RubyFactoryBotSymbolProvider.$$$reportNull$$$0(2);
        }
        if (!FQN_SHORT_NAMES.contains(fqn.getShortName()) || !(invocationPoint instanceof RCall)) {
            return null;
        }
        Symbol originalSymbol = SymbolUtil.lookupSymbolInHierarchy(anchor, fqn.getShortName(), types, invocationPoint);
        if (originalSymbol == null) {
            return null;
        }
        Project project = anchor.getProject();
        FQN fqnWithNesting = originalSymbol.getFQNWithNesting();
        if (HASH_FQNS.contains(fqnWithNesting)) {
            return RubyFactoryBotSymbolProvider.createTypedSymbol(originalSymbol, RubyFactoryBotSymbolProvider.getHashType(project));
        }
        if (ARRAY_OF_HASH_FQNS.contains(fqnWithNesting)) {
            return RubyFactoryBotSymbolProvider.createTypedSymbol(originalSymbol, RTypeFactory.createArrayType(project, RubyFactoryBotSymbolProvider.getHashType(project)));
        }
        if (INSTANCE_FQNS.contains(fqnWithNesting)) {
            RType instanceType = RubyFactoryBotSymbolProvider.getFactoryInstanceType(project, (RCall)invocationPoint);
            return RubyFactoryBotSymbolProvider.createTypedSymbol(originalSymbol, instanceType);
        }
        if (ARRAY_OF_INSTANCE_FQNS.contains(fqnWithNesting)) {
            RType instanceType = RubyFactoryBotSymbolProvider.getFactoryInstanceType(project, (RCall)invocationPoint);
            return RubyFactoryBotSymbolProvider.createTypedSymbol(originalSymbol, RTypeFactory.createArrayType(project, instanceType));
        }
        return null;
    }

    @Nullable
    private static Symbol createTypedSymbol(final @NotNull Symbol originalSymbol, final @NotNull RType type) {
        if (originalSymbol == null) {
            RubyFactoryBotSymbolProvider.$$$reportNull$$$0(3);
        }
        if (type == null) {
            RubyFactoryBotSymbolProvider.$$$reportNull$$$0(4);
        }
        if (originalSymbol.getPsiElement() == null) {
            return null;
        }
        return new TypedPsiElementSymbol<PsiElement>(originalSymbol.getPsiElement(), originalSymbol.getName(), originalSymbol.getType(), originalSymbol.getParentSymbol()){

            @Nullable
            public Icon getExplicitIcon() {
                return originalSymbol.getExplicitIcon();
            }

            @NotNull
            public RType getType(@NotNull Context context) {
                if (context == null) {
                    1.$$$reportNull$$$0(0);
                }
                RType rType = type;
                if (rType == null) {
                    1.$$$reportNull$$$0(1);
                }
                return rType;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jetbrains/plugins/ruby/factoryBot/codeInsight/symbols/RubyFactoryBotSymbolProvider$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jetbrains/plugins/ruby/factoryBot/codeInsight/symbols/RubyFactoryBotSymbolProvider$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getType";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getType";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        };
    }

    @NotNull
    private static RType getFactoryInstanceType(@NotNull Project project, @NotNull RCall call) {
        String factoryName;
        if (project == null) {
            RubyFactoryBotSymbolProvider.$$$reportNull$$$0(5);
        }
        if (call == null) {
            RubyFactoryBotSymbolProvider.$$$reportNull$$$0(6);
        }
        if ((factoryName = RubyInterpretUtil.evaluateStringOrSymbolElement((PsiElement)ContainerUtil.getFirstItem((List)call.getArguments()))) == null) {
            REmptyType rEmptyType = REmptyType.INSTANCE;
            if (rEmptyType == null) {
                RubyFactoryBotSymbolProvider.$$$reportNull$$$0(7);
            }
            return rEmptyType;
        }
        RubyFactoryBotFactory factory = RubyFactoryBotFactory.findByName(project, (SearchScope)call.getResolveScope(), factoryName);
        Symbol instanceSymbol = factory.getInstanceSymbol();
        if (instanceSymbol == null) {
            REmptyType rEmptyType = REmptyType.INSTANCE;
            if (rEmptyType == null) {
                RubyFactoryBotSymbolProvider.$$$reportNull$$$0(8);
            }
            return rEmptyType;
        }
        RType rType = RSymbolTypeImpl.create(instanceSymbol);
        if (rType == null) {
            RubyFactoryBotSymbolProvider.$$$reportNull$$$0(9);
        }
        return rType;
    }

    @NotNull
    private static RType getHashType(@NotNull Project project) {
        if (project == null) {
            RubyFactoryBotSymbolProvider.$$$reportNull$$$0(10);
        }
        RType rType = RTypeFactory.createHashType(project, RTypeFactory.createSymbolType(project), (RType)REmptyType.INSTANCE);
        if (rType == null) {
            RubyFactoryBotSymbolProvider.$$$reportNull$$$0(11);
        }
        return rType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 8, 9, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalSymbol";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/factoryBot/codeInsight/symbols/RubyFactoryBotSymbolProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/factoryBot/codeInsight/symbols/RubyFactoryBotSymbolProvider";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getFactoryInstanceType";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getHashType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findSymbol";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createTypedSymbol";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getFactoryInstanceType";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getHashType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 8, 9, 11 -> new IllegalStateException(string);
        };
    }
}

