/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.factoryBot.codeInsight.paramDefs;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.Consumer;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.factoryBot.model.RubyFactoryBotModelUtil;
import org.jetbrains.plugins.ruby.factoryBot.model.RubyFactoryBotTrait;
import org.jetbrains.plugins.ruby.factoryBot.psi.presentation.RubyFactoryBotPresentationUtil;
import org.jetbrains.plugins.ruby.rails.inspections.paramdefs.InspectionResult;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.LookupItemType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.ParamDef;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.ParamDefImplUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.RubyCallArgumentContext;
import org.jetbrains.plugins.ruby.ruby.interpret.RubyInterpretUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;

public final class RubyFactoryBotTraitRefParam
extends ParamDef {
    static final ParamDef INSTANCE = new RubyFactoryBotTraitRefParam();

    private RubyFactoryBotTraitRefParam() {
    }

    @Override
    @NotNull
    public InspectionResult inspectReference(@NotNull RubyCallArgumentContext context) {
        if (context == null) {
            RubyFactoryBotTraitRefParam.$$$reportNull$$$0(0);
        }
        RPsiElement element = context.getArgumentElement();
        if (this.multiResolve(context).isEmpty()) {
            if (RubyPsiUtil.isSimpleStringOrSymbol((PsiElement)element)) {
                InspectionResult inspectionResult = InspectionResult.createWarningResult((PsiElement)element, RBundle.message((String)"ruby.factoryBot.paramDefs.traitRef.invalid.reference"));
                if (inspectionResult == null) {
                    RubyFactoryBotTraitRefParam.$$$reportNull$$$0(1);
                }
                return inspectionResult;
            }
            InspectionResult inspectionResult = InspectionResult.createProbablyAcceptibleResult((PsiElement)element);
            if (inspectionResult == null) {
                RubyFactoryBotTraitRefParam.$$$reportNull$$$0(2);
            }
            return inspectionResult;
        }
        InspectionResult inspectionResult = InspectionResult.createOkResult((PsiElement)element);
        if (inspectionResult == null) {
            RubyFactoryBotTraitRefParam.$$$reportNull$$$0(3);
        }
        return inspectionResult;
    }

    @NotNull
    public List<PsiElement> multiResolve(@NotNull RubyCallArgumentContext context) {
        RPsiElement element;
        String name;
        if (context == null) {
            RubyFactoryBotTraitRefParam.$$$reportNull$$$0(4);
        }
        if ((name = RubyInterpretUtil.evaluateStringOrSymbolElement((PsiElement)(element = context.getArgumentElement()))) == null) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                RubyFactoryBotTraitRefParam.$$$reportNull$$$0(5);
            }
            return list;
        }
        List<RubyFactoryBotTrait> traits = RubyFactoryBotTrait.findAllByName(context.getProject(), (SearchScope)element.getResolveScope(), name);
        List<PsiElement> list = traits.stream().flatMap(trait -> trait.getDeclarations().stream()).collect(Collectors.toList());
        if (list == null) {
            RubyFactoryBotTraitRefParam.$$$reportNull$$$0(6);
        }
        return list;
    }

    @Override
    public void processAllVariants(@NotNull RubyCallArgumentContext context, @NotNull Consumer<? super LookupElement> elementsConsumer, @NotNull Predicate<String> lookupStringFilter) {
        AtomicInteger limit;
        if (context == null) {
            RubyFactoryBotTraitRefParam.$$$reportNull$$$0(7);
        }
        if (elementsConsumer == null) {
            RubyFactoryBotTraitRefParam.$$$reportNull$$$0(8);
        }
        if (lookupStringFilter == null) {
            RubyFactoryBotTraitRefParam.$$$reportNull$$$0(9);
        }
        if ((limit = new AtomicInteger(Registry.intValue((String)"ide.completion.variant.limit", (int)1000))).get() <= 0) {
            return;
        }
        Project project = context.getProject();
        RPsiElement element = context.getArgumentElement();
        RubyFactoryBotModelUtil.processTraitNames(project, (SearchScope)element.getResolveScope(), (Processor<? super String>)((Processor)name -> {
            ProgressManager.checkCanceled();
            String typeText = RBundle.message((String)"ruby.factoryBot.presentation.trait.type");
            Icon icon = RubyFactoryBotPresentationUtil.getTraitIcon();
            if (lookupStringFilter.test((String)name)) {
                elementsConsumer.consume((Object)ParamDefImplUtil.createSimpleLookupItem(name, typeText, LookupItemType.Symbol, element, icon));
            }
            return limit.decrementAndGet() > 0;
        }));
    }

    @Override
    @Nullable
    public PsiElement resolveReference(@NotNull RubyCallArgumentContext context) {
        if (context == null) {
            RubyFactoryBotTraitRefParam.$$$reportNull$$$0(10);
        }
        return (PsiElement)ContainerUtil.getOnlyItem(this.multiResolve(context));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/factoryBot/codeInsight/paramDefs/RubyFactoryBotTraitRefParam";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementsConsumer";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lookupStringFilter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/factoryBot/codeInsight/paramDefs/RubyFactoryBotTraitRefParam";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "inspectReference";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "inspectReference";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "multiResolve";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "processAllVariants";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "resolveReference";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 5, 6 -> new IllegalStateException(string);
        };
    }
}

