/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.factoryBot.codeInsight.daemon;

import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProviderDescriptor;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import icons.RubyIcons;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.factoryBot.codeInsight.callTypes.RubyFactoryBotCallTypeProvider;
import org.jetbrains.plugins.ruby.factoryBot.lang.psi.impl.RubyFactoryBotModelFakePsiElement;
import org.jetbrains.plugins.ruby.factoryBot.model.RubyFactoryBotFactory;
import org.jetbrains.plugins.ruby.factoryBot.model.RubyFactoryBotSequence;
import org.jetbrains.plugins.ruby.factoryBot.psi.RubyFactoryBotImplicitFactoryReference;
import org.jetbrains.plugins.ruby.factoryBot.psi.RubyFactoryBotImplicitSequenceReference;
import org.jetbrains.plugins.ruby.ruby.codeInsight.lineMarkers.RubyToolTipProvider;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RIdentifier;

public final class RubyFactoryBotImplicitReferencesLineMarkerProvider
extends LineMarkerProviderDescriptor {
    public void collectSlowLineMarkers(@NotNull List<? extends PsiElement> elements, @NotNull Collection<? super LineMarkerInfo<?>> result) {
        if (elements == null) {
            RubyFactoryBotImplicitReferencesLineMarkerProvider.$$$reportNull$$$0(0);
        }
        if (result == null) {
            RubyFactoryBotImplicitReferencesLineMarkerProvider.$$$reportNull$$$0(1);
        }
        for (PsiElement psiElement : elements) {
            RIdentifier identifier;
            PsiElement parent = psiElement.getParent();
            if (!(psiElement instanceof LeafElement) || !(parent instanceof RIdentifier) || !RubyFactoryBotCallTypeProvider.isInFactoryBotDefineOrModifyBlockCall((PsiElement)(identifier = (RIdentifier)parent))) continue;
            ContainerUtil.addIfNotNull(result, RubyFactoryBotImplicitReferencesLineMarkerProvider.getImplicitReferenceLineMarker(identifier, psiElement));
        }
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = RubyIcons.FactoryBot.OverridingFactory_12x12;
        if (icon == null) {
            RubyFactoryBotImplicitReferencesLineMarkerProvider.$$$reportNull$$$0(2);
        }
        return icon;
    }

    public LineMarkerInfo<?> getLineMarkerInfo(@NotNull PsiElement element) {
        if (element == null) {
            RubyFactoryBotImplicitReferencesLineMarkerProvider.$$$reportNull$$$0(3);
        }
        return null;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getName() {
        String string = RBundle.message((String)"ruby.factoryBot.lineMarker.implicit.references.name");
        if (string == null) {
            RubyFactoryBotImplicitReferencesLineMarkerProvider.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Nullable
    private static LineMarkerInfo<?> getImplicitReferenceLineMarker(@NotNull RIdentifier identifier, @NotNull PsiElement element) {
        Icon icon;
        RubyFactoryBotModelFakePsiElement declaration;
        if (identifier == null) {
            RubyFactoryBotImplicitReferencesLineMarkerProvider.$$$reportNull$$$0(5);
        }
        if (element == null) {
            RubyFactoryBotImplicitReferencesLineMarkerProvider.$$$reportNull$$$0(6);
        }
        if (!ContainerUtil.or((Object[])identifier.getReferences(), reference -> reference instanceof RubyFactoryBotImplicitFactoryReference || reference instanceof RubyFactoryBotImplicitSequenceReference)) {
            return null;
        }
        Project project = identifier.getProject();
        String name = identifier.getName();
        if (name == null) {
            return null;
        }
        RubyFactoryBotFactory factory = RubyFactoryBotFactory.findByName(project, (SearchScope)element.getResolveScope(), name);
        if (!factory.getDeclarations().isEmpty()) {
            declaration = factory.getPrimaryDeclaration();
            icon = RubyIcons.FactoryBot.OverridingFactory_12x12;
        } else {
            RubyFactoryBotSequence sequence = RubyFactoryBotSequence.findByName(project, (SearchScope)element.getResolveScope(), name);
            declaration = sequence.getPrimaryDeclaration();
            icon = RubyIcons.FactoryBot.OverridingSequence_12x12;
        }
        if (declaration == null) {
            return null;
        }
        return new LineMarkerInfo(element, element.getTextRange(), icon, (Function)new MyTooltipProvider(declaration), (e, elt) -> declaration.navigate(true), GutterIconRenderer.Alignment.RIGHT);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/factoryBot/codeInsight/daemon/RubyFactoryBotImplicitReferencesLineMarkerProvider";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/factoryBot/codeInsight/daemon/RubyFactoryBotImplicitReferencesLineMarkerProvider";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "collectSlowLineMarkers";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getLineMarkerInfo";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getImplicitReferenceLineMarker";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4 -> new IllegalStateException(string);
        };
    }

    private static final class MyTooltipProvider
    extends RubyToolTipProvider {
        private final String myType;

        private MyTooltipProvider(@NotNull RubyFactoryBotModelFakePsiElement element) {
            if (element == null) {
                MyTooltipProvider.$$$reportNull$$$0(0);
            }
            super(Collections.singletonList(element));
            this.myType = element.getTypeName();
        }

        @Override
        @NotNull
        protected String getMessageString(RContainer container) {
            String string = RBundle.message((String)"ruby.factoryBot.lineMarker.implicit.references.tooltip.title", (Object[])new Object[]{this.myType});
            if (string == null) {
                MyTooltipProvider.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/factoryBot/codeInsight/daemon/RubyFactoryBotImplicitReferencesLineMarkerProvider$MyTooltipProvider";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/factoryBot/codeInsight/daemon/RubyFactoryBotImplicitReferencesLineMarkerProvider$MyTooltipProvider";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMessageString";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

