/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.factoryBot.codeInsight.callTypes;

import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.lang.psi.stubs.StringRefList;

public final class RubyFactoryBotCallTypeData {
    @Nullable
    private final String myName;
    private final List<String> myAliases;
    @Nullable
    private final String myClassName;
    @Nullable
    private final String myParent;
    private final FQN myScopeContext;

    RubyFactoryBotCallTypeData(@Nullable String name, @NotNull List<String> aliases, @Nullable String className, @Nullable String parent, @NotNull FQN scopeContext) {
        if (aliases == null) {
            RubyFactoryBotCallTypeData.$$$reportNull$$$0(0);
        }
        if (scopeContext == null) {
            RubyFactoryBotCallTypeData.$$$reportNull$$$0(1);
        }
        this.myName = name;
        this.myAliases = Collections.unmodifiableList(new ArrayList<String>(aliases));
        this.myClassName = className;
        this.myParent = parent;
        this.myScopeContext = scopeContext;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        RubyFactoryBotCallTypeData data = (RubyFactoryBotCallTypeData)other;
        return Objects.equals(this.myName, data.myName) && this.myAliases.equals(data.myAliases) && Objects.equals(this.myClassName, data.myClassName) && Objects.equals(this.myParent, data.myParent) && this.myScopeContext.equals(data.myScopeContext);
    }

    @NotNull
    public List<String> getAliases() {
        List<String> list = this.myAliases;
        if (list == null) {
            RubyFactoryBotCallTypeData.$$$reportNull$$$0(2);
        }
        return list;
    }

    @Nullable
    public String getClassName() {
        return this.myClassName;
    }

    @Nullable
    public String getName() {
        return this.myName;
    }

    @NotNull
    public List<String> getNames() {
        List list = this.myName != null ? ContainerUtil.prepend(this.myAliases, (Object[])new String[]{this.myName}) : this.myAliases;
        if (list == null) {
            RubyFactoryBotCallTypeData.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Nullable
    public String getParent() {
        return this.myParent;
    }

    @NotNull
    public FQN getScopeContext() {
        FQN fQN = this.myScopeContext;
        if (fQN == null) {
            RubyFactoryBotCallTypeData.$$$reportNull$$$0(4);
        }
        return fQN;
    }

    public int hashCode() {
        int result = Objects.hashCode(this.myName);
        result = 31 * result + this.myAliases.hashCode();
        result = 31 * result + Objects.hashCode(this.myClassName);
        result = 31 * result + Objects.hashCode(this.myParent);
        result = 31 * result + this.myScopeContext.hashCode();
        return result;
    }

    public String toString() {
        return String.format("RubyFactoryBotCallTypeData{myName='%s', myAliases=%s, myClassName='%s', myParent='%s', myScopeContext=%s}", this.myName, this.myAliases, this.myClassName, this.myParent, this.myScopeContext);
    }

    @NotNull
    public static RubyFactoryBotCallTypeData deserialize(@NotNull StubInputStream inputStream) throws IOException {
        if (inputStream == null) {
            RubyFactoryBotCallTypeData.$$$reportNull$$$0(5);
        }
        String name = inputStream.readNameString();
        List aliases = StringRefList.deserialize((StubInputStream)inputStream).getStrings();
        String clazz = inputStream.readNameString();
        String parent = inputStream.readNameString();
        FQN scopeContext = FQN.Serialization.deserialize((StubInputStream)inputStream);
        return new RubyFactoryBotCallTypeData(name, aliases, clazz, parent, scopeContext);
    }

    public static void serialize(@NotNull RubyFactoryBotCallTypeData data, @NotNull StubOutputStream outputStream) throws IOException {
        if (data == null) {
            RubyFactoryBotCallTypeData.$$$reportNull$$$0(6);
        }
        if (outputStream == null) {
            RubyFactoryBotCallTypeData.$$$reportNull$$$0(7);
        }
        outputStream.writeName(data.myName);
        StringRefList.serialize(data.myAliases, (StubOutputStream)outputStream);
        outputStream.writeName(data.myClassName);
        outputStream.writeName(data.myParent);
        FQN.Serialization.serialize((FQN)data.myScopeContext, (StubOutputStream)outputStream);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aliases";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeContext";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/factoryBot/codeInsight/callTypes/RubyFactoryBotCallTypeData";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStream";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputStream";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/factoryBot/codeInsight/callTypes/RubyFactoryBotCallTypeData";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAliases";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getNames";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getScopeContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "deserialize";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4 -> new IllegalStateException(string);
        };
    }
}

