/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.erb.parser;

import com.intellij.lang.ASTNode;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiParser;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.erb.ErbElementTypes;
import org.jetbrains.plugins.ruby.erb.lexer._ErbLexer;
import org.jetbrains.plugins.ruby.erb.parser.ErbParser;
import org.jetbrains.plugins.ruby.erb.psi.ErbTokenTypes;
import org.jetbrains.plugins.ruby.erb.psi.impl.ErbFileImpl;
import org.jetbrains.plugins.ruby.ruby.lang.parser.RubyTemplateAwareParserDefinition;

public final class ErbParserDefinition
implements RubyTemplateAwareParserDefinition {
    private TokenSet myCommentTokens;

    @NotNull
    public Lexer createLexer(Project project) {
        return new _ErbLexer();
    }

    @NotNull
    public IFileElementType getFileNodeType() {
        IFileElementType iFileElementType = ErbElementTypes.ERB_FILE;
        if (iFileElementType == null) {
            ErbParserDefinition.$$$reportNull$$$0(0);
        }
        return iFileElementType;
    }

    @NotNull
    public TokenSet getWhitespaceTokens() {
        TokenSet tokenSet = ErbTokenTypes.ERB_WHITE_SPACE_TOKENS;
        if (tokenSet == null) {
            ErbParserDefinition.$$$reportNull$$$0(1);
        }
        return tokenSet;
    }

    @NotNull
    public TokenSet getCommentTokens() {
        if (this.myCommentTokens == null) {
            this.myCommentTokens = TokenSet.create((IElementType[])new IElementType[]{ErbElementTypes.ERB_COMMENT_ELEMENT, ErbTokenTypes.ERB_COMMENT_START, ErbTokenTypes.ERB_COMMENT_CHARACTERS, ErbTokenTypes.ERB_COMMENT_END, ErbTokenTypes.GRAPHQL_TEMPLATE_BLOCK});
        }
        TokenSet tokenSet = this.myCommentTokens;
        if (tokenSet == null) {
            ErbParserDefinition.$$$reportNull$$$0(2);
        }
        return tokenSet;
    }

    @NotNull
    public TokenSet getStringLiteralElements() {
        TokenSet tokenSet = TokenSet.EMPTY;
        if (tokenSet == null) {
            ErbParserDefinition.$$$reportNull$$$0(3);
        }
        return tokenSet;
    }

    @NotNull
    public PsiParser createParser(Project project) {
        return new ErbParser();
    }

    @NotNull
    public PsiFile createFile(@NotNull FileViewProvider viewProvider) {
        if (viewProvider == null) {
            ErbParserDefinition.$$$reportNull$$$0(4);
        }
        return new ErbFileImpl(viewProvider);
    }

    @NotNull
    public ParserDefinition.SpaceRequirements spaceExistenceTypeBetweenTokens(ASTNode left, ASTNode right) {
        if (ErbTokenTypes.ERB_SEPARATORS.contains(left.getElementType()) || ErbTokenTypes.ERB_SEPARATORS.contains(right.getElementType())) {
            ParserDefinition.SpaceRequirements spaceRequirements = ParserDefinition.SpaceRequirements.MUST_LINE_BREAK;
            if (spaceRequirements == null) {
                ErbParserDefinition.$$$reportNull$$$0(5);
            }
            return spaceRequirements;
        }
        ParserDefinition.SpaceRequirements spaceRequirements = ParserDefinition.SpaceRequirements.MAY;
        if (spaceRequirements == null) {
            ErbParserDefinition.$$$reportNull$$$0(6);
        }
        return spaceRequirements;
    }

    @NotNull
    public PsiElement createElement(ASTNode node) {
        throw new UnsupportedOperationException("ErbParserDefinition#createElement called!");
    }

    public boolean mayContainTemplateParts(@NotNull CharSequence codeSample) {
        if (codeSample == null) {
            ErbParserDefinition.$$$reportNull$$$0(7);
        }
        int startIndex = 0;
        int codeLength = codeSample.length();
        while (startIndex < codeLength) {
            int percentIndex = StringUtil.indexOf((CharSequence)codeSample, (char)'%', (int)startIndex);
            if (percentIndex == -1) {
                return false;
            }
            if (percentIndex > 1 && codeSample.charAt(percentIndex - 1) == '<') {
                return true;
            }
            if (percentIndex < codeLength - 1 && codeSample.charAt(percentIndex + 1) == '>') {
                return true;
            }
            startIndex = percentIndex + 1;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 4, 7 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/erb/parser/ErbParserDefinition";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewProvider";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codeSample";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileNodeType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getWhitespaceTokens";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommentTokens";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringLiteralElements";
                break;
            }
            case 4: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/erb/parser/ErbParserDefinition";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "spaceExistenceTypeBetweenTokens";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createFile";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "mayContainTemplateParts";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 4, 7 -> new IllegalArgumentException(string);
        };
    }
}

