/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.erb.parser;

import com.intellij.lang.ASTNode;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiParser;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.xml.XmlElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.erb.ErbElementTypes;
import org.jetbrains.plugins.ruby.erb.psi.ErbPsiUtil;
import org.jetbrains.plugins.ruby.erb.psi.ErbTokenTypes;

public class ErbParser
implements PsiParser {
    @NotNull
    public ASTNode parse(@NotNull IElementType root, PsiBuilder builder2) {
        if (root == null) {
            ErbParser.$$$reportNull$$$0(0);
        }
        builder2.enforceCommentTokens(TokenSet.EMPTY);
        PsiBuilder.Marker file = builder2.mark();
        ErbParsing parsing = new ErbParsing(builder2);
        parsing.parseDocument();
        file.done((IElementType)ErbElementTypes.ERB_FILE);
        ASTNode aSTNode = builder2.getTreeBuilt();
        if (aSTNode == null) {
            ErbParser.$$$reportNull$$$0(1);
        }
        return aSTNode;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/erb/parser/ErbParser";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/erb/parser/ErbParser";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "parse";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    private static class ErbParsing {
        private int openTagsCount = 0;
        private final PsiBuilder myPsiBuilder;

        ErbParsing(PsiBuilder builder2) {
            this.myPsiBuilder = builder2;
        }

        protected void parseComment() {
            IElementType tt;
            PsiBuilder.Marker comment = this.mark();
            this.advance();
            while (!this.eof() && (tt = this.token()) != ErbTokenTypes.ERB_COMMENT_END) {
                this.advance();
            }
            if (this.token() == ErbTokenTypes.ERB_COMMENT_END) {
                this.advance();
            } else {
                this.mark().error(RBundle.message((String)"erb.parsing.named.element.is.not.closed", (Object[])new Object[]{"comment"}));
            }
            comment.done(ErbElementTypes.ERB_COMMENT_ELEMENT);
        }

        private static boolean isCommentToken(IElementType tt) {
            return tt == ErbTokenTypes.ERB_COMMENT_START;
        }

        public void parseTagContent() {
            while (!ErbPsiUtil.isCodeInjectionEnd(this.token()) && !this.eof()) {
                IElementType tt = this.token();
                if (ErbPsiUtil.isCodeInjectionStart(tt) || ErbPsiUtil.isCodeInjectionEnd(tt)) {
                    this.parseRubyCodeInjection();
                    continue;
                }
                if (ErbParsing.isCommentToken(tt)) {
                    this.parseComment();
                    continue;
                }
                if (tt == ErbTokenTypes.FLEX_ERROR) {
                    PsiBuilder.Marker flexError = this.mark();
                    this.advance();
                    flexError.error(RBundle.message((String)"erb.parsing.flex.error"));
                    continue;
                }
                this.advance();
            }
        }

        public void parseDocument() {
            PsiBuilder.Marker doc = this.mark();
            while (!this.eof()) {
                this.parseTagContent();
            }
            doc.done(XmlElementType.HTML_DOCUMENT);
        }

        private void parseRubyCodeInjection() {
            if (ErbPsiUtil.isCodeInjectionStart(this.token())) {
                ++this.openTagsCount;
            }
            PsiBuilder.Marker tag = this.mark();
            this.advance();
            PsiBuilder.Marker content = this.mark();
            this.parseTagContent();
            if (ErbPsiUtil.isCodeInjectionEnd(this.token())) {
                --this.openTagsCount;
                if (this.openTagsCount < 0) {
                    this.openTagsCount = 0;
                    tag.doneBefore(ErbElementTypes.ERB_XML_TAG, content, RBundle.message((String)"erb.parsing.named.element.is.not.closed", (Object[])new Object[]{"injection"}));
                    content.drop();
                    return;
                }
            } else {
                this.error(RBundle.message((String)"erb.parsing.unexpected.end.of.file"));
            }
            content.drop();
            this.advance();
            tag.done(ErbElementTypes.ERB_XML_TAG);
        }

        private void error(@NlsContexts.ParsingError @NotNull String message) {
            if (message == null) {
                ErbParsing.$$$reportNull$$$0(0);
            }
            this.myPsiBuilder.error(message);
        }

        protected final PsiBuilder.Marker mark() {
            return this.myPsiBuilder.mark();
        }

        protected final IElementType token() {
            return this.myPsiBuilder.getTokenType();
        }

        protected final boolean eof() {
            return this.myPsiBuilder.eof();
        }

        protected final void advance() {
            this.myPsiBuilder.advanceLexer();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/plugins/ruby/erb/parser/ErbParser$ErbParsing", "error"));
        }
    }
}

