/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.erb.html;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.ui.breadcrumbs.BreadcrumbsProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.erb.ErbLanguage;
import org.jetbrains.plugins.ruby.erb.psi.ErbCodeInjectionTag;
import org.jetbrains.plugins.ruby.erb.psi.ErbTokenTypes;
import org.jetbrains.plugins.ruby.ruby.lang.RubyLanguage;
import org.jetbrains.plugins.ruby.ruby.lang.psi.PresentableElementType;

public final class ErbAndRubyBreadcrumbsInfoProvider
implements BreadcrumbsProvider {
    public Language[] getLanguages() {
        return new Language[]{ErbLanguage.INSTANCE};
    }

    public boolean acceptElement(@NotNull PsiElement element) {
        PsiFile psiFile;
        if (element == null) {
            ErbAndRubyBreadcrumbsInfoProvider.$$$reportNull$$$0(0);
        }
        if ((psiFile = element.getContainingFile()) == null) {
            return false;
        }
        if (psiFile.getLanguage() != ErbLanguage.INSTANCE) {
            return false;
        }
        PsiElement realElement = psiFile.getViewProvider().findElementAt(element.getTextOffset());
        if (realElement == null) {
            return false;
        }
        Language realLang = realElement.getLanguage();
        return realLang == RubyLanguage.INSTANCE || realLang == ErbLanguage.INSTANCE;
    }

    @NotNull
    public String getElementInfo(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            ErbAndRubyBreadcrumbsInfoProvider.$$$reportNull$$$0(1);
        }
        String string = ErbAndRubyBreadcrumbsInfoProvider.getPresentation(psiElement, true);
        if (string == null) {
            ErbAndRubyBreadcrumbsInfoProvider.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nullable
    public String getElementTooltip(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            ErbAndRubyBreadcrumbsInfoProvider.$$$reportNull$$$0(3);
        }
        return ErbAndRubyBreadcrumbsInfoProvider.getPresentation(psiElement, false);
    }

    @Nullable
    public PsiElement getParent(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            ErbAndRubyBreadcrumbsInfoProvider.$$$reportNull$$$0(4);
        }
        if (psiElement instanceof XmlDocument || psiElement instanceof PsiFile || psiElement instanceof PsiDirectory) {
            return null;
        }
        Language lang = ErbAndRubyBreadcrumbsInfoProvider.getLanguageForElement(psiElement);
        FileViewProvider provider = psiElement.getContainingFile().getViewProvider();
        int startOffset = psiElement.getTextRange().getStartOffset();
        if (lang == ErbLanguage.INSTANCE) {
            ASTNode node = psiElement.getNode();
            if (node != null && ErbTokenTypes.OMIT_NEW_LINE == node.getElementType()) {
                return psiElement.getParent();
            }
            PsiElement htmlElem = provider.findElementAt(startOffset, (Language)HTMLLanguage.INSTANCE);
            if (htmlElem != null) {
                PsiElement parent;
                for (parent = htmlElem.getParent(); parent != null && !(parent instanceof PsiFile) && parent.getTextRange() != null && parent.getTextRange().getStartOffset() == startOffset; parent = parent.getParent()) {
                }
                return parent;
            }
        } else if (lang == RubyLanguage.INSTANCE) {
            PsiElement parent;
            for (parent = provider.findElementAt(startOffset, (Language)ErbLanguage.INSTANCE); parent != null && parent.getNode() != null && !ErbTokenTypes.ERB_SEPARATORS_STARTS.contains(parent.getNode().getElementType()); parent = parent.getPrevSibling()) {
            }
            if (parent != null && parent.getNode() != null && ErbTokenTypes.ERB_SEPARATORS_STARTS.contains(parent.getNode().getElementType())) {
                return parent;
            }
        }
        return psiElement.getParent();
    }

    private static String getInjectionPresentation(PsiElement start, PsiElement startOmit, PsiElement end, PsiElement endOmit) {
        IElementType omitNodeType;
        StringBuilder builder2 = new StringBuilder();
        if (start != null) {
            builder2.append(ErbAndRubyBreadcrumbsInfoProvider.getPresentation(start.getNode().getElementType()));
        }
        if (startOmit != null && (omitNodeType = startOmit.getNode().getElementType()) == ErbTokenTypes.OMIT_NEW_LINE) {
            builder2.append(ErbAndRubyBreadcrumbsInfoProvider.getPresentation(omitNodeType));
        }
        builder2.append("...");
        if (endOmit != null && startOmit != endOmit && (omitNodeType = endOmit.getNode().getElementType()) == ErbTokenTypes.OMIT_NEW_LINE) {
            builder2.append(ErbAndRubyBreadcrumbsInfoProvider.getPresentation(omitNodeType));
        }
        if (end != null) {
            builder2.append(ErbAndRubyBreadcrumbsInfoProvider.getPresentation(end.getNode().getElementType()));
        }
        return builder2.toString();
    }

    private static String getPresentation(@NotNull IElementType type) {
        if (type == null) {
            ErbAndRubyBreadcrumbsInfoProvider.$$$reportNull$$$0(5);
        }
        if (type instanceof PresentableElementType) {
            return ((PresentableElementType)type).getPresentableName();
        }
        return type.toString();
    }

    private static String getPresentation(@NotNull PsiElement psiElement, boolean notForToolTip) {
        ASTNode node;
        Language lang;
        if (psiElement == null) {
            ErbAndRubyBreadcrumbsInfoProvider.$$$reportNull$$$0(6);
        }
        if ((lang = ErbAndRubyBreadcrumbsInfoProvider.getLanguageForElement(psiElement)) != ErbLanguage.INSTANCE) {
            return psiElement.toString();
        }
        int startOffset = psiElement.getTextOffset();
        FileViewProvider viewProvider = psiElement.getContainingFile().getViewProvider();
        PsiElement realPsiElement = viewProvider.findElementAt(startOffset, (Language)ErbLanguage.INSTANCE);
        if (realPsiElement instanceof ErbCodeInjectionTag) {
            PsiElement startElem = realPsiElement.getFirstChild();
            node = startElem != null ? startElem.getNode() : null;
        } else {
            assert (realPsiElement != null);
            node = realPsiElement.getNode();
        }
        if (node != null) {
            IElementType type = node.getElementType();
            if (ErbTokenTypes.ERB_SEPARATORS_STARTS.contains(type) || ErbTokenTypes.ERB_SEPARATORS_ENDS.contains(type)) {
                if (notForToolTip) {
                    return ErbAndRubyBreadcrumbsInfoProvider.getPresentation(type);
                }
                PsiElement injection = node.getPsi().getParent();
                assert (injection != null);
                PsiElement start = injection.getFirstChild();
                PsiElement startOmit = start == null ? null : start.getNextSibling();
                PsiElement end = injection.getLastChild();
                PsiElement endOmit = end == null ? null : end.getPrevSibling();
                return ErbAndRubyBreadcrumbsInfoProvider.getInjectionPresentation(start, startOmit, end, endOmit);
            }
            if (type == ErbTokenTypes.OMIT_NEW_LINE) {
                return RBundle.message((String)"breadcrumbs.erb.presentation.omit.new.line");
            }
            if (ErbTokenTypes.ERB_ALL_COMMENT_TOKENS.contains(type)) {
                return notForToolTip ? RBundle.message((String)"breadcrumbs.erb.presentation.comment") : "<%#...%>";
            }
            if (type == ErbTokenTypes.RUBY_CODE_CHARACTERS) {
                return RBundle.message((String)"breadcrumbs.erb.presentation.ruby.injection");
            }
        }
        return realPsiElement.toString();
    }

    private static Language getLanguageForElement(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            ErbAndRubyBreadcrumbsInfoProvider.$$$reportNull$$$0(7);
        }
        if (psiElement instanceof PsiWhiteSpace) {
            return psiElement.getParent().getLanguage();
        }
        return psiElement.getLanguage();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/erb/html/ErbAndRubyBreadcrumbsInfoProvider";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/erb/html/ErbAndRubyBreadcrumbsInfoProvider";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "acceptElement";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getElementInfo";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getElementTooltip";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getParent";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getPresentation";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getLanguageForElement";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

