/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.erb.formatter;

import com.intellij.formatting.Block;
import com.intellij.formatting.FormattingContext;
import com.intellij.formatting.FormattingDocumentModel;
import com.intellij.formatting.FormattingModel;
import com.intellij.formatting.FormattingModelProvider;
import com.intellij.formatting.Indent;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.formatter.FormattingDocumentModelImpl;
import com.intellij.psi.formatter.xml.XmlFormattingPolicy;
import com.intellij.psi.templateLanguages.SimpleTemplateLanguageFormattingModelBuilder;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.erb.ErbFileViewProvider;
import org.jetbrains.plugins.ruby.erb.ErbLanguage;
import org.jetbrains.plugins.ruby.rails.langs.erb.lang.formatter.ErbPolicy;
import org.jetbrains.plugins.ruby.rails.langs.erb.lang.formatter.blocks.ErbBlock;
import org.jetbrains.plugins.ruby.rails.langs.erb.lang.formatter.blocks.ErbHtmlBlock;
import org.jetbrains.plugins.ruby.rails.langs.erb.lang.formatter.helpers.ErbFormatterUtil;
import org.jetbrains.plugins.ruby.rails.langs.erb.lang.formatter.helpers.ErbFormattingHelper;

public final class ErbFormattingModelBuilder
extends SimpleTemplateLanguageFormattingModelBuilder {
    private static final boolean DUMP_FORMATTING_MODEL = false;

    @NotNull
    public FormattingModel createModel(@NotNull FormattingContext formattingContext) {
        PsiFile psiFile;
        TemplateLanguageFileViewProvider vProvider;
        Language templateLang;
        if (formattingContext == null) {
            ErbFormattingModelBuilder.$$$reportNull$$$0(0);
        }
        if ((templateLang = (vProvider = (TemplateLanguageFileViewProvider)(psiFile = formattingContext.getContainingFile()).getViewProvider()).getTemplateDataLanguage()) instanceof XMLLanguage || templateLang instanceof ErbLanguage) {
            FormattingModel formattingModel = ErbFormattingModelBuilder.createErbFormattingModel(formattingContext);
            if (formattingModel == null) {
                ErbFormattingModelBuilder.$$$reportNull$$$0(1);
            }
            return formattingModel;
        }
        FormattingModel formattingModel = super.createModel(formattingContext);
        if (formattingModel == null) {
            ErbFormattingModelBuilder.$$$reportNull$$$0(2);
        }
        return formattingModel;
    }

    private static FormattingModel createErbFormattingModel(@NotNull FormattingContext formattingContext) {
        Object block;
        if (formattingContext == null) {
            ErbFormattingModelBuilder.$$$reportNull$$$0(3);
        }
        PsiFile psiFile = formattingContext.getContainingFile();
        PsiElement element = formattingContext.getPsiElement();
        FileViewProvider vProvider = psiFile.getViewProvider();
        CodeStyleSettings settings = formattingContext.getCodeStyleSettings();
        FormattingDocumentModelImpl documentModel = FormattingDocumentModelImpl.createOn((PsiFile)psiFile);
        ErbFormattingHelper formattingHelper = new ErbFormattingHelper((XmlFormattingPolicy)new ErbPolicy(settings, (FormattingDocumentModel)documentModel), formattingContext);
        ASTNode node = formattingContext.getNode();
        if (node.getElementType() == XmlElementType.HTML_DOCUMENT) {
            PsiElement erbElement = ErbFormatterUtil.findErbElementByStartOffset(vProvider, node.getStartOffset(), true);
            assert (erbElement != null);
            ASTNode rhmtlElementNode = erbElement.getNode();
            assert (rhmtlElementNode != null);
            block = new ErbBlock(rhmtlElementNode, Indent.getNoneIndent(), null, formattingHelper);
        } else {
            block = vProvider instanceof ErbFileViewProvider && (element instanceof XmlAttribute || element instanceof XmlAttributeValue) ? new ErbHtmlBlock(node, null, null, formattingHelper, Indent.getNoneIndent(), vProvider, element.getTextRange()) : new ErbBlock(node, Indent.getAbsoluteNoneIndent(), null, formattingHelper);
        }
        return FormattingModelProvider.createFormattingModelForPsiFile((PsiFile)psiFile, (Block)block, (CodeStyleSettings)settings);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formattingContext";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/erb/formatter/ErbFormattingModelBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/erb/formatter/ErbFormattingModelBuilder";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createModel";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createErbFormattingModel";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }
}

