/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.erb.codeInsight;

import com.intellij.codeInsight.editorActions.smartEnter.SmartEnterProcessor;
import com.intellij.ide.DataManager;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import java.awt.Component;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.erb.ErbLanguage;
import org.jetbrains.plugins.ruby.erb.codeInsight.ErbEditUtil;
import org.jetbrains.plugins.ruby.erb.psi.ErbCodeInjectionTag;
import org.jetbrains.plugins.ruby.erb.psi.ErbRubyFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RBlockStatement;

public final class ErbRubySmartEnterProcessor
extends SmartEnterProcessor {
    @NonNls
    private static final String END_TAG = "<% end %>";

    public boolean process(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile psiFile) {
        PsiElement injectionTag;
        if (project == null) {
            ErbRubySmartEnterProcessor.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            ErbRubySmartEnterProcessor.$$$reportNull$$$0(1);
        }
        if (psiFile == null) {
            ErbRubySmartEnterProcessor.$$$reportNull$$$0(2);
        }
        if (!(psiFile instanceof ErbRubyFile)) {
            return false;
        }
        int offset = editor.getCaretModel().getOffset();
        FileViewProvider viewProvider = psiFile.getViewProvider();
        PsiElement erbAtCaret = viewProvider.findElementAt(offset, (Language)ErbLanguage.INSTANCE);
        return erbAtCaret != null && erbAtCaret.getParent() instanceof ErbCodeInjectionTag && this.processEnterInRubyInjection(editor, psiFile, injectionTag = erbAtCaret.getParent());
    }

    private boolean processEnterInRubyInjection(Editor editor, PsiFile psiFile, PsiElement injectionTag) {
        PsiElement atCaret = this.getStatementAtCaret(editor, psiFile);
        int erbStartOffset = injectionTag.getTextRange().getStartOffset();
        int erbEndOffset = injectionTag.getTextRange().getEndOffset();
        RBlockStatement stmt = ErbRubySmartEnterProcessor.findUnclosedBlockStatement(atCaret);
        if (stmt != null) {
            String whitespaceText = ErbEditUtil.getIndentAt(psiFile, erbStartOffset);
            editor.getDocument().insertString(erbEndOffset, (CharSequence)("\n" + whitespaceText + END_TAG));
            editor.getCaretModel().moveToOffset(erbEndOffset);
            EditorActionHandler handler = EditorActionManager.getInstance().getActionHandler("EditorEnter");
            handler.execute(editor, editor.getCaretModel().getCurrentCaret(), DataManager.getInstance().getDataContext((Component)editor.getComponent()));
            return true;
        }
        return false;
    }

    @Nullable
    private static RBlockStatement findUnclosedBlockStatement(PsiElement atCaret) {
        RBlockStatement statement = (RBlockStatement)PsiTreeUtil.getParentOfType((PsiElement)atCaret, RBlockStatement.class);
        while (statement != null) {
            if (statement.getEndToken() == null) {
                return statement;
            }
            statement = (RBlockStatement)PsiTreeUtil.getParentOfType((PsiElement)statement, RBlockStatement.class);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "editor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "psiFile";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/plugins/ruby/erb/codeInsight/ErbRubySmartEnterProcessor";
        objectArray[2] = "process";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

