/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.erb.codeInsight;

import com.intellij.lang.Language;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.erb.ErbLanguage;
import org.jetbrains.plugins.ruby.erb.psi.ErbCodeInjectionTag;
import org.jetbrains.plugins.ruby.erb.psi.ErbTokenTypes;

public final class ErbEditUtil {
    private ErbEditUtil() {
    }

    public static String getIndentAt(PsiFile psiFile, int erbStartOffset) {
        int pos;
        PsiElement element;
        String whitespaceText = "";
        if (erbStartOffset > 0 && (element = psiFile.findElementAt(erbStartOffset - 1)) instanceof PsiWhiteSpace && (pos = (whitespaceText = element.getText()).lastIndexOf(10)) >= 0) {
            whitespaceText = whitespaceText.substring(pos + 1);
        }
        return whitespaceText;
    }

    public static boolean isInsideMultilineErbTag(@NotNull FileViewProvider viewProvider, int offset) {
        PsiElement erbElement;
        if (viewProvider == null) {
            ErbEditUtil.$$$reportNull$$$0(0);
        }
        if (ErbTokenTypes.ERB_SEPARATORS_ENDS.contains(PsiUtilCore.getElementType((PsiElement)(erbElement = viewProvider.findElementAt(offset, (Language)ErbLanguage.INSTANCE))))) {
            return false;
        }
        ErbCodeInjectionTag injectionTag = (ErbCodeInjectionTag)PsiTreeUtil.getParentOfType((PsiElement)erbElement, ErbCodeInjectionTag.class);
        if (injectionTag == null) {
            return false;
        }
        int offsetInTag = offset - injectionTag.getTextOffset() - injectionTag.getFirstChild().getTextLength();
        return injectionTag.getTagText().substring(0, offsetInTag).contains("\n");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewProvider", "org/jetbrains/plugins/ruby/erb/codeInsight/ErbEditUtil", "isInsideMultilineErbTag"));
    }
}

