/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.erb;

import com.intellij.lang.Language;
import com.intellij.lang.injection.MultiHostInjector;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.erb.ErbFileViewProvider;
import org.jetbrains.plugins.ruby.erb.psi.ErbTokenTypes;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.basicTypes.stringLiterals.RBaseStringImpl;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.controlStructures.blocks.RCompoundStatementImpl;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RDoBlockCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RDoCodeBlock;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;

public final class ErbJSInjector
implements MultiHostInjector {
    public void getLanguagesToInject(@NotNull MultiHostRegistrar registrar, @NotNull PsiElement context) {
        TextRange rangeInHost;
        RBaseStringImpl host;
        RPossibleCall possibleCall;
        PsiFile containingFile;
        if (registrar == null) {
            ErbJSInjector.$$$reportNull$$$0(0);
        }
        if (context == null) {
            ErbJSInjector.$$$reportNull$$$0(1);
        }
        if ((containingFile = context.getContainingFile()) == null || !(containingFile.getViewProvider() instanceof ErbFileViewProvider)) {
            return;
        }
        if (context instanceof RCall) {
            possibleCall = (RPossibleCall)context;
        } else if (context.getParent() instanceof RDoBlockCall) {
            possibleCall = ((RDoBlockCall)context.getParent()).getCall();
        } else {
            return;
        }
        String command = possibleCall.getCommand();
        if (command == null || !command.equals("javascript_tag")) {
            return;
        }
        Language js = Language.findLanguageByID((String)"JavaScript");
        if (js == null) {
            return;
        }
        if (context instanceof RCall) {
            List arguments = possibleCall.getArguments();
            if (arguments.isEmpty()) {
                return;
            }
            if (!(arguments.get(0) instanceof RBaseStringImpl)) {
                return;
            }
            host = (RBaseStringImpl)arguments.get(0);
            rangeInHost = new TextRange(1, host.getTextLength() - 1);
        } else {
            RCompoundStatementImpl compoundStatement = (RCompoundStatementImpl)PsiTreeUtil.findChildOfType((PsiElement)context, RCompoundStatementImpl.class);
            if (compoundStatement == null) {
                return;
            }
            int compoundStatementStartOffset = compoundStatement.getText().indexOf(ErbTokenTypes.ERB_SCRIPTLET_END.toString()) + ErbTokenTypes.ERB_SCRIPTLET_END.toString().length();
            int compoundStatementEndOffset = compoundStatement.getText().indexOf(ErbTokenTypes.ERB_SCRIPTLET_START.toString());
            host = compoundStatement;
            rangeInHost = TextRange.create((int)compoundStatementStartOffset, (int)compoundStatementEndOffset);
        }
        if (host.isValidHost()) {
            registrar.startInjecting(js);
            registrar.addPlace(null, null, (PsiLanguageInjectionHost)host, rangeInHost);
            registrar.doneInjecting();
        }
    }

    @NotNull
    public List<? extends Class<? extends PsiElement>> elementsToInjectIn() {
        List<Class> list = Arrays.asList(RDoCodeBlock.class, RCall.class);
        if (list == null) {
            ErbJSInjector.$$$reportNull$$$0(2);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/erb/ErbJSInjector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/erb/ErbJSInjector";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "elementsToInjectIn";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLanguagesToInject";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

