/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.erb;

import com.intellij.lang.Language;
import com.intellij.lang.injection.MultiHostInjector;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.impl.source.tree.PsiCommentImpl;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.text.CharArrayUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.plugins.ruby.erb.psi.ErbTokenTypes;

public final class ErbGraphQLInjector
implements MultiHostInjector {
    @TestOnly
    public static final Key<TextRange> GRAPHQL_INJECTION_RANGE = Key.create((String)"GRAPHQL_INJECTION_RANGE");
    private static final List<? extends Class<? extends PsiElement>> INJECTABLES = Collections.singletonList(PsiCommentImpl.class);

    public void getLanguagesToInject(@NotNull MultiHostRegistrar registrar, @NotNull PsiElement context) {
        if (registrar == null) {
            ErbGraphQLInjector.$$$reportNull$$$0(0);
        }
        if (context == null) {
            ErbGraphQLInjector.$$$reportNull$$$0(1);
        }
        if (!ErbGraphQLInjector.isGraphQLExtension(context)) {
            return;
        }
        Language graphQLLanguage = Language.findLanguageByID((String)"GraphQL");
        if (graphQLLanguage == null) {
            return;
        }
        TextRange injectionRange = ErbGraphQLInjector.computeInjectionRange(context);
        if (injectionRange == null) {
            return;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            context.getProject().putUserData(GRAPHQL_INJECTION_RANGE, (Object)injectionRange);
            return;
        }
        registrar.startInjecting(graphQLLanguage);
        registrar.addPlace("", "", (PsiLanguageInjectionHost)context, injectionRange);
        registrar.doneInjecting();
    }

    @NotNull
    public List<? extends Class<? extends PsiElement>> elementsToInjectIn() {
        List<? extends Class<? extends PsiElement>> list = INJECTABLES;
        if (list == null) {
            ErbGraphQLInjector.$$$reportNull$$$0(2);
        }
        return list;
    }

    @Contract(value="null->false")
    private static boolean isGraphQLExtension(@Nullable PsiElement psiElement) {
        if (psiElement == null) {
            return false;
        }
        return PsiUtilCore.getElementType((PsiElement)psiElement) == ErbTokenTypes.GRAPHQL_TEMPLATE_BLOCK && PsiUtilCore.getElementType((PsiElement)psiElement.getPrevSibling()) == ErbTokenTypes.ERB_GRAPHQL_START;
    }

    @Nullable
    private static TextRange computeInjectionRange(@NotNull PsiElement psiElement) {
        int endOffset;
        CharSequence nodeChars;
        int startOffset;
        if (psiElement == null) {
            ErbGraphQLInjector.$$$reportNull$$$0(3);
        }
        if ((startOffset = CharArrayUtil.shiftForward((CharSequence)(nodeChars = psiElement.getNode().getChars()), (int)0, (String)" \t\n\r")) >= (endOffset = CharArrayUtil.shiftBackward((CharSequence)nodeChars, (int)(nodeChars.length() - 1), (String)" \t\n\r") + 1)) {
            return null;
        }
        return TextRange.create((int)startOffset, (int)endOffset);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/erb/ErbGraphQLInjector";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/erb/ErbGraphQLInjector";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "elementsToInjectIn";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLanguagesToInject";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "computeInjectionRange";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

