/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.erb;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.LanguageSubstitutors;
import com.intellij.psi.MultiplePsiFilesPerDocumentFileViewProvider;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.templateLanguages.TemplateLanguage;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.ILightStubFileElementType;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.erb.ErbElementTypes;
import org.jetbrains.plugins.ruby.erb.ErbLanguage;
import org.jetbrains.plugins.ruby.erb.psi.impl.ErbRubyFileImpl;
import org.jetbrains.plugins.ruby.erb.ruby.ErbRubyLanguage;
import org.jetbrains.plugins.ruby.ruby.lang.RubyLanguage;

public class ErbFileViewProvider
extends MultiplePsiFilesPerDocumentFileViewProvider
implements TemplateLanguageFileViewProvider {
    private static final Logger LOG = Logger.getInstance(ErbFileViewProvider.class);
    private final Language myTemplateDataLanguage = this.computeTemplateDataLanguage();

    public ErbFileViewProvider(PsiManager manager, VirtualFile virtualFile, boolean physical) {
        super(manager, virtualFile, physical);
    }

    @NotNull
    public Language getBaseLanguage() {
        ErbLanguage erbLanguage = ErbLanguage.INSTANCE;
        if (erbLanguage == null) {
            ErbFileViewProvider.$$$reportNull$$$0(0);
        }
        return erbLanguage;
    }

    @NotNull
    public Language getTemplateDataLanguage() {
        Language language = this.myTemplateDataLanguage;
        if (language == null) {
            ErbFileViewProvider.$$$reportNull$$$0(1);
        }
        return language;
    }

    @NotNull
    private Language computeTemplateDataLanguage() {
        Language language;
        String name = this.getVirtualFile().getName();
        String shortName = name.endsWith(".erb") ? name.substring(0, name.length() - 4) : name;
        int dot = shortName.lastIndexOf(46);
        if (dot >= 0 && !((language = this.getLanguageByExtension(shortName.substring(dot + 1))) instanceof TemplateLanguage)) {
            if (LanguageParserDefinitions.INSTANCE.forLanguage(language) != null) {
                Language language2 = language;
                if (language2 == null) {
                    ErbFileViewProvider.$$$reportNull$$$0(2);
                }
                return language2;
            }
            LOG.warn("No parser definition found for [" + String.valueOf(language) + "], in file " + name + " falling back to plain text");
            PlainTextLanguage plainTextLanguage = PlainTextLanguage.INSTANCE;
            if (plainTextLanguage == null) {
                ErbFileViewProvider.$$$reportNull$$$0(3);
            }
            return plainTextLanguage;
        }
        HTMLLanguage hTMLLanguage = HTMLLanguage.INSTANCE;
        if (hTMLLanguage == null) {
            ErbFileViewProvider.$$$reportNull$$$0(4);
        }
        return hTMLLanguage;
    }

    private Language getLanguageByExtension(@NotNull String ext) {
        FileType fileType;
        if (ext == null) {
            ErbFileViewProvider.$$$reportNull$$$0(5);
        }
        if (!((fileType = FileTypeManager.getInstance().getFileTypeByExtension(ext)) instanceof LanguageFileType)) {
            return HTMLLanguage.INSTANCE;
        }
        Language language = ((LanguageFileType)fileType).getLanguage();
        if (language instanceof RubyLanguage) {
            return ErbRubyLanguage.INSTANCE;
        }
        if ("plist".equalsIgnoreCase(ext)) {
            return XMLLanguage.INSTANCE;
        }
        Language substituted = LanguageSubstitutors.getInstance().substituteLanguage(language, this.getVirtualFile(), this.getManager().getProject());
        if (substituted != ErbLanguage.INSTANCE) {
            return substituted;
        }
        if (language != ErbLanguage.INSTANCE) {
            return language;
        }
        return HTMLLanguage.INSTANCE;
    }

    @NotNull
    public Set<Language> getLanguages() {
        Set<Language> set = Set.of(ErbLanguage.INSTANCE, RubyLanguage.INSTANCE, this.myTemplateDataLanguage);
        if (set == null) {
            ErbFileViewProvider.$$$reportNull$$$0(6);
        }
        return set;
    }

    @Nullable
    public IElementType getContentElementType(@NotNull Language language) {
        if (language == null) {
            ErbFileViewProvider.$$$reportNull$$$0(7);
        }
        if (language == RubyLanguage.INSTANCE) {
            return ErbElementTypes.RUBY_CODE_IN_ERB_ROOT;
        }
        if (language == this.getTemplateDataLanguage()) {
            return ErbElementTypes.TEMPLATE_DATA;
        }
        return null;
    }

    @NotNull
    protected MultiplePsiFilesPerDocumentFileViewProvider cloneInner(@NotNull VirtualFile copy) {
        if (copy == null) {
            ErbFileViewProvider.$$$reportNull$$$0(8);
        }
        return new ErbFileViewProvider((PsiManager)this.getManager(), copy, false);
    }

    protected PsiFile createFile(@NotNull Language lang) {
        if (lang == null) {
            ErbFileViewProvider.$$$reportNull$$$0(9);
        }
        if (lang == RubyLanguage.INSTANCE) {
            return new ErbRubyFileImpl((FileViewProvider)this);
        }
        if (lang == this.getTemplateDataLanguage()) {
            ParserDefinition def = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(lang);
            PsiFileImpl file = (PsiFileImpl)def.createFile((FileViewProvider)this);
            if (!(file.getContentElementType() instanceof ILightStubFileElementType)) {
                file.setContentElementType((IElementType)ErbElementTypes.TEMPLATE_DATA);
            }
            return file;
        }
        if (lang == this.getBaseLanguage()) {
            ParserDefinition def = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(lang);
            assert (def != null);
            return def.createFile((FileViewProvider)this);
        }
        return null;
    }

    @NotNull
    public PsiFile getStubBindingRoot() {
        PsiFile psi = this.getPsi((Language)RubyLanguage.INSTANCE);
        assert (psi != null);
        PsiFile psiFile = psi;
        if (psiFile == null) {
            ErbFileViewProvider.$$$reportNull$$$0(10);
        }
        return psiFile;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 5, 7, 8, 9 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/erb/ErbFileViewProvider";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ext";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copy";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lang";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseLanguage";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplateDataLanguage";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "computeTemplateDataLanguage";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/erb/ErbFileViewProvider";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguages";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getStubBindingRoot";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getLanguageByExtension";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getContentElementType";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "cloneInner";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 5, 7, 8, 9 -> new IllegalArgumentException(string);
        };
    }
}

