/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.erb;

import com.intellij.codeInsight.generation.CommenterDataHolder;
import com.intellij.codeInsight.generation.SelfManagingCommenter;
import com.intellij.lang.Commenter;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageCommenters;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveVisitor;
import com.intellij.psi.TokenType;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.erb.ErbFileViewProvider;
import org.jetbrains.plugins.ruby.erb.psi.ErbTokenTypes;
import org.jetbrains.plugins.ruby.erb.psi.IErbElementType;
import org.jetbrains.plugins.ruby.erb.psi.IErbOuterElementType;
import org.jetbrains.plugins.ruby.erb.psi.impl.ErbCommentImpl;

public final class ErbCommenter
implements Commenter,
SelfManagingCommenter<ErbCommenterData> {
    public static final String XML_COMMENT_PREFIX = "<!--";
    private static final TokenSet RUBY_INJECTION_START_ELEMENTS = TokenSet.create((IElementType[])new IElementType[]{ErbTokenTypes.ERB_SCRIPTLET_START, ErbTokenTypes.ERB_EXPRESSION_START, ErbTokenTypes.ERB_RAW_EXPRESSION_START});

    @Nullable
    public ErbCommenterData createLineCommentingState(int startLine, int endLine, @NotNull Document document, @NotNull PsiFile file) {
        if (document == null) {
            ErbCommenter.$$$reportNull$$$0(0);
        }
        if (file == null) {
            ErbCommenter.$$$reportNull$$$0(1);
        }
        return new ErbCommenterData(file);
    }

    @Nullable
    public ErbCommenterData createBlockCommentingState(int selectionStart, int selectionEnd, @NotNull Document document, @NotNull PsiFile file) {
        if (document == null) {
            ErbCommenter.$$$reportNull$$$0(2);
        }
        if (file == null) {
            ErbCommenter.$$$reportNull$$$0(3);
        }
        return new ErbCommenterData(file);
    }

    public void commentLine(int line, int offset, @NotNull Document document, @NotNull ErbCommenterData data) {
        if (document == null) {
            ErbCommenter.$$$reportNull$$$0(4);
        }
        if (data == null) {
            ErbCommenter.$$$reportNull$$$0(5);
        }
        if (this.isLineCommented(line, offset, document, data)) {
            return;
        }
        int lineEndOffset = line < document.getLineCount() - 1 ? document.getLineStartOffset(line + 1) - 1 : document.getTextLength();
        ErbCommenter.commentCode(offset, lineEndOffset, document, data.myFile, false);
    }

    public void uncommentLine(int line, int offset, @NotNull Document document, @NotNull ErbCommenterData data) {
        if (document == null) {
            ErbCommenter.$$$reportNull$$$0(6);
        }
        if (data == null) {
            ErbCommenter.$$$reportNull$$$0(7);
        }
        if (!this.isLineCommented(line, offset, document, data)) {
            return;
        }
        int lineEndOffset = document.getLineEndOffset(line);
        ErbCommenter.uncommentCode(offset, lineEndOffset, document, data.myFile);
    }

    public boolean isLineCommented(int line, int offset, @NotNull Document document, @NotNull ErbCommenterData data) {
        PsiElement element;
        if (document == null) {
            ErbCommenter.$$$reportNull$$$0(8);
        }
        if (data == null) {
            ErbCommenter.$$$reportNull$$$0(9);
        }
        return PsiTreeUtil.getParentOfType((PsiElement)(element = data.myFile.findElementAt(offset)), PsiComment.class, (boolean)false) != null;
    }

    @Nullable
    public String getCommentPrefix(int line, @NotNull Document document, @NotNull ErbCommenterData data) {
        if (document == null) {
            ErbCommenter.$$$reportNull$$$0(10);
        }
        if (data == null) {
            ErbCommenter.$$$reportNull$$$0(11);
        }
        return null;
    }

    @Nullable
    public TextRange getBlockCommentRange(int selectionStart, int selectionEnd, @NotNull Document document, @NotNull ErbCommenterData data) {
        PsiElement elementAtStartOffset;
        PsiComment comment;
        if (document == null) {
            ErbCommenter.$$$reportNull$$$0(12);
        }
        if (data == null) {
            ErbCommenter.$$$reportNull$$$0(13);
        }
        if ((comment = (PsiComment)PsiTreeUtil.getParentOfType((PsiElement)(elementAtStartOffset = data.myFile.findElementAt(selectionStart)), PsiComment.class, (boolean)false)) != null) {
            return comment.getTextRange();
        }
        return null;
    }

    @Nullable
    public String getBlockCommentPrefix(int selectionStart, @NotNull Document document, @NotNull ErbCommenterData data) {
        if (document == null) {
            ErbCommenter.$$$reportNull$$$0(14);
        }
        if (data == null) {
            ErbCommenter.$$$reportNull$$$0(15);
        }
        return "";
    }

    @Nullable
    public String getBlockCommentSuffix(int selectionEnd, @NotNull Document document, @NotNull ErbCommenterData data) {
        if (document == null) {
            ErbCommenter.$$$reportNull$$$0(16);
        }
        if (data == null) {
            ErbCommenter.$$$reportNull$$$0(17);
        }
        return "";
    }

    public void uncommentBlockComment(int startOffset, int endOffset, Document document, ErbCommenterData data) {
        ErbCommenter.uncommentCode(startOffset, endOffset, document, data.myFile);
    }

    @NotNull
    public TextRange insertBlockComment(int startOffset, int endOffset, Document document, ErbCommenterData data) {
        TextRange commentRange = this.getBlockCommentRange(startOffset, endOffset, document, data);
        if (commentRange != null && (commentRange.getStartOffset() < startOffset || endOffset < commentRange.getEndOffset())) {
            return new TextRange(startOffset, endOffset);
        }
        int lengthBefore = document.getTextLength();
        ErbCommenter.commentCode(startOffset, endOffset, document, data.myFile, true);
        return new TextRange(startOffset, endOffset + document.getTextLength() - lengthBefore);
    }

    @Nullable
    public String getLineCommentPrefix() {
        return XML_COMMENT_PREFIX;
    }

    @Nullable
    public String getBlockCommentPrefix() {
        return null;
    }

    @Nullable
    public String getBlockCommentSuffix() {
        return null;
    }

    @Nullable
    public String getCommentedBlockCommentPrefix() {
        return null;
    }

    @Nullable
    public String getCommentedBlockCommentSuffix() {
        return null;
    }

    private static void commentCode(int startOffset, int endOffset, @NotNull Document document, @NotNull PsiFile psiFile, boolean blockComment) {
        Commenter templateLanguageCommenter;
        if (document == null) {
            ErbCommenter.$$$reportNull$$$0(18);
        }
        if (psiFile == null) {
            ErbCommenter.$$$reportNull$$$0(19);
        }
        if ((templateLanguageCommenter = ErbCommenter.getTemplateLanguageCommenter(psiFile)) == null) {
            return;
        }
        int startLineNumber = document.getLineNumber(startOffset);
        int endLineNumber = document.getLineNumber(Math.max(startOffset, endOffset - 1));
        int documentLengthBeforeCommenting = document.getTextLength();
        ErbElementVisitor erbElementVisitor = new ErbElementVisitor(document);
        String blockCommentWrapedWithNewLine = (startOffset == 0 || document.getCharsSequence().charAt(startOffset - 1) == '\n') && endOffset > 0 && document.getCharsSequence().charAt(endOffset - 1) == '\n' ? "\n" : "";
        for (int i = endLineNumber; i >= startLineNumber; --i) {
            int lineEndOffset = document.getLineEndOffset(i);
            int lineStartOffset = document.getLineStartOffset(i);
            boolean templateCommentNeeded = false;
            PsiElement current = psiFile.findElementAt(document.getLineEndOffset(i) - 1);
            while (current != null && current.getNode().getStartOffset() >= lineStartOffset) {
                PsiElement previous;
                erbElementVisitor.visitElement(current);
                IElementType elementType = current.getNode().getElementType();
                if (elementType != TokenType.WHITE_SPACE && !(elementType instanceof IErbElementType) && !(elementType instanceof IErbOuterElementType)) {
                    templateCommentNeeded = true;
                }
                if ((previous = current.getPrevSibling()) == null && current.getNode().getStartOffset() > 0) {
                    previous = psiFile.findElementAt(current.getNode().getStartOffset() - 1);
                }
                current = previous;
            }
            int addedOffset = document.getTextLength() - documentLengthBeforeCommenting;
            if (blockComment) {
                if (i == endLineNumber) {
                    document.insertString(endOffset + addedOffset, (CharSequence)(templateLanguageCommenter.getBlockCommentSuffix() + blockCommentWrapedWithNewLine));
                }
                if (i != startLineNumber) continue;
                document.insertString(startOffset, (CharSequence)(templateLanguageCommenter.getBlockCommentPrefix() + blockCommentWrapedWithNewLine));
                continue;
            }
            if (!templateCommentNeeded) continue;
            String lineCommentPrefix = templateLanguageCommenter.getLineCommentPrefix();
            if (lineCommentPrefix != null) {
                document.insertString(lineStartOffset, (CharSequence)lineCommentPrefix);
                continue;
            }
            document.insertString(lineEndOffset + addedOffset, (CharSequence)templateLanguageCommenter.getBlockCommentSuffix());
            document.insertString(lineStartOffset, (CharSequence)templateLanguageCommenter.getBlockCommentPrefix());
        }
    }

    private static void uncommentCode(int startOffset, int endOffset, @NotNull Document document, @NotNull PsiFile psiFile) {
        PsiElement current;
        Commenter templateLanguageCommenter;
        if (document == null) {
            ErbCommenter.$$$reportNull$$$0(20);
        }
        if (psiFile == null) {
            ErbCommenter.$$$reportNull$$$0(21);
        }
        if ((templateLanguageCommenter = ErbCommenter.getTemplateLanguageCommenter(psiFile)) == null) {
            return;
        }
        String lineCommentPrefix = templateLanguageCommenter.getLineCommentPrefix();
        String blockCommentPrefix = templateLanguageCommenter.getBlockCommentPrefix();
        String blockCommentSuffix = templateLanguageCommenter.getBlockCommentSuffix();
        String elementText = ErbCommenter.getElementTextAt(endOffset - 1, psiFile);
        if (elementText == null) {
            return;
        }
        if (blockCommentSuffix != null && elementText.endsWith(blockCommentSuffix)) {
            int commentSuffixOffset = endOffset - blockCommentSuffix.length();
            document.deleteString(commentSuffixOffset, endOffset);
            if (commentSuffixOffset > 0 && document.getCharsSequence().charAt(commentSuffixOffset - 1) == '\n') {
                document.deleteString(commentSuffixOffset - 1, commentSuffixOffset);
            }
        }
        while ((current = psiFile.findElementAt(endOffset - 1)) != null) {
            PsiElement erbComment = PsiTreeUtil.getParentOfType((PsiElement)current, ErbCommentImpl.class);
            if (erbComment != null && erbComment.getNode().getStartOffset() >= startOffset && (current = erbComment.getFirstChild()).getNode().getElementType() == ErbTokenTypes.ERB_COMMENT_START) {
                document.deleteString(current.getNode().getStartOffset() + 2, current.getNode().getStartOffset() + 3);
            }
            if (current.getNode().getStartOffset() > startOffset && (endOffset = current.getNode().getStartOffset()) > startOffset) continue;
        }
        if ((elementText = ErbCommenter.getElementTextAt(startOffset, psiFile)) != null) {
            if (blockCommentPrefix != null && elementText.startsWith(blockCommentPrefix)) {
                int blockCommentPrefixEndOffset = startOffset + blockCommentPrefix.length();
                if (blockCommentPrefixEndOffset < document.getTextLength() && document.getCharsSequence().charAt(blockCommentPrefixEndOffset) == '\n') {
                    document.deleteString(blockCommentPrefixEndOffset, blockCommentPrefixEndOffset + 1);
                }
                document.deleteString(startOffset, blockCommentPrefixEndOffset);
            } else if (lineCommentPrefix != null && elementText.startsWith(lineCommentPrefix)) {
                document.deleteString(startOffset, startOffset + lineCommentPrefix.length());
            }
        }
    }

    @Nullable
    private static Commenter getTemplateLanguageCommenter(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            ErbCommenter.$$$reportNull$$$0(22);
        }
        if (!(psiFile.getViewProvider() instanceof ErbFileViewProvider)) {
            return null;
        }
        Language templateLanguage = ((ErbFileViewProvider)psiFile.getViewProvider()).getTemplateDataLanguage();
        return (Commenter)LanguageCommenters.INSTANCE.forLanguage(templateLanguage);
    }

    @Nullable
    private static String getElementTextAt(int offset, @NotNull PsiFile psiFile) {
        PsiElement current;
        if (psiFile == null) {
            ErbCommenter.$$$reportNull$$$0(23);
        }
        return (current = psiFile.findElementAt(offset)) != null ? current.getText() : null;
    }

    private static boolean isRubyInjectionStart(PsiElement current) {
        IElementType elementType = PsiUtilCore.getElementType((PsiElement)current);
        return RUBY_INJECTION_START_ELEMENTS.contains(elementType) || current instanceof OuterLanguageElement && elementType == ErbTokenTypes.ERB_INJECTION_IN_HTML;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 19: 
            case 21: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/erb/ErbCommenter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createLineCommentingState";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createBlockCommentingState";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "commentLine";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "uncommentLine";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "isLineCommented";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "getCommentPrefix";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "getBlockCommentRange";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "getBlockCommentPrefix";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "getBlockCommentSuffix";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "commentCode";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[2] = "uncommentCode";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[2] = "getTemplateLanguageCommenter";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[2] = "getElementTextAt";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static class ErbCommenterData
    extends CommenterDataHolder {
        @NotNull
        PsiFile myFile;

        ErbCommenterData(@NotNull PsiFile file) {
            if (file == null) {
                ErbCommenterData.$$$reportNull$$$0(0);
            }
            this.myFile = file;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/plugins/ruby/erb/ErbCommenter$ErbCommenterData", "<init>"));
        }
    }

    private static class ErbElementVisitor
    extends PsiElementVisitor
    implements PsiRecursiveVisitor {
        private final Document myDocument;

        ErbElementVisitor(Document document) {
            this.myDocument = document;
        }

        public void visitElement(@NotNull PsiElement element) {
            if (element == null) {
                ErbElementVisitor.$$$reportNull$$$0(0);
            }
            super.visitElement(element);
            if (ErbCommenter.isRubyInjectionStart(element)) {
                this.myDocument.insertString(element.getNode().getStartOffset() + 2, (CharSequence)"#");
            } else {
                PsiElement[] children = element.getChildren();
                for (int i = children.length - 1; i >= 0; --i) {
                    this.visitElement(children[i]);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/ruby/erb/ErbCommenter$ErbElementVisitor", "visitElement"));
        }
    }
}

