/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.dsl;

import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.gem.GemUtil;
import org.jetbrains.plugins.ruby.gem.bundler.BundlerParamDefProvider;
import org.jetbrains.plugins.ruby.gem.util.BundlerUtil;
import org.jetbrains.plugins.ruby.rack.RackUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.RubySymbolProvider;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.v2.ClassModuleSymbolWithMixins;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.tasks.capistrano.CapistranoUtil;
import org.jetbrains.plugins.ruby.tasks.rake.RakeUtilBase;

final class RubySpecialFilesSymbolProvider
implements RubySymbolProvider {
    private static final FQN GEM_SPECIFICATION_FQN = FQN.of((String)"Gem::Specification");
    private static final FQN CAPISTRANO_CONFIGURATION_FQN = FQN.of((String)"Capistrano::Configuration");
    private static final FQN RAKE_DSL_FQN = FQN.of((String)"Rake::DSL");
    private static final FQN GUARD_DSL_FQN = FQN.of((String)"Guard::Dsl");
    private static final FQN RACK_DSL_FQN = FQN.of((String)"Rack::Builder");
    private static final Collection<Pair<Predicate<VirtualFile>, FQN>> PROVIDERS = List.of(Pair.create(BundlerUtil::isGemfile, (Object)BundlerParamDefProvider.BUNDLER_CONTEXT_FQN), Pair.create(GemUtil::isGemspecFile, (Object)GEM_SPECIFICATION_FQN), Pair.create(file -> CapistranoUtil.isCapfile(file) || CapistranoUtil.isDeployFile(file), (Object)CAPISTRANO_CONFIGURATION_FQN), Pair.create(RakeUtilBase::isRakeFileByNamingConventions, (Object)RAKE_DSL_FQN), Pair.create(RubySpecialFilesSymbolProvider::isGuardFile, (Object)GUARD_DSL_FQN), Pair.create(RackUtil::isRackConfig, (Object)RACK_DSL_FQN));

    RubySpecialFilesSymbolProvider() {
    }

    @Override
    public Symbol createSymbolByContainer(@NotNull RContainer container, @NotNull FQN fqn, @Nullable Symbol parent) {
        if (container == null) {
            RubySpecialFilesSymbolProvider.$$$reportNull$$$0(0);
        }
        if (fqn == null) {
            RubySpecialFilesSymbolProvider.$$$reportNull$$$0(1);
        }
        if (!(container instanceof PsiFile) || DumbService.isDumb((Project)container.getProject())) {
            return null;
        }
        VirtualFile virtualFile = RubyPsiUtil.getVirtualFileFromElement((PsiElement)container);
        if (virtualFile == null) {
            return null;
        }
        for (Pair<Predicate<VirtualFile>, FQN> fqnProvider : PROVIDERS) {
            Symbol dsl;
            if (!((Predicate)fqnProvider.getFirst()).test(virtualFile) || (dsl = SymbolUtil.findConstantByFQN(container.getProject(), (FQN)fqnProvider.getSecond(), (PsiElement)container)) == null) continue;
            return new ClassModuleSymbolWithMixins(container, null, Collections.singletonList(dsl), null, null);
        }
        return null;
    }

    private static boolean isGuardFile(@NotNull VirtualFile file) {
        if (file == null) {
            RubySpecialFilesSymbolProvider.$$$reportNull$$$0(2);
        }
        return file.getName().equalsIgnoreCase("Guardfile");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/dsl/RubySpecialFilesSymbolProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createSymbolByContainer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isGuardFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

