/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.cucumberApi;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.cucumberApi.CucumberInfoProvider;
import org.jetbrains.plugins.ruby.utils.RubyVirtualFileScanner;

public final class RubyCucumberUtil {
    @NonNls
    public static final String FEATURES_FOLDER = "features";
    @NonNls
    private static final String STEP_DEFINITIONS_DIR_NAME = "step_definitions";
    public static final List<@NlsSafe String> CUCUMBER_STEP_PREFIXES = List.of("And", "Then", "When", "Given", "But", "step");

    public static boolean isCucumberSupportEnabled(@NotNull Module module) {
        CucumberInfoProvider cucumberInfoProvider;
        if (module == null) {
            RubyCucumberUtil.$$$reportNull$$$0(0);
        }
        return (cucumberInfoProvider = (CucumberInfoProvider)ApplicationManager.getApplication().getService(CucumberInfoProvider.class)) != null && cucumberInfoProvider.isCucumberSupportEnabled(module);
    }

    public static boolean isStepDefinitionLikeFile(@Nullable VirtualFile file) {
        if (RubyVirtualFileScanner.isRubyFile(file)) {
            return RubyCucumberUtil.isFileUnderStepDefinitionsRoot(file);
        }
        return false;
    }

    private static boolean isFileUnderStepDefinitionsRoot(@NotNull VirtualFile file) {
        if (file == null) {
            RubyCucumberUtil.$$$reportNull$$$0(1);
        }
        for (VirtualFile parent = file.getParent(); parent != null; parent = parent.getParent()) {
            if (!STEP_DEFINITIONS_DIR_NAME.equals(parent.getName())) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/cucumberApi/RubyCucumberUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isCucumberSupportEnabled";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isFileUnderStepDefinitionsRoot";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

