/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.console.debugger;

import com.intellij.execution.console.BaseConsoleExecuteActionHandler;
import com.intellij.execution.console.ConsoleExecuteAction;
import com.intellij.execution.console.ConsoleHistoryController;
import com.intellij.execution.console.ConsoleRootType;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.console.RubyConsoleExecuteActionHandler;
import org.jetbrains.plugins.ruby.console.RubyConsoleRootType;
import org.jetbrains.plugins.ruby.console.RubyConsoleSessionHelper;
import org.jetbrains.plugins.ruby.console.RubyLanguageConsole;
import org.jetbrains.plugins.ruby.ruby.debugger.impl.RubyDebugProcess;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.statistic.RubyLookupUsageLocation;
import org.jetbrains.plugins.ruby.statistic.RubyLookupUsageLocationDescriptor;

class RubyLanguageConsoleViewWithHistory
extends RubyLanguageConsole {
    RubyLanguageConsoleViewWithHistory(Project project, @NotNull String title, @NotNull RubyDebugProcess debugProcess) {
        if (title == null) {
            RubyLanguageConsoleViewWithHistory.$$$reportNull$$$0(0);
        }
        if (debugProcess == null) {
            RubyLanguageConsoleViewWithHistory.$$$reportNull$$$0(1);
        }
        super(project, title, new RubyConsoleSessionHelper(project));
        this.addExecutionHandlerAndHistory(debugProcess);
        RubyLanguageConsoleViewWithHistory.addDebugSessionListenerToConsole(this, debugProcess);
        RubyLookupUsageLocationDescriptor.markFile(this.getFile(), RubyLookupUsageLocation.DEBUG);
    }

    public AnAction @NotNull [] createConsoleActions() {
        ConsoleHistoryController controller = ConsoleHistoryController.getController((LanguageConsoleView)this);
        if (controller == null) {
            AnAction[] anActionArray = super.createConsoleActions();
            if (anActionArray == null) {
                RubyLanguageConsoleViewWithHistory.$$$reportNull$$$0(2);
            }
            return anActionArray;
        }
        AnAction[] anActionArray = (AnAction[])ArrayUtil.append((Object[])super.createConsoleActions(), (Object)controller.getBrowseHistory());
        if (anActionArray == null) {
            RubyLanguageConsoleViewWithHistory.$$$reportNull$$$0(3);
        }
        return anActionArray;
    }

    private void addExecutionHandlerAndHistory(RubyDebugProcess process) {
        RubyConsoleExecuteActionHandler executeActionHandler = new RubyConsoleExecuteActionHandler(this, process);
        ConsoleExecuteAction action = new ConsoleExecuteAction((LanguageConsoleView)this, (BaseConsoleExecuteActionHandler)executeActionHandler, console -> !process.getProcessHandler().isProcessTerminated());
        action.registerCustomShortcutSet(action.getShortcutSet(), this.getConsoleEditor().getComponent());
        String persistenceId = RubyLanguageConsoleViewWithHistory.getHistoryPersistenceId(this.getProject());
        ConsoleHistoryController historyController = new ConsoleHistoryController((ConsoleRootType)RubyConsoleRootType.getInstance(), persistenceId, (LanguageConsoleView)this);
        historyController.install();
        if (historyController.hasHistory()) {
            String oldPersistenceId = this.getProject().getPresentableUrl();
            historyController.loadHistory(oldPersistenceId);
        }
    }

    private static String getHistoryPersistenceId(@NotNull Project project) {
        if (project == null) {
            RubyLanguageConsoleViewWithHistory.$$$reportNull$$$0(4);
        }
        return project.getPresentableUrl() + ":debug";
    }

    private static void addDebugSessionListenerToConsole(final @NotNull RubyLanguageConsole languageConsole, final @NotNull RubyDebugProcess debugProcess) {
        if (languageConsole == null) {
            RubyLanguageConsoleViewWithHistory.$$$reportNull$$$0(5);
        }
        if (debugProcess == null) {
            RubyLanguageConsoleViewWithHistory.$$$reportNull$$$0(6);
        }
        final Project project = languageConsole.getProject();
        debugProcess.getSession().addSessionListener(new XDebugSessionListener(){

            public void sessionPaused() {
                languageConsole.setContext(RubyLanguageConsoleViewWithHistory.findCurrentPositionContextElement(project, debugProcess));
            }

            public void stackFrameChanged() {
                languageConsole.setContext(RubyLanguageConsoleViewWithHistory.findCurrentPositionContextElement(project, debugProcess));
            }

            public void beforeSessionResume() {
                languageConsole.setContext(null);
            }
        });
    }

    @Nullable
    private static PsiElement findCurrentPositionContextElement(@NotNull Project project, @NotNull RubyDebugProcess debugProcess) {
        XSourcePosition currentPosition;
        if (project == null) {
            RubyLanguageConsoleViewWithHistory.$$$reportNull$$$0(7);
        }
        if (debugProcess == null) {
            RubyLanguageConsoleViewWithHistory.$$$reportNull$$$0(8);
        }
        if ((currentPosition = debugProcess.getSession().getCurrentPosition()) == null) {
            return null;
        }
        return (PsiElement)ReadAction.compute(() -> {
            PsiElement element = XDebuggerUtil.getInstance().findContextElement(currentPosition.getFile(), currentPosition.getOffset(), project, false);
            return (RPsiElement)PsiTreeUtil.getParentOfType((PsiElement)element, RPsiElement.class);
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 1: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugProcess";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/console/debugger/RubyLanguageConsoleViewWithHistory";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageConsole";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/console/debugger/RubyLanguageConsoleViewWithHistory";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createConsoleActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getHistoryPersistenceId";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addDebugSessionListenerToConsole";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findCurrentPositionContextElement";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }
}

