/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.console.debugger;

import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.console.debugger.RubyLanguageConsoleViewWithHistory;
import org.jetbrains.plugins.ruby.ruby.debugger.impl.RubyDebugProcess;

public class RubyDebugConsoleBuilder
extends TextConsoleBuilder {
    public static final String DEBUGGER_CONSOLE_VIEW_ID = "Debugger console view";
    @NotNull
    protected final Project myProject;
    @NotNull
    protected final RubyDebugProcess myDebugProcess;
    @NotNull
    protected final ArrayList<Filter> myFilters;

    public RubyDebugConsoleBuilder(@NotNull Project project, @NotNull RubyDebugProcess debugProcess) {
        if (project == null) {
            RubyDebugConsoleBuilder.$$$reportNull$$$0(0);
        }
        if (debugProcess == null) {
            RubyDebugConsoleBuilder.$$$reportNull$$$0(1);
        }
        this.myFilters = new ArrayList();
        this.myProject = project;
        this.myDebugProcess = debugProcess;
    }

    @NotNull
    public ConsoleView getConsole() {
        RubyLanguageConsoleViewWithHistory consoleView = RubyDebugConsoleBuilder.createRubyLanguageConsole(this.myProject, this.myDebugProcess);
        for (Filter filter : this.myFilters) {
            consoleView.addMessageFilter(filter);
        }
        RubyLanguageConsoleViewWithHistory rubyLanguageConsoleViewWithHistory = consoleView;
        if (rubyLanguageConsoleViewWithHistory == null) {
            RubyDebugConsoleBuilder.$$$reportNull$$$0(2);
        }
        return rubyLanguageConsoleViewWithHistory;
    }

    @NotNull
    protected static RubyLanguageConsoleViewWithHistory createRubyLanguageConsole(@NotNull Project project, @NotNull RubyDebugProcess debugProcess) {
        if (project == null) {
            RubyDebugConsoleBuilder.$$$reportNull$$$0(3);
        }
        if (debugProcess == null) {
            RubyDebugConsoleBuilder.$$$reportNull$$$0(4);
        }
        return new RubyLanguageConsoleViewWithHistory(project, "Debug console", debugProcess);
    }

    public void addFilter(@NotNull Filter filter) {
        if (filter == null) {
            RubyDebugConsoleBuilder.$$$reportNull$$$0(5);
        }
        this.myFilters.add(filter);
    }

    public void setViewer(boolean isViewer) {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugProcess";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/console/debugger/RubyDebugConsoleBuilder";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/console/debugger/RubyDebugConsoleBuilder";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getConsole";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createRubyLanguageConsole";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addFilter";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

