/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.console.config;

import com.intellij.openapi.observable.properties.GraphProperty;
import com.intellij.openapi.observable.properties.ObservableMutableProperty;
import com.intellij.openapi.observable.properties.PropertyGraph;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.UiUtils;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.SegmentedButton;
import com.intellij.ui.dsl.builder.TextFieldKt;
import com.intellij.ui.dsl.builder.TextFieldWithBrowseButtonKt;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.console.config.IrbConsoleType;
import org.jetbrains.plugins.ruby.console.config.IrbRunConfiguration;
import org.jetbrains.plugins.ruby.console.config.IrbRunConfigurationParams;
import org.jetbrains.plugins.ruby.ruby.run.configuration.AbstractRubyRunConfigurationWithScriptPath;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RubyCommonRunParamsEditor;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 !2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001!B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0002H\u0014J\u0010\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0002H\u0014J\b\u0010\u0015\u001a\u00020\u0016H\u0014J\u0012\u0010\u0017\u001a\f0\r\u00a2\u0006\u0002\b\u0018\u00a2\u0006\u0002\b\u0019H\u0016J\u0012\u0010\u001a\u001a\u00020\u00122\b\u0010\u001b\u001a\u0004\u0018\u00010\rH\u0016J\b\u0010\u001c\u001a\u00020\rH\u0016J\u0012\u0010\u001d\u001a\u00020\u00122\b\u0010\u001b\u001a\u0004\u0018\u00010\rH\u0016J\b\u0010\u001e\u001a\u00020\u000bH\u0016J\u0010\u0010\u001f\u001a\u00020\u00122\u0006\u0010 \u001a\u00020\u000bH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/jetbrains/plugins/ruby/console/config/IrbRunConfigurationEditor;", "Lcom/intellij/openapi/options/SettingsEditor;", "Lorg/jetbrains/plugins/ruby/console/config/IrbRunConfiguration;", "Lorg/jetbrains/plugins/ruby/console/config/IrbRunConfigurationParams;", "configuration", "<init>", "(Lorg/jetbrains/plugins/ruby/console/config/IrbRunConfiguration;)V", "graph", "Lcom/intellij/openapi/observable/properties/PropertyGraph;", "consoleTypeProperty", "Lcom/intellij/openapi/observable/properties/GraphProperty;", "Lorg/jetbrains/plugins/ruby/console/config/IrbConsoleType;", "scriptPathProperty", "", "scriptArgsProperty", "commonEditor", "Lorg/jetbrains/plugins/ruby/ruby/run/configuration/RubyCommonRunParamsEditor;", "resetEditorFrom", "", "config", "applyEditorTo", "createEditor", "Ljavax/swing/JComponent;", "getScriptPath", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/NonNls;", "setScriptPath", "value", "getScriptArgs", "setScriptArgs", "getConsoleType", "setConsoleType", "consoleType", "Companion", "intellij.ruby.backend"})
public final class IrbRunConfigurationEditor
extends SettingsEditor<IrbRunConfiguration>
implements IrbRunConfigurationParams {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PropertyGraph graph;
    @NotNull
    private final GraphProperty<IrbConsoleType> consoleTypeProperty;
    @NotNull
    private final GraphProperty<String> scriptPathProperty;
    @NotNull
    private final GraphProperty<String> scriptArgsProperty;
    @NotNull
    private final RubyCommonRunParamsEditor commonEditor;
    @NotNull
    private static final List<IrbConsoleType> SELECTABLE_CONSOLE_TYPES;

    public IrbRunConfigurationEditor(@NotNull IrbRunConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        this.graph = new PropertyGraph(null, false, 3, null);
        this.consoleTypeProperty = this.graph.property((Object)IrbConsoleType.NOT_SET);
        this.scriptPathProperty = this.graph.property((Object)"");
        this.scriptArgsProperty = this.graph.property((Object)"");
        this.commonEditor = new RubyCommonRunParamsEditor(configuration);
    }

    protected void resetEditorFrom(@NotNull IrbRunConfiguration config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        IrbConsoleType irbConsoleType = config.getConsoleType();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)irbConsoleType), (String)"getConsoleType(...)");
        this.setConsoleType(irbConsoleType);
        AbstractRubyRunConfigurationWithScriptPath.copyParams(config, this);
        this.commonEditor.resetEditorFrom(config);
    }

    protected void applyEditorTo(@NotNull IrbRunConfiguration config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        config.setConsoleType(this.getConsoleType());
        AbstractRubyRunConfigurationWithScriptPath.copyParams(this, config);
        this.commonEditor.applyEditorTo(config);
    }

    @NotNull
    protected JComponent createEditor() {
        return (JComponent)BuilderKt.panel(arg_0 -> IrbRunConfigurationEditor.createEditor$lambda$6(this, arg_0));
    }

    @Override
    @NotNull
    public String getScriptPath() {
        String string = FileUtil.toSystemIndependentName((String)((Object)StringsKt.trim((CharSequence)((String)this.scriptPathProperty.get()))).toString());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toSystemIndependentName(...)");
        return string;
    }

    @Override
    public void setScriptPath(@Nullable String value) {
        String string = value;
        if (string == null) {
            string = "";
        }
        String string2 = FileUtil.toSystemDependentName((String)string);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toSystemDependentName(...)");
        this.scriptPathProperty.set((Object)string2);
    }

    @Override
    @NotNull
    public String getScriptArgs() {
        return ((Object)StringsKt.trim((CharSequence)((String)this.scriptArgsProperty.get()))).toString();
    }

    @Override
    public void setScriptArgs(@Nullable String value) {
        String string = value;
        if (string == null) {
            string = "";
        }
        this.scriptArgsProperty.set((Object)string);
    }

    @Override
    @NotNull
    public IrbConsoleType getConsoleType() {
        return (IrbConsoleType)((Object)this.consoleTypeProperty.get());
    }

    @Override
    public void setConsoleType(@NotNull IrbConsoleType consoleType) {
        Intrinsics.checkNotNullParameter((Object)((Object)consoleType), (String)"consoleType");
        this.consoleTypeProperty.set((Object)consoleType);
    }

    private static final Unit createEditor$lambda$6$lambda$1$lambda$0(SegmentedButton.ItemPresentation $this$segmentedButton, IrbConsoleType it) {
        Intrinsics.checkNotNullParameter((Object)$this$segmentedButton, (String)"$this$segmentedButton");
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        $this$segmentedButton.setText(it.getName());
        return Unit.INSTANCE;
    }

    private static final Unit createEditor$lambda$6$lambda$1(IrbRunConfigurationEditor this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.segmentedButton((Collection)SELECTABLE_CONSOLE_TYPES, IrbRunConfigurationEditor::createEditor$lambda$6$lambda$1$lambda$0).bind((ObservableMutableProperty)this$0.consoleTypeProperty);
        return Unit.INSTANCE;
    }

    private static final Unit createEditor$lambda$6$lambda$3$lambda$2(TextFieldWithBrowseButton $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        UiUtils.getEmptyText((TextFieldWithBrowseButton)$this$applyToComponent).setText(RBundle.message((String)"irb.run.configuration.default.script"));
        return Unit.INSTANCE;
    }

    private static final Unit createEditor$lambda$6$lambda$3(IrbRunConfigurationEditor this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = RBundle.message((String)"irb.run.configuration.messages.select.ruby.script.path");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        TextFieldWithBrowseButtonKt.bindText((Cell)Row.textFieldWithBrowseButton$default((Row)$this$row, (String)string, null, null, (int)6, null).applyToComponent(IrbRunConfigurationEditor::createEditor$lambda$6$lambda$3$lambda$2).align(Align.FILL), (ObservableMutableProperty)((ObservableMutableProperty)this$0.scriptPathProperty));
        return Unit.INSTANCE;
    }

    private static final Unit createEditor$lambda$6$lambda$4(IrbRunConfigurationEditor this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        TextFieldKt.bindText((Cell)Row.expandableTextField$default((Row)$this$row, null, null, (int)3, null).align(Align.FILL), (ObservableMutableProperty)((ObservableMutableProperty)this$0.scriptArgsProperty));
        return Unit.INSTANCE;
    }

    private static final Unit createEditor$lambda$6$lambda$5(IrbRunConfigurationEditor this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        JPanel jPanel = this$0.commonEditor.getMainPanel();
        Intrinsics.checkNotNullExpressionValue((Object)jPanel, (String)"getMainPanel(...)");
        $this$row.cell((JComponent)jPanel).align(Align.FILL);
        return Unit.INSTANCE;
    }

    private static final Unit createEditor$lambda$6(IrbRunConfigurationEditor this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        String string = RBundle.message((String)"irb.run.configuration.messages.script.console.type");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$panel.row(string, arg_0 -> IrbRunConfigurationEditor.createEditor$lambda$6$lambda$1(this$0, arg_0));
        String string2 = RBundle.message((String)"irb.run.configuration.messages.script.path");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        $this$panel.row(string2, arg_0 -> IrbRunConfigurationEditor.createEditor$lambda$6$lambda$3(this$0, arg_0));
        String string3 = RBundle.message((String)"irb.run.configuration.messages.edit.script.args");
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        $this$panel.row(string3, arg_0 -> IrbRunConfigurationEditor.createEditor$lambda$6$lambda$4(this$0, arg_0));
        Panel.separator$default((Panel)$this$panel, null, (int)1, null);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> IrbRunConfigurationEditor.createEditor$lambda$6$lambda$5(this$0, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    static {
        IrbConsoleType[] irbConsoleTypeArray = new IrbConsoleType[]{IrbConsoleType.IRB, IrbConsoleType.PRY, IrbConsoleType.RAILS};
        SELECTABLE_CONSOLE_TYPES = CollectionsKt.listOf((Object[])irbConsoleTypeArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/plugins/ruby/console/config/IrbRunConfigurationEditor$Companion;", "", "<init>", "()V", "SELECTABLE_CONSOLE_TYPES", "", "Lorg/jetbrains/plugins/ruby/console/config/IrbConsoleType;", "getSELECTABLE_CONSOLE_TYPES", "()Ljava/util/List;", "intellij.ruby.backend"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<IrbConsoleType> getSELECTABLE_CONSOLE_TYPES() {
            return SELECTABLE_CONSOLE_TYPES;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

