/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.console.config;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.console.config.IrbConsoleType;
import org.jetbrains.plugins.ruby.console.config.IrbRunCommandLineState;
import org.jetbrains.plugins.ruby.console.config.IrbRunConfigurationEditor;
import org.jetbrains.plugins.ruby.console.config.IrbRunConfigurationExternalizer;
import org.jetbrains.plugins.ruby.console.config.IrbRunConfigurationParams;
import org.jetbrains.plugins.ruby.ruby.run.configuration.AbstractRubyRunConfigurationWithScriptPath;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RubyAbstractCommandLineState;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RunConfigurationUtil;

public final class IrbRunConfiguration
extends AbstractRubyRunConfigurationWithScriptPath<IrbRunConfiguration>
implements IrbRunConfigurationParams {
    @NotNull
    private IrbConsoleType myConsoleType = IrbConsoleType.IRB;

    public IrbRunConfiguration(Project project, ConfigurationFactory factory) {
        super(project, factory);
    }

    @Override
    public void setConsoleType(@NotNull IrbConsoleType consoleType) {
        if (consoleType == null) {
            IrbRunConfiguration.$$$reportNull$$$0(0);
        }
        this.myConsoleType = consoleType;
    }

    @Override
    @NotNull
    public IrbConsoleType getConsoleType() {
        IrbConsoleType irbConsoleType = this.myConsoleType;
        if (irbConsoleType == null) {
            IrbRunConfiguration.$$$reportNull$$$0(1);
        }
        return irbConsoleType;
    }

    @Override
    public void readExternal(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            IrbRunConfiguration.$$$reportNull$$$0(2);
        }
        super.readExternal(element);
        IrbRunConfigurationExternalizer.getInstance().readExternal(this, element);
    }

    @Override
    public void writeExternal(@NotNull Element element) throws WriteExternalException {
        if (element == null) {
            IrbRunConfiguration.$$$reportNull$$$0(3);
        }
        super.writeExternal(element);
        IrbRunConfigurationExternalizer.getInstance().writeExternal(this, element);
    }

    @Override
    protected String getSerializationId() {
        return "IRB_RUN_CONFIG";
    }

    @Override
    protected SettingsEditor<IrbRunConfiguration> createConfigurationEditor() {
        return new IrbRunConfigurationEditor(this);
    }

    @Override
    protected void validateConfiguration() throws RuntimeConfigurationException {
        RunConfigurationUtil.inspectSDK(this);
        this.inspectConsoleType();
        this.inspectScript();
        RunConfigurationUtil.inspectWorkingDirectory(true, this);
    }

    @Override
    protected RubyAbstractCommandLineState createCommandLineState(@NotNull ExecutionEnvironment env) throws ExecutionException {
        if (env == null) {
            IrbRunConfiguration.$$$reportNull$$$0(4);
        }
        return new IrbRunCommandLineState(this, env);
    }

    private void inspectScript() throws RuntimeConfigurationError {
        String scriptPath = this.getScriptPath();
        if (StringUtil.isEmptyOrSpaces((String)scriptPath)) {
            if (this.myConsoleType.getDefaultExecutable() != null) {
                return;
            }
            throw new RuntimeConfigurationError(RBundle.message((String)"irb.run.configuration.script.not.specified"));
        }
        File script = new File(scriptPath);
        if (!script.exists()) {
            throw new RuntimeConfigurationError(RBundle.message((String)"irb.run.configuration.script.not.exists"));
        }
        if (!script.isFile()) {
            throw new RuntimeConfigurationError(RBundle.message((String)"irb.run.configuration.script.is.not.file"));
        }
    }

    private void inspectConsoleType() throws RuntimeConfigurationError {
        if (this.myConsoleType == IrbConsoleType.NOT_SET) {
            throw new RuntimeConfigurationError(RBundle.message((String)"irb.run.configuration.invalid.console.type"));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/console/config/IrbRunConfiguration";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/console/config/IrbRunConfiguration";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getConsoleType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setConsoleType";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createCommandLineState";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

