/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.console.config;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Objects;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.console.IrbUtil;
import org.jetbrains.plugins.ruby.console.config.IrbConsoleBuilder;
import org.jetbrains.plugins.ruby.console.config.IrbConsoleType;
import org.jetbrains.plugins.ruby.console.config.IrbRunConfiguration;
import org.jetbrains.plugins.ruby.rails.preload.spring.SpringUtil;
import org.jetbrains.plugins.ruby.ruby.run.RubyCommandLine;
import org.jetbrains.plugins.ruby.ruby.run.RubyRunner;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RubyAbstractCommandLineState;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RubyCommandLineData;

public final class IrbRunCommandLineState
extends RubyAbstractCommandLineState {
    @NonNls
    private static final String CONSOLE_CONFIG_PARAMS_GROUP_ID = "ruby.console.config";
    @NonNls
    private static final String IRB_PARAMS_GROUP_ID = "ruby.irb.run.script";

    IrbRunCommandLineState(@NotNull IrbRunConfiguration configuration, @NotNull ExecutionEnvironment env) {
        if (configuration == null) {
            IrbRunCommandLineState.$$$reportNull$$$0(0);
        }
        if (env == null) {
            IrbRunCommandLineState.$$$reportNull$$$0(1);
        }
        super(configuration, env, true);
        IrbRunConfiguration config = this.getConfig();
        this.setConsoleBuilder(new IrbConsoleBuilder(config.getProject(), config));
    }

    public IrbRunConfiguration getConfig() {
        return (IrbRunConfiguration)super.getConfig();
    }

    @Override
    @NotNull
    public ConsoleView createAndAttachConsole(@NotNull Project project, @NotNull ProcessHandler processHandler, @NotNull Executor executor) {
        if (project == null) {
            IrbRunCommandLineState.$$$reportNull$$$0(2);
        }
        if (processHandler == null) {
            IrbRunCommandLineState.$$$reportNull$$$0(3);
        }
        if (executor == null) {
            IrbRunCommandLineState.$$$reportNull$$$0(4);
        }
        ConsoleView console = this.getConsoleBuilder().getConsole();
        console.attachToProcess(processHandler);
        ConsoleView consoleView = console;
        if (consoleView == null) {
            IrbRunCommandLineState.$$$reportNull$$$0(5);
        }
        return consoleView;
    }

    @Override
    protected RubyCommandLineData createRunCommandLine() throws ExecutionException {
        IrbRunConfiguration config = this.getConfig();
        Sdk sdk = config.getSdk();
        LOG.assertTrue(sdk != null);
        IrbConsoleType consoleType = config.getConsoleType();
        LOG.assertTrue(consoleType != IrbConsoleType.NOT_SET);
        RubyCommandLineData data = IrbRunCommandLineState.createDefaultCommandLine(config, this.getRunnerId());
        data.putUserData(RubyCommandLineData.DEBUG_CONSOLE_ALLOWED_KEY, true);
        RubyCommandLine commandLine = data.getCommandLine();
        if (!Registry.is((String)"rubymine.rails.console.use.spring", (boolean)false)) {
            SpringUtil.disableSpring(commandLine.getEnvironment());
        }
        if (Registry.is((String)"ruby.preconfigure.consoles", (boolean)true)) {
            commandLine.getParametersList().addParamsGroupAt(0, CONSOLE_CONFIG_PARAMS_GROUP_ID).addParameters(new String[]{"-r", Objects.requireNonNull(IrbUtil.getConsoleConfig(sdk, config.getModule(), consoleType))});
        }
        String executablePath = StringUtil.defaultIfEmpty((String)config.getScriptPath().trim(), (String)StringUtil.notNullize((String)IrbUtil.getDefaultExecutable(consoleType)));
        this.addExecutionScriptGroup(IRB_PARAMS_GROUP_ID, data, commandLine, executablePath).addParametersString(config.getScriptArgs());
        return data;
    }

    @Override
    @NotNull
    protected ProcessHandler createOSProcessHandler(@NotNull RubyRunner runner, @NotNull RubyCommandLine commandLine) throws ExecutionException {
        if (runner == null) {
            IrbRunCommandLineState.$$$reportNull$$$0(6);
        }
        if (commandLine == null) {
            IrbRunCommandLineState.$$$reportNull$$$0(7);
        }
        ProcessHandler processHandler = runner.createConsoleProcessHandler(commandLine);
        if (processHandler == null) {
            IrbRunCommandLineState.$$$reportNull$$$0(8);
        }
        return processHandler;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/console/config/IrbRunCommandLineState";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runner";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/console/config/IrbRunCommandLineState";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createAndAttachConsole";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createOSProcessHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createAndAttachConsole";
                break;
            }
            case 5: 
            case 8: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createOSProcessHandler";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 8 -> new IllegalStateException(string);
        };
    }
}

