/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.console;

import com.intellij.DynamicBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.rails.preload.PreLoadUtil;
import org.jetbrains.plugins.ruby.rails.preload.zeus.ZeusUtil;
import org.jetbrains.plugins.ruby.tasks.rake.task.special.TaskUIUtil;

public class SelectEnvironmentDialog
extends DialogWrapper {
    private JComboBox myEnvironmentComboBox;
    private JPanel myPanel;
    private JBCheckBox myUseZeusServer;
    private final Ref<? super Pair<String, Boolean>> myEnvironment;

    public SelectEnvironmentDialog(Ref<? super Pair<String, Boolean>> environment, @NotNull Module module) {
        if (module == null) {
            SelectEnvironmentDialog.$$$reportNull$$$0(0);
        }
        super(false);
        this.$$$setupUI$$$();
        this.setTitle(RBundle.message((String)"rails.console.select.environment"));
        this.myEnvironment = environment;
        TaskUIUtil.initRailsEnvsCB_Component(null, this.myEnvironmentComboBox, module);
        this.myUseZeusServer.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                SelectEnvironmentDialog.this.myEnvironmentComboBox.setEnabled(!SelectEnvironmentDialog.this.myUseZeusServer.isSelected());
                if (SelectEnvironmentDialog.this.myUseZeusServer.isSelected()) {
                    SelectEnvironmentDialog.this.myEnvironmentComboBox.setSelectedItem("Default");
                }
            }
        });
        boolean ancientGreece = ZeusUtil.hasZeusSupport(module);
        this.myUseZeusServer.setVisible(ancientGreece);
        this.myUseZeusServer.setSelected(ancientGreece && PreLoadUtil.PreLoadServer.Zeus.isRunning(module));
        this.init();
    }

    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    protected void doOKAction() {
        Object value = this.myEnvironmentComboBox.getSelectedItem();
        this.myEnvironment.set((Object)Pair.create((Object)("Default".equals(value) ? null : (String)value), (Object)this.myUseZeusServer.isSelected()));
        super.doOKAction();
    }

    public void doCancelAction() {
        this.myEnvironment.set(null);
        super.doCancelAction();
    }

    public void show() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.doOKAction();
            return;
        }
        super.show();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBCheckBox jBCheckBox;
        JComboBox jComboBox;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/RBundle", SelectEnvironmentDialog.class).getString("rails.console.environment"));
        jPanel.add((Component)jLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, new Dimension(50, 20), null, null));
        this.myEnvironmentComboBox = jComboBox = new JComboBox();
        jPanel.add(jComboBox, new GridConstraints(1, 1, 1, 1, 8, 1, 2, 0, new Dimension(100, 20), null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(2, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myUseZeusServer = jBCheckBox = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, DynamicBundle.getBundle((String)"messages/RBundle", SelectEnvironmentDialog.class).getString("zeus.server.use"));
        jPanel.add((Component)jBCheckBox, new GridConstraints(0, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        jLabel.setLabelFor(jComboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/ruby/console/SelectEnvironmentDialog", "<init>"));
    }
}

