/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.console;

import com.intellij.execution.console.BaseConsoleExecuteActionHandler;
import com.intellij.execution.console.ConsoleHistoryController;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.DocumentUtil;
import com.intellij.util.LazyInitializer;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XStackFrame;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.console.RubyLanguageConsole;
import org.jetbrains.plugins.ruby.ruby.debugger.RubyDebuggerSupportUtils;
import org.jetbrains.plugins.ruby.ruby.debugger.impl.RubyDebugProcess;
import org.jetbrains.plugins.ruby.ruby.debugger.impl.RubyDebuggerEvaluator;
import org.rubyforge.debugcommons.model.ExpressionInfo;

public class RubyConsoleExecuteActionHandler
extends BaseConsoleExecuteActionHandler {
    private static final LazyInitializer.LazyValue<NotificationGroup> NOTIFICATION_GROUP = new LazyInitializer.LazyValue(() -> NotificationGroup.toolWindowGroup((String)"Debugger console", (String)"Debug", (boolean)false));
    private static final String USUAL_PROMPT = ">";
    private static final String MORE_PROMPT = "*";
    private static final String WAIT_PROMPT = "..";
    @NotNull
    private final RubyLanguageConsole myConsoleView;
    @Nullable
    private ProcessHandler myProcessHandler;
    @NotNull
    private final RubyDebugProcess myDebugProcess;
    @NotNull
    private final Project myProject;
    private boolean hasShownHistoryTraversalNotification;
    private int myConsoleIndent;

    public RubyConsoleExecuteActionHandler(@NotNull RubyLanguageConsole view, @NotNull RubyDebugProcess process) {
        if (view == null) {
            RubyConsoleExecuteActionHandler.$$$reportNull$$$0(0);
        }
        if (process == null) {
            RubyConsoleExecuteActionHandler.$$$reportNull$$$0(1);
        }
        super(true);
        this.hasShownHistoryTraversalNotification = false;
        this.myConsoleIndent = 0;
        this.myConsoleView = view;
        this.myDebugProcess = process;
        this.myProject = view.getProject();
        ApplicationManager.getApplication().invokeLater(() -> this.setPrompt(USUAL_PROMPT));
    }

    public void setProcessHandler(@Nullable ProcessHandler processHandler) {
        this.myProcessHandler = processHandler;
    }

    public boolean isProcessTerminated() {
        return this.myProcessHandler == null || this.myProcessHandler.isProcessTerminated();
    }

    public void execute(@NotNull String text, @NotNull LanguageConsoleView consoleView) {
        if (text == null) {
            RubyConsoleExecuteActionHandler.$$$reportNull$$$0(2);
        }
        if (consoleView == null) {
            RubyConsoleExecuteActionHandler.$$$reportNull$$$0(3);
        }
        this.freezeConsole();
        if (consoleView instanceof RubyLanguageConsole) {
            RubyLanguageConsole rubyConsoleView = (RubyLanguageConsole)consoleView;
            rubyConsoleView.getSessionHelper().appendSessionChunk(text);
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            XStackFrame currentStackFrame = this.myDebugProcess.getSession().getCurrentStackFrame();
            if (currentStackFrame == null) {
                this.processEvaluatedResult(null);
                return;
            }
            String result = RubyDebuggerEvaluator.evaluateExpression(currentStackFrame, text);
            this.processEvaluatedResult(result);
        });
    }

    private void processEvaluatedResult(@Nullable String result) {
        ApplicationManager.getApplication().invokeLater(() -> {
            ConsoleHistoryController controller;
            this.recoverConsole(USUAL_PROMPT);
            if (result != null) {
                this.printAnswer(result + "\n");
            }
            if ((controller = ConsoleHistoryController.getController((LanguageConsoleView)this.getConsole())) != null && controller.hasHistory() && this.shouldNotifyAboutHistoryTraversalKeys()) {
                Shortcut[] prevShortcuts = controller.getHistoryPrev().getShortcutSet().getShortcuts();
                Shortcut[] nextShortcuts = controller.getHistoryNext().getShortcutSet().getShortcuts();
                if (prevShortcuts.length > 0 && nextShortcuts.length > 0) {
                    String goPrevName = KeymapUtil.getShortcutText((Shortcut)prevShortcuts[0]);
                    String goNextName = KeymapUtil.getShortcutText((Shortcut)nextShortcuts[0]);
                    this.printWindowInfo(RBundle.message((String)"debugger.console.history.traverse.hint", (Object[])new Object[]{goPrevName, goNextName}), NotificationType.INFORMATION);
                }
            }
        });
    }

    private boolean shouldNotifyAboutHistoryTraversalKeys() {
        if (!this.hasShownHistoryTraversalNotification) {
            this.hasShownHistoryTraversalNotification = true;
            return true;
        }
        return false;
    }

    private void printAnswer(String s) {
        this.myConsoleView.print("=> " + s + "\n", ConsoleViewContentType.NORMAL_OUTPUT);
    }

    public void runExecuteAction(@NotNull LanguageConsoleView consoleView) {
        if (consoleView == null) {
            RubyConsoleExecuteActionHandler.$$$reportNull$$$0(4);
        }
        this.freezeConsole();
        String text = consoleView.getEditorDocument().getText();
        if (StringUtil.isEmptyOrSpaces((String)text)) {
            this.recoverConsole(MORE_PROMPT);
            return;
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            if (this.myDebugProcess.getSession().getCurrentStackFrame() == null) {
                this.printWindowInfo(RBundle.message((String)"debugger.console.no.stack.frame.available"), NotificationType.WARNING);
                this.recoverConsole(USUAL_PROMPT);
                return;
            }
            XDebuggerEvaluator evaluator = this.myDebugProcess.getEvaluator();
            if (evaluator == null) {
                this.recoverConsole(USUAL_PROMPT);
                return;
            }
            ExpressionInfo expressionInfo = ((RubyDebuggerEvaluator)evaluator).getExpressionInfo(text);
            this.processCalculatedExpressionInfo(expressionInfo, consoleView);
        });
    }

    private void processCalculatedExpressionInfo(@Nullable ExpressionInfo expressionInfo, @NotNull LanguageConsoleView consoleView) {
        if (consoleView == null) {
            RubyConsoleExecuteActionHandler.$$$reportNull$$$0(5);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            if (expressionInfo != null && expressionInfo.isIncomplete()) {
                this.myConsoleIndent = expressionInfo.getIndent();
                if (expressionInfo.getPromptType() != null) {
                    this.recoverConsole(expressionInfo.getPromptType());
                } else {
                    this.recoverConsole(MORE_PROMPT);
                }
                RubyConsoleExecuteActionHandler.addNewline(consoleView);
            } else {
                this.myConsoleIndent = 0;
                this.recoverConsole(USUAL_PROMPT);
                super.runExecuteAction(consoleView);
                XDebugSession session = this.myDebugProcess.getSession();
                RubyDebuggerSupportUtils.invalidateSessionFrames(session);
                session.rebuildViews();
            }
        });
    }

    private void freezeConsole() {
        this.setPrompt(WAIT_PROMPT);
    }

    private void recoverConsole(@NotNull String prompt) {
        if (prompt == null) {
            RubyConsoleExecuteActionHandler.$$$reportNull$$$0(6);
        }
        this.setPrompt(prompt);
    }

    private void setPrompt(@NotNull String prompt) {
        if (prompt == null) {
            RubyConsoleExecuteActionHandler.$$$reportNull$$$0(7);
        }
        if (WAIT_PROMPT.equals(prompt)) {
            this.getConsole().setPrompt(WAIT_PROMPT);
        } else {
            this.getConsole().setPrompt(this.myConsoleIndent + prompt);
        }
    }

    private void printWindowInfo(@NlsContexts.StatusBarText @NotNull String text, @NotNull NotificationType notificationType) {
        StatusBar statusBar;
        IdeFrame ideFrame;
        if (text == null) {
            RubyConsoleExecuteActionHandler.$$$reportNull$$$0(8);
        }
        if (notificationType == null) {
            RubyConsoleExecuteActionHandler.$$$reportNull$$$0(9);
        }
        if ((ideFrame = WindowManager.getInstance().getIdeFrame(this.getConsole().getProject())) != null && (statusBar = ideFrame.getStatusBar()) != null) {
            statusBar.setInfo(text);
        }
        ((NotificationGroup)NOTIFICATION_GROUP.get()).createNotification(text, notificationType).notify(this.myProject);
    }

    private RubyLanguageConsole getConsole() {
        return this.myConsoleView;
    }

    private static void addNewline(@NotNull LanguageConsoleView console) {
        if (console == null) {
            RubyConsoleExecuteActionHandler.$$$reportNull$$$0(10);
        }
        DocumentUtil.writeInRunUndoTransparentAction(() -> {
            Document document = console.getEditorDocument();
            Caret caret = console.getConsoleEditor().getCaretModel().getCurrentCaret();
            document.insertString(caret.getOffset(), (CharSequence)"\n");
            console.getConsoleEditor().getCaretModel().moveToOffset(caret.getOffset() + 1);
            CodeStyleManager.getInstance((Project)console.getProject()).adjustLineIndent(document, caret.getOffset());
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleView";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prompt";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notificationType";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "console";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/console/RubyConsoleExecuteActionHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "execute";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "runExecuteAction";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "processCalculatedExpressionInfo";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "recoverConsole";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "setPrompt";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "printWindowInfo";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "addNewline";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

