/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.console;

import com.intellij.execution.ExecutionHelper;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PlatformUtils;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.console.IrbRubyLanguageConsoleView;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.utils.RubyVirtualFileScanner;

public final class LoadInIrbConsoleAction
extends AnAction {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            LoadInIrbConsoleAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            LoadInIrbConsoleAction.$$$reportNull$$$0(1);
        }
        Presentation presentation = e.getPresentation();
        DataContext dataContext = e.getDataContext();
        Module module = RModuleUtil.getInstance().getModule(dataContext);
        VirtualFile file = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(dataContext);
        boolean isVisible = RModuleUtil.getInstance().hasRubySupport(module);
        boolean isEnabled = isVisible && RubyVirtualFileScanner.isRubyFile(file) && (Boolean)e.getUpdateSession().compute((Object)this, "findConsole", ActionUpdateThread.EDT, () -> !LoadInIrbConsoleAction.findRunningIrbOrRailsConsole(module).isEmpty()) != false;
        presentation.setVisible(PlatformUtils.isRubyMine() ? isVisible : isEnabled);
        presentation.setEnabled(isEnabled);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            LoadInIrbConsoleAction.$$$reportNull$$$0(2);
        }
        DataContext dataContext = e.getDataContext();
        Project project = e.getProject();
        assert (project != null);
        Module module = RModuleUtil.getInstance().getModule(dataContext);
        assert (module != null);
        VirtualFile file = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(dataContext);
        assert (file != null);
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        Collection<RunContentDescriptor> consoles = LoadInIrbConsoleAction.findRunningIrbOrRailsConsole(module);
        ExecutionHelper.selectContentDescriptor((DataContext)e.getDataContext(), (Project)project, consoles, (String)RBundle.message((String)"popup.title.select.console.to.load.to"), contentDescriptor -> {
            if (contentDescriptor != null) {
                ExecutionConsole console = contentDescriptor.getExecutionConsole();
                assert (console instanceof IrbRubyLanguageConsoleView);
                ((IrbRubyLanguageConsoleView)console).loadFileOrExecuteSelection(file, editor);
                return;
            }
            if (RModuleUtil.getInstance().findRubySdkForModule(module) == null) {
                LoadInIrbConsoleAction.showError(RBundle.message((String)"sdk.no.specified"));
                return;
            }
            LoadInIrbConsoleAction.showError(RBundle.message((String)"irb.console.actions.load.text.error.running.not.found"));
        });
    }

    private static void showError(@NlsContexts.DialogMessage @NotNull String msg) {
        if (msg == null) {
            LoadInIrbConsoleAction.$$$reportNull$$$0(3);
        }
        Messages.showErrorDialog((String)msg, (String)RBundle.message((String)"irb.console.actions.load.text.title"));
    }

    private static Collection<RunContentDescriptor> findRunningIrbOrRailsConsole(@NotNull Module module) {
        if (module == null) {
            LoadInIrbConsoleAction.$$$reportNull$$$0(4);
        }
        return ExecutionHelper.findRunningConsole((Project)module.getProject(), selectedContent -> {
            ProcessHandler processHandler = selectedContent.getProcessHandler();
            if (processHandler == null || processHandler.isProcessTerminated()) {
                return false;
            }
            IrbRubyLanguageConsoleView console = (IrbRubyLanguageConsoleView)((Object)((Object)ObjectUtils.tryCast((Object)selectedContent.getExecutionConsole(), IrbRubyLanguageConsoleView.class)));
            return console != null && console.isLaunchedFrom(module);
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/console/LoadInIrbConsoleAction";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "msg";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/console/LoadInIrbConsoleAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "showError";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findRunningIrbOrRailsConsole";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4 -> new IllegalArgumentException(string);
        };
    }
}

