/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.console;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import java.io.File;
import java.util.Objects;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.console.config.IrbConsoleType;
import org.jetbrains.plugins.ruby.console.config.IrbRunConfiguration;
import org.jetbrains.plugins.ruby.gem.RubyGemExecutionContext;
import org.jetbrains.plugins.ruby.rails.model.RailsApp;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.ruby.RubyUtil;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkAdditionalData;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkUtil;

public final class IrbUtil {
    @NonNls
    public static final String PRY_PROMPT_DESCRIPTION = "rb/consoles/pry_prompt_descr.txt";
    @NlsSafe
    public static final String IRB_GEM_NAME = "irb";
    @NlsSafe
    public static final String PRY_GEM_NAME = "pry";

    @Nullable
    public static String findIrbExecutable(@NotNull Sdk sdk, @Nullable Module module) {
        String scriptPath;
        String gemsBinDir;
        if (sdk == null) {
            IrbUtil.$$$reportNull$$$0(0);
        }
        if ((gemsBinDir = (String)ObjectUtils.doIfNotNull((Object)((Object)RubySdkAdditionalData.from(sdk)), RubySdkAdditionalData::getGemsBinDirectory)) != null && new File(scriptPath = FileUtil.join((String[])new String[]{gemsBinDir, IRB_GEM_NAME})).exists()) {
            return scriptPath;
        }
        return IrbUtil.getScriptPathFromExecutionContext(sdk, module, IRB_GEM_NAME);
    }

    @Nullable
    public static String findPryExecutable(@NotNull Sdk sdk, @Nullable Module module) {
        if (sdk == null) {
            IrbUtil.$$$reportNull$$$0(1);
        }
        return IrbUtil.getScriptPathFromExecutionContext(sdk, module, PRY_GEM_NAME);
    }

    @Nullable
    public static String getDefaultExecutable(@NotNull IrbConsoleType consoleType) {
        if (consoleType == null) {
            IrbUtil.$$$reportNull$$$0(2);
        }
        return (String)ObjectUtils.doIfNotNull((Object)consoleType.getDefaultExecutable(), RubyUtil::getScriptFullPath);
    }

    @Nullable
    public static String getConsoleConfig(@NotNull Sdk sdk, @Nullable Module module, @NotNull IrbConsoleType consoleType) {
        if (sdk == null) {
            IrbUtil.$$$reportNull$$$0(3);
        }
        if (consoleType == null) {
            IrbUtil.$$$reportNull$$$0(4);
        }
        return (String)ObjectUtils.doIfNotNull((Object)consoleType.getConfigPath(), conf -> RubySdkUtil.convertToRemote(sdk, module, Objects.requireNonNull(RubyUtil.getScriptFullPath(conf))));
    }

    public static void setWorkingDirectory(@NotNull Module module, @NotNull IrbRunConfiguration runConfiguration) {
        if (module == null) {
            IrbUtil.$$$reportNull$$$0(5);
        }
        if (runConfiguration == null) {
            IrbUtil.$$$reportNull$$$0(6);
        }
        if (!StringUtil.isEmptyOrSpaces((String)runConfiguration.getWorkingDirectory())) {
            return;
        }
        VirtualFile directory = IrbUtil.getWorkingDirectory(module);
        if (directory != null) {
            runConfiguration.setWorkingDirectory(FileUtil.toSystemDependentName((String)directory.getPath()));
        }
    }

    @NotNull
    static String toLog(@NotNull String text) {
        if (text == null) {
            IrbUtil.$$$reportNull$$$0(7);
        }
        String string = StringUtil.escapeLineBreak((String)text).replace(' ', '\u2423');
        if (string == null) {
            IrbUtil.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Nullable
    private static String getScriptPathFromExecutionContext(@NotNull Sdk sdk, @Nullable Module module, @NotNull String gemName) {
        if (sdk == null) {
            IrbUtil.$$$reportNull$$$0(9);
        }
        if (gemName == null) {
            IrbUtil.$$$reportNull$$$0(10);
        }
        return ((RubyGemExecutionContext)RubyGemExecutionContext.create(sdk, gemName).withModule(module)).getScriptPath();
    }

    @Nullable
    private static VirtualFile getWorkingDirectory(@NotNull Module module) {
        RailsApp railsApp;
        if (module == null) {
            IrbUtil.$$$reportNull$$$0(11);
        }
        return (railsApp = RailsApp.fromModule(module)) == null ? RModuleUtil.getInstance().getFirstContentRoot(module) : railsApp.getRailsApplicationRoot();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleType";
                break;
            }
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/console/IrbUtil";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gemName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/console/IrbUtil";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "toLog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findIrbExecutable";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findPryExecutable";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultExecutable";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getConsoleConfig";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setWorkingDirectory";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "toLog";
                break;
            }
            case 8: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getScriptPathFromExecutionContext";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getWorkingDirectory";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8 -> new IllegalStateException(string);
        };
    }
}

