/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.command.run;

import com.intellij.DynamicBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.PanelWithAnchor;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.TextFieldWithAutoCompletion;
import com.intellij.ui.TextFieldWithAutoCompletionListProvider;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.UIUtil;
import icons.RubyIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.command.run.CommandRunConfiguration;
import org.jetbrains.plugins.ruby.command.run.CommandRunConfigurationParams;
import org.jetbrains.plugins.ruby.command.run.cache.GemCommand;
import org.jetbrains.plugins.ruby.command.run.cache.GemCommandsCache;
import org.jetbrains.plugins.ruby.gem.GemInfo;
import org.jetbrains.plugins.ruby.gem.util.RubyProjectGemSearchService;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RubyCommonRunParamsEditor;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RunConfigurationUIUtil;

public class CommandRunConfigurationEditor
extends SettingsEditor<CommandRunConfiguration>
implements CommandRunConfigurationParams,
PanelWithAnchor {
    private JComponent myContentPane;
    private LabeledComponent<TextFieldWithAutoCompletion> myGemComponent;
    private TextFieldWithAutoCompletion myGemNameTextField;
    private TextFieldWithAutoCompletionListProvider<GemInfo> myGemNameCompletionProvider;
    private LabeledComponent<TextFieldWithAutoCompletion> myGemCommandNameComponent;
    private TextFieldWithAutoCompletion myGemCommandNameTextField;
    private TextFieldWithAutoCompletionListProvider<GemCommand> myGemCommandCompletionProvider;
    private LabeledComponent<RawCommandLineEditor> myGemCommandArgumentsComponent;
    private RawCommandLineEditor myCommandArgumentsEditor;
    private final RubyCommonRunParamsEditor myCommonEditor;
    private JComponent myAnchor;
    private JPanel myCommonOptionsPanel;
    private final Project myProject;

    public CommandRunConfigurationEditor(Project project, CommandRunConfiguration runConfiguration) {
        this.myProject = project;
        this.$$$setupUI$$$();
        this.myCommonEditor = RunConfigurationUIUtil.createRubyCommonRunParamsEditor(runConfiguration, this.getExecutableName(), this.myCommonOptionsPanel);
        this.myCommonEditor.addModuleChangedListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                CommandRunConfigurationEditor.this.onModuleChanged(CommandRunConfigurationEditor.this.myCommonEditor.getModule());
            }
        });
        this.setupAnchor();
    }

    private void onModuleChanged(@Nullable Module module) {
        this.refreshGems(module, this.myGemNameCompletionProvider);
        this.refreshCommands(module, this.myGemCommandCompletionProvider);
    }

    private void createUIComponents() {
        Ref gemNameRef = new Ref();
        Ref gemNameProviderRef = new Ref();
        this.myGemComponent = CommandRunConfigurationEditor.createGemComponent(this.myProject, (Ref<? super TextFieldWithAutoCompletion>)gemNameRef, (Ref<? super TextFieldWithAutoCompletionListProvider<GemInfo>>)gemNameProviderRef);
        this.myGemNameTextField = (TextFieldWithAutoCompletion)gemNameRef.get();
        this.myGemComponent.setComponent((JComponent)this.myGemNameTextField);
        this.myGemNameCompletionProvider = (TextFieldWithAutoCompletionListProvider)gemNameProviderRef.get();
        Ref gemCommandRef = new Ref();
        Ref gemCommandProviderRef = new Ref();
        this.myGemCommandNameComponent = CommandRunConfigurationEditor.createGemCommandComponent(this.myProject, (Ref<? super TextFieldWithAutoCompletion>)gemCommandRef, (Ref<? super TextFieldWithAutoCompletionListProvider<GemCommand>>)gemCommandProviderRef);
        this.myGemCommandNameTextField = (TextFieldWithAutoCompletion)gemCommandRef.get();
        this.myGemCommandNameTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                CommandRunConfigurationEditor.this.myCommonEditor.setUseAlternativeSdkLabel(CommandRunConfigurationEditor.this.getExecutableName());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/plugins/ruby/command/run/CommandRunConfigurationEditor$2", "documentChanged"));
            }
        }, (Disposable)this);
        this.myGemCommandNameComponent.setComponent((JComponent)this.myGemCommandNameTextField);
        this.myGemCommandCompletionProvider = (TextFieldWithAutoCompletionListProvider)gemCommandProviderRef.get();
        Ref argsEditorWrapper = new Ref();
        this.myGemCommandArgumentsComponent = RunConfigurationUIUtil.createRawEditorComponent((Ref<? super RawCommandLineEditor>)argsEditorWrapper, RBundle.message((String)"label.command.parameters"));
        this.myCommandArgumentsEditor = (RawCommandLineEditor)argsEditorWrapper.get();
    }

    public static LabeledComponent<TextFieldWithAutoCompletion> createGemComponent(@NotNull Project project, @NotNull Ref<? super TextFieldWithAutoCompletion> textFieldRef, @NotNull Ref<? super TextFieldWithAutoCompletionListProvider<GemInfo>> completionProviderRef) {
        if (project == null) {
            CommandRunConfigurationEditor.$$$reportNull$$$0(0);
        }
        if (textFieldRef == null) {
            CommandRunConfigurationEditor.$$$reportNull$$$0(1);
        }
        if (completionProviderRef == null) {
            CommandRunConfigurationEditor.$$$reportNull$$$0(2);
        }
        TextFieldWithAutoCompletionListProvider<GemInfo> provider = new TextFieldWithAutoCompletionListProvider<GemInfo>(null){

            protected Icon getIcon(@NotNull GemInfo item) {
                if (item == null) {
                    3.$$$reportNull$$$0(0);
                }
                return RubyIcons.Ruby.Rubygems;
            }

            @NotNull
            protected String getLookupString(@NotNull GemInfo item) {
                if (item == null) {
                    3.$$$reportNull$$$0(1);
                }
                String string = item.getName();
                if (string == null) {
                    3.$$$reportNull$$$0(2);
                }
                return string;
            }

            protected String getTypeText(@NotNull GemInfo item) {
                if (item == null) {
                    3.$$$reportNull$$$0(3);
                }
                return null;
            }

            public int compare(GemInfo item1, GemInfo item2) {
                return StringUtil.compare((String)item1.getName(), (String)item2.getName(), (boolean)false);
            }

            protected String getTailText(@NotNull GemInfo item) {
                if (item == null) {
                    3.$$$reportNull$$$0(4);
                }
                return null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "item";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jetbrains/plugins/ruby/command/run/CommandRunConfigurationEditor$3";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jetbrains/plugins/ruby/command/run/CommandRunConfigurationEditor$3";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getLookupString";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getIcon";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "getLookupString";
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "getTypeText";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "getTailText";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2 -> new IllegalStateException(string);
                };
            }
        };
        completionProviderRef.set((Object)provider);
        TextFieldWithAutoCompletion textField = new TextFieldWithAutoCompletion(project, (TextFieldWithAutoCompletionListProvider)provider, true, null);
        textFieldRef.set((Object)textField);
        LabeledComponent component = new LabeledComponent();
        component.setComponent((JComponent)textField);
        component.setText(RBundle.message((String)"command.run.configuration.editor.gem.component.text"));
        return component;
    }

    public static LabeledComponent<TextFieldWithAutoCompletion> createGemCommandComponent(@NotNull Project project, @NotNull Ref<? super TextFieldWithAutoCompletion> textFieldRef, @NotNull Ref<? super TextFieldWithAutoCompletionListProvider<GemCommand>> completionProviderRef) {
        if (project == null) {
            CommandRunConfigurationEditor.$$$reportNull$$$0(3);
        }
        if (textFieldRef == null) {
            CommandRunConfigurationEditor.$$$reportNull$$$0(4);
        }
        if (completionProviderRef == null) {
            CommandRunConfigurationEditor.$$$reportNull$$$0(5);
        }
        TextFieldWithAutoCompletionListProvider<GemCommand> provider = new TextFieldWithAutoCompletionListProvider<GemCommand>(null){

            protected Icon getIcon(@NotNull GemCommand item) {
                if (item == null) {
                    4.$$$reportNull$$$0(0);
                }
                return RubyIcons.Ruby.Rubygems;
            }

            @NotNull
            protected String getLookupString(@NotNull GemCommand item) {
                if (item == null) {
                    4.$$$reportNull$$$0(1);
                }
                String string = item.getCommandName();
                if (string == null) {
                    4.$$$reportNull$$$0(2);
                }
                return string;
            }

            protected String getTypeText(@NotNull GemCommand item) {
                if (item == null) {
                    4.$$$reportNull$$$0(3);
                }
                return null;
            }

            public int compare(GemCommand item1, GemCommand item2) {
                return StringUtil.compare((String)item1.getCommandName(), (String)item2.getCommandName(), (boolean)false);
            }

            protected String getTailText(@NotNull GemCommand item) {
                if (item == null) {
                    4.$$$reportNull$$$0(4);
                }
                return " " + item.getCommandName() + " executable";
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "item";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jetbrains/plugins/ruby/command/run/CommandRunConfigurationEditor$4";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jetbrains/plugins/ruby/command/run/CommandRunConfigurationEditor$4";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getLookupString";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getIcon";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "getLookupString";
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "getTypeText";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "getTailText";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2 -> new IllegalStateException(string);
                };
            }
        };
        completionProviderRef.set((Object)provider);
        TextFieldWithAutoCompletion textField = new TextFieldWithAutoCompletion(project, (TextFieldWithAutoCompletionListProvider)provider, true, null);
        textFieldRef.set((Object)textField);
        LabeledComponent component = new LabeledComponent();
        component.setComponent((JComponent)textField);
        component.setText(RBundle.message((String)"command.run.configuration.editor.gem.command.component.text"));
        return component;
    }

    public void refreshGems(Module module, TextFieldWithAutoCompletionListProvider<GemInfo> completionListProvider) {
        if (module != null) {
            List<GemInfo> allGems = RubyProjectGemSearchService.Companion.getAllGems(module);
            completionListProvider.setItems(allGems);
            return;
        }
        completionListProvider.setItems(null);
    }

    public void refreshCommands(Module module, TextFieldWithAutoCompletionListProvider<GemCommand> completionListProvider) {
        if (module != null) {
            GemCommandsCache commandsCache = GemCommandsCache.getInstance(module);
            Sdk sdk = this.myCommonEditor.getSdk();
            if (sdk != null) {
                Set<GemCommand> commands = commandsCache.getGemCommands(sdk);
                completionListProvider.setItems(commands);
                return;
            }
        }
        completionListProvider.setItems(null);
    }

    public void setAnchor(JComponent anchor) {
        this.myAnchor = anchor;
        this.myGemComponent.setAnchor(anchor);
        this.myGemCommandNameComponent.setAnchor(anchor);
        this.myGemCommandArgumentsComponent.setAnchor(anchor);
        this.myCommonEditor.setAnchor(anchor);
    }

    private void setupAnchor() {
        this.myAnchor = UIUtil.mergeComponentsWithAnchor((PanelWithAnchor[])new PanelWithAnchor[]{this.myCommonEditor, this.myGemComponent, this.myGemCommandNameComponent, this.myGemCommandArgumentsComponent});
    }

    protected void resetEditorFrom(@NotNull CommandRunConfiguration s) {
        if (s == null) {
            CommandRunConfigurationEditor.$$$reportNull$$$0(6);
        }
        CommandRunConfiguration.copyParams(s, this);
        this.myCommonEditor.resetEditorFrom(s);
    }

    protected void applyEditorTo(@NotNull CommandRunConfiguration config) throws ConfigurationException {
        if (config == null) {
            CommandRunConfigurationEditor.$$$reportNull$$$0(7);
        }
        CommandRunConfiguration.copyParams(this, config);
        this.myCommonEditor.applyEditorTo(config);
    }

    @NotNull
    protected JComponent createEditor() {
        JComponent jComponent = this.myContentPane;
        if (jComponent == null) {
            CommandRunConfigurationEditor.$$$reportNull$$$0(8);
        }
        return jComponent;
    }

    public JComponent getAnchor() {
        return this.myAnchor;
    }

    @Override
    public String getGemName() {
        return this.myGemNameTextField.getText();
    }

    @Override
    public void setGemName(String name) {
        this.myGemNameTextField.setText(StringUtil.notNullize((String)name));
    }

    @Override
    public String getExecutableName() {
        return this.myGemCommandNameTextField.getText();
    }

    @Override
    public String getExecutableArguments() {
        return ((RawCommandLineEditor)this.myGemCommandArgumentsComponent.getComponent()).getText();
    }

    @Override
    public void setExecutableName(String name) {
        this.myGemCommandNameTextField.setText(StringUtil.notNullize((String)name));
    }

    @Override
    public void setExecutableArguments(String args) {
        this.myCommandArgumentsEditor.setText(StringUtil.notNullize((String)args));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        this.createUIComponents();
        JPanel jPanel2 = new JPanel();
        this.myContentPane = jPanel2;
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(5, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        LabeledComponent<TextFieldWithAutoCompletion> labeledComponent = this.myGemCommandNameComponent;
        labeledComponent.setLabelLocation("West");
        labeledComponent.setText(DynamicBundle.getBundle((String)"messages/RBundle", CommandRunConfigurationEditor.class).getString("command.run.configuration.editor.gem.command.exec.name.text"));
        jPanel2.add((Component)labeledComponent, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        LabeledComponent<RawCommandLineEditor> labeledComponent2 = this.myGemCommandArgumentsComponent;
        labeledComponent2.setLabelLocation("West");
        labeledComponent2.setText(DynamicBundle.getBundle((String)"messages/RBundle", CommandRunConfigurationEditor.class).getString("command.run.configuration.editor.gem.command.arguments.component.text"));
        jPanel2.add((Component)labeledComponent2, new GridConstraints(2, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        this.myCommonOptionsPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        LabeledComponent<TextFieldWithAutoCompletion> labeledComponent3 = this.myGemComponent;
        labeledComponent3.setLabelLocation("West");
        labeledComponent3.setText(DynamicBundle.getBundle((String)"messages/RBundle", CommandRunConfigurationEditor.class).getString("command.run.configuration.editor.gem.name.component.text"));
        jPanel2.add((Component)labeledComponent3, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPane;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textFieldRef";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "completionProviderRef";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/command/run/CommandRunConfigurationEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/command/run/CommandRunConfigurationEditor";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createGemComponent";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createGemCommandComponent";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "resetEditorFrom";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "applyEditorTo";
                break;
            }
            case 8: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8 -> new IllegalStateException(string);
        };
    }
}

