/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.brakeman.fixes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.time.LocalDate;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.brakeman.BrakemanResponseKt;
import org.jetbrains.plugins.ruby.brakeman.Warning;
import org.jetbrains.plugins.ruby.brakeman.fixes.BrakemanConfigSaveQuickFix;
import org.jetbrains.plugins.ruby.brakeman.fixes.BrakemanIgnoreWarningQuickFixKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u001f\u0010\u0006\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tH\u0010\u00a2\u0006\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/plugins/ruby/brakeman/fixes/BrakemanIgnoreWarningQuickFix;", "Lorg/jetbrains/plugins/ruby/brakeman/fixes/BrakemanConfigSaveQuickFix;", "<init>", "()V", "getFamilyName", "", "updateFile", "fileText", "warning", "Lorg/jetbrains/plugins/ruby/brakeman/Warning;", "updateFile$intellij_ruby_backend", "intellij.ruby.backend"})
public final class BrakemanIgnoreWarningQuickFix
extends BrakemanConfigSaveQuickFix {
    public BrakemanIgnoreWarningQuickFix() {
        Object[] objectArray = new Object[]{"/config/brakeman.ignore"};
        String string = RBundle.message((String)"inspection.brakeman.notification.config.ignoreWarning.failed", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        objectArray = new Object[]{"/config/brakeman.ignore"};
        String string2 = RBundle.message((String)"inspection.brakeman.notification.config.saved", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        super("config", "brakeman.ignore", string, string2);
    }

    @NotNull
    public String getFamilyName() {
        String string = RBundle.message((String)"inspection.brakeman.fix.ignore");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @Override
    @Nullable
    public String updateFile$intellij_ruby_backend(@NotNull String fileText, @NotNull Warning warning) {
        String string;
        Intrinsics.checkNotNullParameter((Object)fileText, (String)"fileText");
        Intrinsics.checkNotNullParameter((Object)warning, (String)"warning");
        String ignoredWarningsPropertyName = "ignored_warnings";
        String updatedPropertyName = "updated";
        String string2 = LocalDate.now().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        String dateTime = string2;
        if (StringsKt.isBlank((CharSequence)fileText)) {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)ignoredWarningsPropertyName, (Object)CollectionsKt.listOf((Object)warning)), TuplesKt.to((Object)updatedPropertyName, (Object)dateTime)};
            Map newMap = MapsKt.mapOf((Pair[])pairArray);
            string = BrakemanResponseKt.getGson().toJson((Object)newMap);
        } else {
            String string3;
            try {
                JsonObject jsonObject = (JsonObject)BrakemanResponseKt.getGson().fromJson(fileText, JsonObject.class);
                JsonArray ignoredWarnings = jsonObject.get(ignoredWarningsPropertyName).getAsJsonArray();
                ignoredWarnings.add(BrakemanResponseKt.getGson().toJsonTree((Object)warning));
                jsonObject.add(updatedPropertyName, BrakemanResponseKt.getGson().toJsonTree((Object)dateTime));
                string3 = BrakemanResponseKt.getGson().toJson((JsonElement)jsonObject);
            }
            catch (JsonSyntaxException jsonSyntaxException) {
                BrakemanIgnoreWarningQuickFixKt.access$getLOG$p().warn("Failed to load brakeman.config json");
                return null;
            }
            string = string3;
        }
        String newIgnoreFileText = string;
        return newIgnoreFileText;
    }
}

