/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.brakeman;

import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PlainTextTokenTypes;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtilKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.brakeman.BrakemanHighlightSeverity;
import org.jetbrains.plugins.ruby.brakeman.BrakemanInspection;
import org.jetbrains.plugins.ruby.brakeman.Confidence;
import org.jetbrains.plugins.ruby.brakeman.Warning;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubySpaceUtil;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\b\u0080\b\u0018\u00002\u00020\u0001Bq\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0003\u0012\b\b\u0001\u0010\n\u001a\u00020\u0003\u0012\u0006\u0010\u000b\u001a\u00020\u0005\u0012\b\b\u0001\u0010\f\u001a\u00020\u0003\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0001\u0010\u000e\u001a\u0004\u0018\u00010\u0003\u0012\u000e\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0010\u00a2\u0006\u0004\b\u0011\u0010\u0012J\b\u0010\"\u001a\u00020\u0003H\u0007J\u0016\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(J,\u0010)\u001a\u0004\u0018\u00010**\u00020&2\u0006\u0010+\u001a\u00020\u00052\u0014\u0010,\u001a\u0010\u0012\u0004\u0012\u00020*\u0012\u0006\u0012\u0004\u0018\u00010*0-H\u0002J\f\u0010.\u001a\u00020/*\u00020*H\u0002J\f\u00100\u001a\u00020/*\u00020*H\u0002J\u000e\u00101\u001a\u0002022\u0006\u00103\u001a\u000204J\t\u00105\u001a\u00020\u0003H\u00c6\u0003J\t\u00106\u001a\u00020\u0005H\u00c6\u0003J\t\u00107\u001a\u00020\u0007H\u00c6\u0003J\t\u00108\u001a\u00020\u0003H\u00c6\u0003J\t\u00109\u001a\u00020\u0003H\u00c6\u0003J\t\u0010:\u001a\u00020\u0003H\u00c6\u0003J\t\u0010;\u001a\u00020\u0005H\u00c6\u0003J\t\u0010<\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010=\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010>\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0011\u0010?\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0010H\u00c6\u0003J\u0083\u0001\u0010@\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u00032\b\b\u0002\u0010\t\u001a\u00020\u00032\b\b\u0003\u0010\n\u001a\u00020\u00032\b\b\u0002\u0010\u000b\u001a\u00020\u00052\b\b\u0003\u0010\f\u001a\u00020\u00032\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u00032\n\b\u0003\u0010\u000e\u001a\u0004\u0018\u00010\u00032\u0010\b\u0002\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0010H\u00c6\u0001J\u0013\u0010A\u001a\u00020/2\b\u0010B\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010C\u001a\u00020\u0005H\u00d6\u0001J\t\u0010D\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0014R\u0011\u0010\t\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0014R\u0011\u0010\n\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0014R\u0011\u0010\u000b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0016R\u0011\u0010\f\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0014R\u0013\u0010\r\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0014R\u0013\u0010\u000e\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0014R\u0019\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!\u00a8\u0006E"}, d2={"Lorg/jetbrains/plugins/ruby/brakeman/Warning;", "", "file", "", "line", "", "confidence", "Lorg/jetbrains/plugins/ruby/brakeman/Confidence;", "fingerprint", "link", "message", "warningCode", "warningType", "checkName", "code", "cweId", "", "<init>", "(Ljava/lang/String;ILorg/jetbrains/plugins/ruby/brakeman/Confidence;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/List;)V", "getFile", "()Ljava/lang/String;", "getLine", "()I", "getConfidence", "()Lorg/jetbrains/plugins/ruby/brakeman/Confidence;", "getFingerprint", "getLink", "getMessage", "getWarningCode", "getWarningType", "getCheckName", "getCode", "getCweId", "()Ljava/util/List;", "toResultTreeMessage", "getTextRange", "Lcom/intellij/openapi/util/TextRange;", "psiFile", "Lcom/intellij/psi/PsiFile;", "document", "Lcom/intellij/openapi/editor/Document;", "findNonWhitespaceElementAt", "Lcom/intellij/psi/PsiElement;", "offset", "next", "Lkotlin/Function1;", "isWhitespace", "", "isPlainText", "getHighlightSeverity", "Lorg/jetbrains/plugins/ruby/brakeman/BrakemanHighlightSeverity;", "brakemanInspection", "Lorg/jetbrains/plugins/ruby/brakeman/BrakemanInspection;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "component10", "component11", "copy", "equals", "other", "hashCode", "toString", "intellij.ruby.backend"})
public final class Warning {
    @NotNull
    private final String file;
    private final int line;
    @NotNull
    private final Confidence confidence;
    @NotNull
    private final String fingerprint;
    @NotNull
    private final String link;
    @NotNull
    private final String message;
    private final int warningCode;
    @NotNull
    private final String warningType;
    @Nullable
    private final String checkName;
    @Nullable
    private final String code;
    @Nullable
    private final List<Integer> cweId;

    public Warning(@NotNull String file, int line, @NotNull Confidence confidence, @NotNull String fingerprint, @NotNull String link, @NlsSafe @NotNull String message, int warningCode, @InspectionMessage @NotNull String warningType, @Nullable String checkName, @NlsContexts.Tooltip @Nullable String code, @Nullable List<Integer> cweId) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)((Object)confidence), (String)"confidence");
        Intrinsics.checkNotNullParameter((Object)fingerprint, (String)"fingerprint");
        Intrinsics.checkNotNullParameter((Object)link, (String)"link");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)warningType, (String)"warningType");
        this.file = file;
        this.line = line;
        this.confidence = confidence;
        this.fingerprint = fingerprint;
        this.link = link;
        this.message = message;
        this.warningCode = warningCode;
        this.warningType = warningType;
        this.checkName = checkName;
        this.code = code;
        this.cweId = cweId;
    }

    @NotNull
    public final String getFile() {
        return this.file;
    }

    public final int getLine() {
        return this.line;
    }

    @NotNull
    public final Confidence getConfidence() {
        return this.confidence;
    }

    @NotNull
    public final String getFingerprint() {
        return this.fingerprint;
    }

    @NotNull
    public final String getLink() {
        return this.link;
    }

    @NotNull
    public final String getMessage() {
        return this.message;
    }

    public final int getWarningCode() {
        return this.warningCode;
    }

    @NotNull
    public final String getWarningType() {
        return this.warningType;
    }

    @Nullable
    public final String getCheckName() {
        return this.checkName;
    }

    @Nullable
    public final String getCode() {
        return this.code;
    }

    @Nullable
    public final List<Integer> getCweId() {
        return this.cweId;
    }

    @InspectionMessage
    @NotNull
    public final String toResultTreeMessage() {
        return this.line + " - " + this.warningType;
    }

    @NotNull
    public final TextRange getTextRange(@NotNull PsiFile psiFile, @NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        int startLineOffset = document.getLineStartOffset(this.line - 1);
        int endLineOffset = document.getLineEndOffset(this.line - 1);
        if (this.isPlainText((PsiElement)psiFile)) {
            return new TextRange(startLineOffset, endLineOffset);
        }
        PsiElement psiElement = this.findNonWhitespaceElementAt(psiFile, startLineOffset, (Function1<? super PsiElement, ? extends PsiElement>)((Function1)getTextRange.nonWhiteSpaceStartOffset.1.INSTANCE));
        int nonWhiteSpaceStartOffset2 = psiElement != null ? PsiTreeUtilKt.getStartOffset((PsiElement)psiElement) : startLineOffset;
        PsiElement psiElement2 = this.findNonWhitespaceElementAt(psiFile, endLineOffset, (Function1<? super PsiElement, ? extends PsiElement>)((Function1)getTextRange.nonWhiteSpaceEndOffset.1.INSTANCE));
        int nonWhiteSpaceEndOffset2 = psiElement2 != null ? PsiTreeUtilKt.getEndOffset((PsiElement)psiElement2) : endLineOffset;
        int startOffset = Math.max(startLineOffset, nonWhiteSpaceStartOffset2);
        int endOffset = Math.min(endLineOffset, nonWhiteSpaceEndOffset2);
        return new TextRange(startOffset, endOffset);
    }

    private final PsiElement findNonWhitespaceElementAt(PsiFile $this$findNonWhitespaceElementAt, int offset, Function1<? super PsiElement, ? extends PsiElement> next) {
        PsiElement psiElement = $this$findNonWhitespaceElementAt.findElementAt(offset);
        while (psiElement != null && this.isWhitespace(psiElement)) {
            psiElement = (PsiElement)next.invoke((Object)psiElement);
        }
        return psiElement;
    }

    private final boolean isWhitespace(PsiElement $this$isWhitespace) {
        return $this$isWhitespace instanceof PsiWhiteSpace || RubySpaceUtil.isAnySpace((PsiElement)$this$isWhitespace);
    }

    private final boolean isPlainText(PsiElement $this$isPlainText) {
        return Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)$this$isPlainText), (Object)PlainTextTokenTypes.PLAIN_TEXT);
    }

    @NotNull
    public final BrakemanHighlightSeverity getHighlightSeverity(@NotNull BrakemanInspection brakemanInspection) {
        Intrinsics.checkNotNullParameter((Object)((Object)brakemanInspection), (String)"brakemanInspection");
        return (BrakemanHighlightSeverity)((Object)this.confidence.getInspectionSettingsProperty().get((Object)brakemanInspection));
    }

    @NotNull
    public final String component1() {
        return this.file;
    }

    public final int component2() {
        return this.line;
    }

    @NotNull
    public final Confidence component3() {
        return this.confidence;
    }

    @NotNull
    public final String component4() {
        return this.fingerprint;
    }

    @NotNull
    public final String component5() {
        return this.link;
    }

    @NotNull
    public final String component6() {
        return this.message;
    }

    public final int component7() {
        return this.warningCode;
    }

    @NotNull
    public final String component8() {
        return this.warningType;
    }

    @Nullable
    public final String component9() {
        return this.checkName;
    }

    @Nullable
    public final String component10() {
        return this.code;
    }

    @Nullable
    public final List<Integer> component11() {
        return this.cweId;
    }

    @NotNull
    public final Warning copy(@NotNull String file, int line, @NotNull Confidence confidence, @NotNull String fingerprint, @NotNull String link, @NlsSafe @NotNull String message, int warningCode, @InspectionMessage @NotNull String warningType, @Nullable String checkName, @NlsContexts.Tooltip @Nullable String code, @Nullable List<Integer> cweId) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)((Object)confidence), (String)"confidence");
        Intrinsics.checkNotNullParameter((Object)fingerprint, (String)"fingerprint");
        Intrinsics.checkNotNullParameter((Object)link, (String)"link");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)warningType, (String)"warningType");
        return new Warning(file, line, confidence, fingerprint, link, message, warningCode, warningType, checkName, code, cweId);
    }

    public static /* synthetic */ Warning copy$default(Warning warning, String string, int n, Confidence confidence, String string2, String string3, String string4, int n2, String string5, String string6, String string7, List list, int n3, Object object) {
        if ((n3 & 1) != 0) {
            string = warning.file;
        }
        if ((n3 & 2) != 0) {
            n = warning.line;
        }
        if ((n3 & 4) != 0) {
            confidence = warning.confidence;
        }
        if ((n3 & 8) != 0) {
            string2 = warning.fingerprint;
        }
        if ((n3 & 0x10) != 0) {
            string3 = warning.link;
        }
        if ((n3 & 0x20) != 0) {
            string4 = warning.message;
        }
        if ((n3 & 0x40) != 0) {
            n2 = warning.warningCode;
        }
        if ((n3 & 0x80) != 0) {
            string5 = warning.warningType;
        }
        if ((n3 & 0x100) != 0) {
            string6 = warning.checkName;
        }
        if ((n3 & 0x200) != 0) {
            string7 = warning.code;
        }
        if ((n3 & 0x400) != 0) {
            list = warning.cweId;
        }
        return warning.copy(string, n, confidence, string2, string3, string4, n2, string5, string6, string7, list);
    }

    @NotNull
    public String toString() {
        return "Warning(file=" + this.file + ", line=" + this.line + ", confidence=" + this.confidence + ", fingerprint=" + this.fingerprint + ", link=" + this.link + ", message=" + this.message + ", warningCode=" + this.warningCode + ", warningType=" + this.warningType + ", checkName=" + this.checkName + ", code=" + this.code + ", cweId=" + this.cweId + ")";
    }

    public int hashCode() {
        int result = this.file.hashCode();
        result = result * 31 + Integer.hashCode(this.line);
        result = result * 31 + this.confidence.hashCode();
        result = result * 31 + this.fingerprint.hashCode();
        result = result * 31 + this.link.hashCode();
        result = result * 31 + this.message.hashCode();
        result = result * 31 + Integer.hashCode(this.warningCode);
        result = result * 31 + this.warningType.hashCode();
        result = result * 31 + (this.checkName == null ? 0 : this.checkName.hashCode());
        result = result * 31 + (this.code == null ? 0 : this.code.hashCode());
        result = result * 31 + (this.cweId == null ? 0 : ((Object)this.cweId).hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Warning)) {
            return false;
        }
        Warning warning = (Warning)other;
        if (!Intrinsics.areEqual((Object)this.file, (Object)warning.file)) {
            return false;
        }
        if (this.line != warning.line) {
            return false;
        }
        if (this.confidence != warning.confidence) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.fingerprint, (Object)warning.fingerprint)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.link, (Object)warning.link)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.message, (Object)warning.message)) {
            return false;
        }
        if (this.warningCode != warning.warningCode) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.warningType, (Object)warning.warningType)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.checkName, (Object)warning.checkName)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.code, (Object)warning.code)) {
            return false;
        }
        return Intrinsics.areEqual(this.cweId, warning.cweId);
    }
}

