/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.brakeman;

import com.google.gson.JsonSyntaxException;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.brakeman.BrakemanExecutionErrorNotification;
import org.jetbrains.plugins.ruby.brakeman.BrakemanInspection;
import org.jetbrains.plugins.ruby.brakeman.BrakemanLinterKt;
import org.jetbrains.plugins.ruby.brakeman.BrakemanResponse;
import org.jetbrains.plugins.ruby.brakeman.BrakemanResponseKt;
import org.jetbrains.plugins.ruby.brakeman.BrakemanUnknownExecutionError;
import org.jetbrains.plugins.ruby.brakeman.RailsNotFoundNotification;
import org.jetbrains.plugins.ruby.brakeman.utils.YamlUtilKt;
import org.jetbrains.plugins.ruby.ruby.run.context.RubyScriptExecutionContext;
import org.jetbrains.plugins.ruby.statistic.BrakemanCountCollector;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001f\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b\fJ\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/plugins/ruby/brakeman/BrakemanLinter;", "", "brakemanInspection", "Lorg/jetbrains/plugins/ruby/brakeman/BrakemanInspection;", "<init>", "(Lorg/jetbrains/plugins/ruby/brakeman/BrakemanInspection;)V", "execute", "Lorg/jetbrains/plugins/ruby/brakeman/BrakemanResponse;", "rubyContext", "Lorg/jetbrains/plugins/ruby/ruby/run/context/RubyScriptExecutionContext;", "workDir", "Lcom/intellij/openapi/vfs/VirtualFile;", "execute$intellij_ruby_backend", "outputFilesArguments", "", "", "processWrongExitCode", "", "exitCode", "", "stderr", "Companion", "intellij.ruby.backend"})
@SourceDebugExtension(value={"SMAP\nBrakemanLinter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BrakemanLinter.kt\norg/jetbrains/plugins/ruby/brakeman/BrakemanLinter\n+ 2 YamlUtil.kt\norg/jetbrains/plugins/ruby/brakeman/utils/YamlUtilKt\n+ 3 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,98:1\n23#2:99\n16#2,3:100\n15#2:103\n19#3:104\n808#4,11:105\n*S KotlinDebug\n*F\n+ 1 BrakemanLinter.kt\norg/jetbrains/plugins/ruby/brakeman/BrakemanLinter\n*L\n71#1:99\n71#1:100,3\n71#1:103\n71#1:104\n71#1:105,11\n*E\n"})
public final class BrakemanLinter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BrakemanInspection brakemanInspection;
    @NotNull
    public static final String GEM_NAME = "brakeman";
    @NotNull
    public static final String BRAKEMAN_PROXY_SCRIPT_PATH = "rb/scripts/brakeman_rm_proxy.rb";
    @NotNull
    public static final String IGNORE_FILE_DIR = "config";
    @NotNull
    public static final String IGNORE_FILE_NAME = "brakeman.ignore";
    @NotNull
    public static final String CONFIG_FILE_DIR = "config";
    @NotNull
    public static final String CONFIG_FILE_NAME = "brakeman.yml";
    @NotNull
    public static final String MINIMAL_SUPPORTED_VERSION = "5.0.0";

    public BrakemanLinter(@NotNull BrakemanInspection brakemanInspection) {
        Intrinsics.checkNotNullParameter((Object)((Object)brakemanInspection), (String)"brakemanInspection");
        this.brakemanInspection = brakemanInspection;
    }

    @Nullable
    public final BrakemanResponse execute$intellij_ruby_backend(@NotNull RubyScriptExecutionContext rubyContext, @NotNull VirtualFile workDir) {
        Intrinsics.checkNotNullParameter((Object)rubyContext, (String)"rubyContext");
        Intrinsics.checkNotNullParameter((Object)workDir, (String)"workDir");
        List additionalArgs = CollectionsKt.plus((Collection)this.outputFilesArguments(workDir), (Object)("-w" + this.brakemanInspection.getLevel$intellij_ruby_backend().getNumber()));
        ProcessOutput processOutput = ((RubyScriptExecutionContext)((RubyScriptExecutionContext)rubyContext.withWorkingDirPath(workDir.getPath())).withArguments(additionalArgs)).executeScript();
        if (processOutput == null) {
            BrakemanLinterKt.access$getLOG$p().warn("Null process output");
            return null;
        }
        if (!processOutput.isExitCodeSet()) {
            BrakemanLinterKt.access$getLOG$p().debug("Brakeman process was interrupted or never finished.");
            return null;
        }
        String string = processOutput.getStdout();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStdout(...)");
        String stdout = string;
        int exitCode = processOutput.getExitCode();
        if (exitCode != 0) {
            String string2 = processOutput.getStderr();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getStderr(...)");
            String stderr = string2;
            Object[] objectArray = new Object[]{exitCode, ", stdout=", stdout, ", stderr=", stderr};
            BrakemanLinterKt.access$getLOG$p().debug("Brakeman exited: code=", objectArray);
            this.processWrongExitCode(exitCode, stderr);
            return null;
        }
        try {
            BrakemanResponse response = (BrakemanResponse)BrakemanResponseKt.getGson().fromJson(stdout, BrakemanResponse.class);
            if (response == null) {
                BrakemanLinterKt.access$getLOG$p().warn("Failed to parse Brakeman output json");
                return null;
            }
            BrakemanCountCollector.INSTANCE.logReturnedWarnings(response.getWarnings());
            return response;
        }
        catch (JsonSyntaxException jsonSyntaxException) {
            BrakemanLinterKt.access$getLOG$p().warn("Exception while parsing json output");
            return null;
        }
    }

    /*
     * Unable to fully structure code
     */
    private final List<String> outputFilesArguments(VirtualFile workDir) {
        v0 = workDir.findFileByRelativePath("config/brakeman.yml");
        if (v0 == null) {
            return CollectionsKt.emptyList();
        }
        config = v0;
        var5_3 = VirtualFileUtil.readText((VirtualFile)config);
        property$iv = "output_files";
        $i$f$loadList = false;
        var8_6 = YamlUtilKt.loadWithExceptionHandling((String)text$iv);
        property$iv$iv = property$iv;
        $i$f$loadList = false;
        if (map$iv$iv == null || (var11_9 = YamlUtilKt.getProperty((Map<Object, ? extends Object>)map$iv$iv, property$iv$iv)) == null) ** GOTO lbl-1000
        var12_10 = var11_9;
        $i$f$asSafely = false;
        v1 = $this$asSafely$iv$iv$iv;
        if (!(v1 instanceof List)) {
            v1 = null;
        }
        if ((var14_12 = (List)v1) != null) {
            $this$asSafely$iv$iv$iv = var14_12;
            $i$f$filterIsInstance = false;
            var15_13 = $this$filterIsInstance$iv$iv$iv;
            destination$iv$iv$iv$iv = new ArrayList<E>();
            $i$f$filterIsInstanceTo = false;
            for (T element$iv$iv$iv$iv : $this$filterIsInstanceTo$iv$iv$iv$iv) {
                if (!(element$iv$iv$iv$iv instanceof String)) continue;
                destination$iv$iv$iv$iv.add(element$iv$iv$iv$iv);
            }
            v2 = (List)destination$iv$iv$iv$iv;
        } else lbl-1000:
        // 2 sources

        {
            v2 = null;
        }
        if (v2 == null) {
            return CollectionsKt.emptyList();
        }
        outputFiles = v2;
        args = new ArrayList<String>(outputFiles.size() * 2);
        for (String outputFile : outputFiles) {
            args.add("--output");
            args.add(outputFile);
        }
        return args;
    }

    private final void processWrongExitCode(int exitCode, String stderr) {
        BrakemanCountCollector.INSTANCE.logFailedExecution(exitCode);
        switch (exitCode) {
            case 4: {
                BrakemanLinterKt.access$getLOG$p().warn("Not a rails project");
                new RailsNotFoundNotification().show();
                break;
            }
            case 255: {
                BrakemanLinterKt.access$getLOG$p().warn("Brakeman execution error or wrong arguments");
                new BrakemanExecutionErrorNotification().show();
                break;
            }
            default: {
                BrakemanLinterKt.access$getLOG$p().warn("Unknown exit code " + exitCode);
                new BrakemanUnknownExecutionError(exitCode, stderr).show();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/plugins/ruby/brakeman/BrakemanLinter$Companion;", "", "<init>", "()V", "GEM_NAME", "", "BRAKEMAN_PROXY_SCRIPT_PATH", "IGNORE_FILE_DIR", "IGNORE_FILE_NAME", "CONFIG_FILE_DIR", "CONFIG_FILE_NAME", "MINIMAL_SUPPORTED_VERSION", "intellij.ruby.backend"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

