/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.brakeman;

import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.ui.DefaultInspectionToolPresentation;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.ui.dsl.builder.BottomGap;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.TopGap;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.brakeman.BrakemanHighlightSeverity;
import org.jetbrains.plugins.ruby.brakeman.BrakemanProblemDescriptor;
import org.jetbrains.plugins.ruby.brakeman.Warning;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u000e\u0010\u0002\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001a\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0016\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0003J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/plugins/ruby/brakeman/BrakemanInspectionToolPresentation;", "Lcom/intellij/codeInspection/ui/DefaultInspectionToolPresentation;", "toolWrapper", "Lcom/intellij/codeInspection/ex/InspectionToolWrapper;", "context", "Lcom/intellij/codeInspection/ex/GlobalInspectionContextImpl;", "<init>", "(Lcom/intellij/codeInspection/ex/InspectionToolWrapper;Lcom/intellij/codeInspection/ex/GlobalInspectionContextImpl;)V", "getCustomActionsPanel", "Ljavax/swing/JComponent;", "descriptor", "Lcom/intellij/codeInspection/CommonProblemDescriptor;", "parent", "Lcom/intellij/openapi/Disposable;", "getCweText", "", "cweIds", "", "", "shouldAlignCustomActionPanelToLeft", "", "suppressProblem", "", "entity", "Lcom/intellij/codeInspection/reference/RefEntity;", "intellij.ruby.backend"})
public final class BrakemanInspectionToolPresentation
extends DefaultInspectionToolPresentation {
    public BrakemanInspectionToolPresentation(@NotNull InspectionToolWrapper<?, ?> toolWrapper, @NotNull GlobalInspectionContextImpl context) {
        Intrinsics.checkNotNullParameter(toolWrapper, (String)"toolWrapper");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(toolWrapper, context);
    }

    @Nullable
    public JComponent getCustomActionsPanel(@NotNull CommonProblemDescriptor descriptor, @NotNull Disposable parent) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        if (!(descriptor instanceof BrakemanProblemDescriptor)) {
            return null;
        }
        Warning warning = ((BrakemanProblemDescriptor)descriptor).getWarning();
        BrakemanHighlightSeverity severity = ((BrakemanProblemDescriptor)descriptor).getBrakemanHighlightSeverity();
        String string = new HtmlBuilder().append(HtmlChunk.text((String)RBundle.message((String)"inspection.brakeman.warning.description.learnMore"))).appendLink(warning.getLink(), RBundle.message((String)"inspection.brakeman.warning.description.warning.type")).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String linkDescription = string;
        String string2 = new HtmlBuilder().append(RBundle.message((String)"inspection.brakeman.warning.description.confidence")).appendLink("https://brakemanscanner.org/docs/confidence/", warning.getConfidence().getDisplayName()).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        String confidenceText = string2;
        int maxLineLength = 50;
        return (JComponent)BuilderKt.panel(arg_0 -> BrakemanInspectionToolPresentation.getCustomActionsPanel$lambda$7(warning, confidenceText, severity, maxLineLength, linkDescription, this, arg_0));
    }

    @NlsContexts.Label
    private final String getCweText(List<Integer> cweIds) {
        HtmlBuilder cweHtml = new HtmlBuilder().append(RBundle.message((String)"inspection.brakeman.warning.description.cwe"));
        Iterator<Integer> iterator = cweIds.iterator();
        while (iterator.hasNext()) {
            int cweId = ((Number)iterator.next()).intValue();
            cweHtml.appendLink("https://cwe.mitre.org/data/definitions/" + cweId + ".html", "CWE-" + cweId);
            if (!iterator.hasNext()) continue;
            cweHtml.append(", ");
        }
        String string = cweHtml.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public boolean shouldAlignCustomActionPanelToLeft() {
        return true;
    }

    public void suppressProblem(@NotNull RefEntity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
    }

    private static final Unit getCustomActionsPanel$lambda$7$lambda$6$lambda$0(Warning $warning, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.label($warning.getWarningType()).bold();
        return Unit.INSTANCE;
    }

    private static final Unit getCustomActionsPanel$lambda$7$lambda$6$lambda$1(String $confidenceText, BrakemanHighlightSeverity $severity, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Row.text$default((Row)$this$row, (String)$confidenceText, (int)0, null, (int)6, null);
        $this$row.icon($severity.getIcon());
        return Unit.INSTANCE;
    }

    private static final Unit getCustomActionsPanel$lambda$7$lambda$6$lambda$2(Warning $warning, int $maxLineLength, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Row.text$default((Row)$this$row, (String)$warning.getMessage(), (int)$maxLineLength, null, (int)4, null);
        return Unit.INSTANCE;
    }

    private static final Unit getCustomActionsPanel$lambda$7$lambda$6$lambda$3(String $linkDescription, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Row.text$default((Row)$this$row, (String)$linkDescription, (int)0, null, (int)6, null);
        return Unit.INSTANCE;
    }

    private static final Unit getCustomActionsPanel$lambda$7$lambda$6$lambda$4(BrakemanInspectionToolPresentation this$0, Warning $warning, int $maxLineLength, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Row.text$default((Row)$this$row, (String)this$0.getCweText($warning.getCweId()), (int)$maxLineLength, null, (int)4, null);
        return Unit.INSTANCE;
    }

    private static final Unit getCustomActionsPanel$lambda$7$lambda$6$lambda$5(String $linkDescription, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Row.text$default((Row)$this$row, (String)$linkDescription, (int)0, null, (int)6, null);
        return Unit.INSTANCE;
    }

    private static final Unit getCustomActionsPanel$lambda$7$lambda$6(Warning $warning, String $confidenceText, BrakemanHighlightSeverity $severity, int $maxLineLength, String $linkDescription, BrakemanInspectionToolPresentation this$0, Panel $this$indent) {
        Intrinsics.checkNotNullParameter((Object)$this$indent, (String)"$this$indent");
        Panel.row$default((Panel)$this$indent, null, arg_0 -> BrakemanInspectionToolPresentation.getCustomActionsPanel$lambda$7$lambda$6$lambda$0($warning, arg_0), (int)1, null).topGap(TopGap.SMALL);
        Panel.row$default((Panel)$this$indent, null, arg_0 -> BrakemanInspectionToolPresentation.getCustomActionsPanel$lambda$7$lambda$6$lambda$1($confidenceText, $severity, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$indent, null, arg_0 -> BrakemanInspectionToolPresentation.getCustomActionsPanel$lambda$7$lambda$6$lambda$2($warning, $maxLineLength, arg_0), (int)1, null);
        if ($warning.getCweId() != null) {
            Panel.row$default((Panel)$this$indent, null, arg_0 -> BrakemanInspectionToolPresentation.getCustomActionsPanel$lambda$7$lambda$6$lambda$3($linkDescription, arg_0), (int)1, null);
            v0 = Panel.row$default((Panel)$this$indent, null, arg_0 -> BrakemanInspectionToolPresentation.getCustomActionsPanel$lambda$7$lambda$6$lambda$4(this$0, $warning, $maxLineLength, arg_0), (int)1, null).bottomGap(BottomGap.SMALL);
        } else {
            v0 = Panel.row$default((Panel)$this$indent, null, arg_0 -> BrakemanInspectionToolPresentation.getCustomActionsPanel$lambda$7$lambda$6$lambda$5($linkDescription, arg_0), (int)1, null).bottomGap(BottomGap.SMALL);
        }
        return Unit.INSTANCE;
    }

    private static final Unit getCustomActionsPanel$lambda$7(Warning $warning, String $confidenceText, BrakemanHighlightSeverity $severity, int $maxLineLength, String $linkDescription, BrakemanInspectionToolPresentation this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        $this$panel.indent(arg_0 -> BrakemanInspectionToolPresentation.getCustomActionsPanel$lambda$7$lambda$6($warning, $confidenceText, $severity, $maxLineLength, $linkDescription, this$0, arg_0));
        return Unit.INSTANCE;
    }
}

