/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.brakeman;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.icons.AllIcons;
import com.intellij.lang.annotation.HighlightSeverity;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u0014\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u00a8\u0006\u0006"}, d2={"findIconFor", "Ljavax/swing/Icon;", "highlightSeverity", "Lcom/intellij/lang/annotation/HighlightSeverity;", "highlightTypeOf", "Lcom/intellij/codeInspection/ProblemHighlightType;", "intellij.ruby.backend"})
public final class BrakemanHighlightSeverityKt {
    private static final Icon findIconFor(HighlightSeverity highlightSeverity) {
        Icon icon;
        if (Intrinsics.areEqual((Object)highlightSeverity, (Object)HighlightSeverity.INFORMATION)) {
            Icon icon2 = AllIcons.General.Information;
            Intrinsics.checkNotNull((Object)icon2);
            icon = icon2;
        } else {
            HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.Companion.find(highlightSeverity);
            Intrinsics.checkNotNull((Object)highlightDisplayLevel);
            icon = highlightDisplayLevel.getIcon();
        }
        return icon;
    }

    private static final ProblemHighlightType highlightTypeOf(HighlightSeverity highlightSeverity) {
        HighlightInfoType highlightInfoType = HighlightInfo.convertSeverity((HighlightSeverity)highlightSeverity);
        Intrinsics.checkNotNullExpressionValue((Object)highlightInfoType, (String)"convertSeverity(...)");
        HighlightInfoType highlightInfoType2 = highlightInfoType;
        ProblemHighlightType problemHighlightType = HighlightInfo.convertType((HighlightInfoType)highlightInfoType2);
        Intrinsics.checkNotNullExpressionValue((Object)problemHighlightType, (String)"convertType(...)");
        return problemHighlightType;
    }

    public static final /* synthetic */ Icon access$findIconFor(HighlightSeverity highlightSeverity) {
        return BrakemanHighlightSeverityKt.findIconFor(highlightSeverity);
    }

    public static final /* synthetic */ ProblemHighlightType access$highlightTypeOf(HighlightSeverity highlightSeverity) {
        return BrakemanHighlightSeverityKt.highlightTypeOf(highlightSeverity);
    }
}

