/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.brakeman;

import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.Tools;
import com.intellij.codeInspection.lang.GlobalInspectionContextExtension;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.brakeman.BrakemanExecutionContextUtilKt;
import org.jetbrains.plugins.ruby.brakeman.BrakemanGlobalInspectionContextKt;
import org.jetbrains.plugins.ruby.brakeman.BrakemanInspection;
import org.jetbrains.plugins.ruby.brakeman.BrakemanLinter;
import org.jetbrains.plugins.ruby.brakeman.BrakemanParserError;
import org.jetbrains.plugins.ruby.brakeman.BrakemanResponse;
import org.jetbrains.plugins.ruby.brakeman.Error;
import org.jetbrains.plugins.ruby.brakeman.Warning;
import org.jetbrains.plugins.ruby.ruby.lang.RubyFileType;
import org.jetbrains.plugins.ruby.ruby.run.context.RubyScriptExecutionContext;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 -2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001-B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00000\u0005H\u0016J,\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\t2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\t2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J(\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0018\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u00182\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J&\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u001f\u001a\u00020\b2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010!\u001a\u00020\u0017H\u0002J\u001d\u0010\"\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t2\u0006\u0010#\u001a\u00020\u0017H\u0000\u00a2\u0006\u0002\b$J\u001e\u0010%\u001a\u0010\u0012\u0004\u0012\u00020\u0017\u0012\u0006\u0012\u0004\u0018\u00010\u001c0&2\u0006\u0010\u0013\u001a\u00020\u0018H\u0002J&\u0010'\u001a\u00020\u000f2\u0014\u0010(\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030*0)2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010+\u001a\u00020\u000fH\u0016J\u0006\u0010,\u001a\u00020\rR6\u0010\u0006\u001a*\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u0007j\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lorg/jetbrains/plugins/ruby/brakeman/BrakemanGlobalInspectionContext;", "Lcom/intellij/codeInspection/lang/GlobalInspectionContextExtension;", "<init>", "()V", "getID", "Lcom/intellij/openapi/util/Key;", "filesCache", "Ljava/util/HashMap;", "", "", "Lorg/jetbrains/plugins/ruby/brakeman/Warning;", "Lkotlin/collections/HashMap;", "shouldStop", "", "performPreRunActivities", "", "globalTools", "Lcom/intellij/codeInspection/ex/Tools;", "localTools", "context", "Lcom/intellij/codeInspection/GlobalInspectionContext;", "lintRoot", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/intellij/codeInspection/ex/GlobalInspectionContextImpl;", "linter", "Lorg/jetbrains/plugins/ruby/brakeman/BrakemanLinter;", "executionContext", "Lorg/jetbrains/plugins/ruby/ruby/run/context/RubyScriptExecutionContext;", "getWorkingDir", "addWarningsToCache", "fileName", "warnings", "workingDir", "getWarningsByFile", "vFile", "getWarningsByFile$intellij_ruby_backend", "collectRootsWithContext", "", "performPostRunActivities", "inspections", "", "Lcom/intellij/codeInspection/ex/InspectionToolWrapper;", "cleanup", "shouldNotRunInspection", "Companion", "intellij.ruby.backend"})
@SourceDebugExtension(value={"SMAP\nBrakemanGlobalInspectionContext.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BrakemanGlobalInspectionContext.kt\norg/jetbrains/plugins/ruby/brakeman/BrakemanGlobalInspectionContext\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,192:1\n536#2:193\n521#2,6:194\n382#2,7:217\n136#3,9:200\n216#3:209\n217#3:211\n145#3:212\n216#3,2:227\n1#4:210\n1491#5:213\n1516#5,3:214\n1519#5,3:224\n*S KotlinDebug\n*F\n+ 1 BrakemanGlobalInspectionContext.kt\norg/jetbrains/plugins/ruby/brakeman/BrakemanGlobalInspectionContext\n*L\n59#1:193\n59#1:194,6\n108#1:217,7\n59#1:200,9\n59#1:209\n59#1:211\n59#1:212\n108#1:227,2\n59#1:210\n108#1:213\n108#1:214,3\n108#1:224,3\n*E\n"})
public final class BrakemanGlobalInspectionContext
implements GlobalInspectionContextExtension<BrakemanGlobalInspectionContext> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final HashMap<String, List<Warning>> filesCache = new HashMap();
    private boolean shouldStop = true;
    @NotNull
    private static final Key<BrakemanGlobalInspectionContext> ID;

    @NotNull
    public Key<BrakemanGlobalInspectionContext> getID() {
        return ID;
    }

    /*
     * WARNING - void declaration
     */
    public void performPreRunActivities(@NotNull List<? extends Tools> globalTools, @NotNull List<? extends Tools> localTools, @NotNull GlobalInspectionContext context) {
        boolean dontContinue;
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        void $this$filterTo$iv$iv;
        Map $this$performPreRunActivities_u24lambda_u24022;
        Intrinsics.checkNotNullParameter(globalTools, (String)"globalTools");
        Intrinsics.checkNotNullParameter(localTools, (String)"localTools");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.shouldStop = true;
        if (!(context instanceof GlobalInspectionContextImpl)) {
            Object[] objectArray = new Object[]{context.getClass().getName()};
            BrakemanGlobalInspectionContextKt.access$getLOG$p().debug("Wrong context: ", objectArray);
            return;
        }
        Tools tools = (Tools)((GlobalInspectionContextImpl)context).getTools().get(BrakemanInspection.Companion.getShortName());
        if (tools == null) {
            BrakemanGlobalInspectionContext $this$performPreRunActivities_u24lambda_u24022 = this;
            boolean bl = false;
            BrakemanGlobalInspectionContextKt.access$getLOG$p().debug("No brakeman selected");
            return;
        }
        Tools brakemanTool = tools;
        ApplicationEx application = ApplicationManagerEx.getApplicationEx();
        if (application.isSaveAllowed()) {
            application.invokeAndWait(BrakemanGlobalInspectionContext::performPreRunActivities$lambda$1);
        }
        if (($this$performPreRunActivities_u24lambda_u24022 = this.collectRootsWithContext((GlobalInspectionContextImpl)context)).isEmpty()) {
            boolean bl = false;
            BrakemanGlobalInspectionContextKt.access$getLOG$p().debug("No roots to lint");
            return;
        }
        Map rootsWithContext = $this$performPreRunActivities_u24lambda_u24022;
        Project project = ((GlobalInspectionContextImpl)context).getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        Map $this$filter$iv = rootsWithContext;
        boolean $i$f$filter = false;
        Map map = $this$filter$iv;
        Map entry = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator.next();
            boolean bl = false;
            if (!(it.getValue() == null)) continue;
            entry.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        $this$filter$iv = entry;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        Collection collection = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Module it$iv$iv;
            Map.Entry element$iv$iv$iv;
            Map.Entry element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            Map.Entry it = element$iv$iv;
            boolean bl2 = false;
            VirtualFile root = (VirtualFile)it.getKey();
            if (ModuleUtilCore.findModuleForFile((VirtualFile)root, (Project)project2) == null) continue;
            boolean bl3 = false;
            collection.add(it$iv$iv);
        }
        Set nonLintableModules = CollectionsKt.toSet((Iterable)((List)collection));
        if (!((Collection)nonLintableModules).isEmpty() && (dontContinue = BrakemanExecutionContextUtilKt.executionContextNotFoundNotifications(project2, nonLintableModules))) {
            return;
        }
        BrakemanInspection brakemanInspection = BrakemanInspection.Companion.from(brakemanTool);
        if (brakemanInspection == null) {
            BrakemanGlobalInspectionContext brakemanGlobalInspectionContext = this;
            boolean bl = false;
            BrakemanGlobalInspectionContextKt.access$getLOG$p().warn("Could not find the Brakeman tool");
            return;
        }
        BrakemanInspection brakemanInspection2 = brakemanInspection;
        BrakemanLinter linter = new BrakemanLinter(brakemanInspection2);
        for (Map.Entry entry2 : rootsWithContext.entrySet()) {
            boolean succeeded;
            VirtualFile root = (VirtualFile)entry2.getKey();
            RubyScriptExecutionContext executionContext = (RubyScriptExecutionContext)entry2.getValue();
            if (executionContext == null || (succeeded = this.lintRoot(root, (GlobalInspectionContextImpl)context, linter, executionContext))) continue;
            return;
        }
        this.shouldStop = false;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean lintRoot(VirtualFile root, GlobalInspectionContextImpl context, BrakemanLinter linter, RubyScriptExecutionContext executionContext) {
        void $this$forEach$iv;
        void $this$groupByTo$iv$iv;
        Object[] objectArray;
        VirtualFile workingDir = this.getWorkingDir(context, root);
        BrakemanGlobalInspectionContextKt.access$getLOG$p().debug("Running linter in " + workingDir);
        context.incrementJobDoneAmount(context.getStdJobDescriptors().LOCAL_ANALYSIS_ARRAY[0], workingDir.getPath());
        BrakemanResponse brakemanResponse = linter.execute$intellij_ruby_backend(executionContext, workingDir);
        if (brakemanResponse == null) {
            return false;
        }
        BrakemanResponse response = brakemanResponse;
        List<Error> errors = response.getErrors();
        if (!((Collection)response.getErrors()).isEmpty()) {
            BrakemanGlobalInspectionContextKt.access$getLOG$p().info("Brakeman returned parsing errors");
            Project project = context.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            new BrakemanParserError(errors, project).show();
        }
        if ((objectArray = (Object[])response.getWarnings()).isEmpty()) {
            boolean bl = false;
            BrakemanGlobalInspectionContextKt.access$getLOG$p().debug("No warnings in response");
            return true;
        }
        List warnings = (List)objectArray;
        objectArray = new Object[]{" warnings in response"};
        BrakemanGlobalInspectionContextKt.access$getLOG$p().debug(String.valueOf(warnings.size()), objectArray);
        Object $this$groupBy$iv = warnings;
        boolean $i$f$groupBy = false;
        Object object = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object2;
            Warning it = (Warning)element$iv$iv;
            boolean bl = false;
            String key$iv$iv = it.getFile();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object2 = answer$iv$iv$iv;
            } else {
                object2 = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object2;
            list$iv$iv.add(element$iv$iv);
        }
        $this$groupBy$iv = destination$iv$iv;
        boolean $i$f$forEach = false;
        object = $this$forEach$iv.entrySet().iterator();
        while (object.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = (Map.Entry)object.next();
            boolean bl = false;
            String fileName = (String)entry.getKey();
            List fileWarnings = (List)entry.getValue();
            this.addWarningsToCache(fileName, fileWarnings, workingDir);
        }
        return true;
    }

    private final VirtualFile getWorkingDir(GlobalInspectionContextImpl context, VirtualFile root) {
        VirtualFile workingDir = (VirtualFile)ReadAction.compute(() -> BrakemanGlobalInspectionContext.getWorkingDir$lambda$9(context, root));
        VirtualFile virtualFile = workingDir;
        if (virtualFile == null) {
            virtualFile = root;
        }
        return virtualFile;
    }

    private final void addWarningsToCache(String fileName, List<Warning> warnings, VirtualFile workingDir) {
        VirtualFile virtualFile = workingDir.findFileByRelativePath(fileName);
        if (virtualFile == null) {
            BrakemanGlobalInspectionContext $this$addWarningsToCache_u24lambda_u2410 = this;
            boolean bl = false;
            BrakemanGlobalInspectionContextKt.access$getLOG$p().info("Did not find vFile for " + fileName);
            return;
        }
        VirtualFile vFile = virtualFile;
        String canonicalPath = vFile.getCanonicalPath();
        if (vFile.isDirectory()) {
            BrakemanGlobalInspectionContextKt.access$getLOG$p().warn("Path to directory returned: " + canonicalPath);
            return;
        }
        CharSequence charSequence = canonicalPath;
        if (!(charSequence == null || charSequence.length() == 0)) {
            ((Map)this.filesCache).put(canonicalPath, warnings);
        }
    }

    @Nullable
    public final List<Warning> getWarningsByFile$intellij_ruby_backend(@NotNull VirtualFile vFile) {
        Intrinsics.checkNotNullParameter((Object)vFile, (String)"vFile");
        return (List)((Map)this.filesCache).get(vFile.getCanonicalPath());
    }

    private final Map<VirtualFile, RubyScriptExecutionContext> collectRootsWithContext(GlobalInspectionContextImpl context) {
        Project project = context.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        Map rootsToLint = new LinkedHashMap();
        Map moduleExecutionMap = new LinkedHashMap();
        context.getCurrentScope().accept(arg_0 -> BrakemanGlobalInspectionContext.collectRootsWithContext$lambda$12(arg_0 -> BrakemanGlobalInspectionContext.collectRootsWithContext$lambda$11(project2, moduleExecutionMap, rootsToLint, arg_0), arg_0));
        return rootsToLint;
    }

    public void performPostRunActivities(@NotNull List<InspectionToolWrapper<?, ?>> inspections, @NotNull GlobalInspectionContext context) {
        Intrinsics.checkNotNullParameter(inspections, (String)"inspections");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (this.shouldStop) {
            BrakemanGlobalInspectionContextKt.access$getLOG$p().info("shouldStep is set to true -> cleaning cache before inspection");
            this.cleanup();
        }
    }

    public void cleanup() {
        this.filesCache.clear();
    }

    public final boolean shouldNotRunInspection() {
        return this.filesCache.isEmpty();
    }

    private static final void performPreRunActivities$lambda$1() {
        FileDocumentManager.getInstance().saveAllDocuments();
    }

    private static final VirtualFile getWorkingDir$lambda$9(GlobalInspectionContextImpl $context, VirtualFile $root) {
        return ProjectFileIndex.getInstance((Project)$context.getProject()).getContentRootForFile($root);
    }

    private static final boolean collectRootsWithContext$lambda$11(Project $project, Map $moduleExecutionMap, Map $rootsToLint, VirtualFile virtualFile) {
        Iterator iterator;
        ProgressManager.checkCanceled();
        if (!FileTypeRegistry.getInstance().isFileOfType(virtualFile, (FileType)RubyFileType.RUBY)) {
            return true;
        }
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)virtualFile, (Project)$project);
        if (module == null) {
            return true;
        }
        Module module2 = module;
        RubyScriptExecutionContext rubyScriptExecutionContext = (RubyScriptExecutionContext)$moduleExecutionMap.get(module2);
        if (rubyScriptExecutionContext == null) {
            boolean bl = $moduleExecutionMap.keySet().contains(module2);
            if (bl) {
                return true;
            }
            if (!bl) {
                rubyScriptExecutionContext = BrakemanExecutionContextUtilKt.getExecutionContext(module2);
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        RubyScriptExecutionContext executionContext = rubyScriptExecutionContext;
        $moduleExecutionMap.put(module2, executionContext);
        VirtualFile containingDir = virtualFile.getParent();
        if ($rootsToLint.keySet().contains(containingDir)) {
            return true;
        }
        Iterator iterator2 = iterator = $rootsToLint.entrySet().iterator();
        while (iterator2.hasNext()) {
            VirtualFile root = (VirtualFile)iterator2.next().getKey();
            if (VfsUtilCore.isAncestor((VirtualFile)root, (VirtualFile)containingDir, (boolean)true)) {
                return true;
            }
            if (!VfsUtilCore.isAncestor((VirtualFile)containingDir, (VirtualFile)root, (boolean)true)) continue;
            iterator.remove();
        }
        $rootsToLint.put(containingDir, executionContext);
        return true;
    }

    private static final boolean collectRootsWithContext$lambda$12(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    static {
        Key key = Key.create((String)"BrakemanGlobalInspectionContext");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        ID = key;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/plugins/ruby/brakeman/BrakemanGlobalInspectionContext$Companion;", "", "<init>", "()V", "ID", "Lcom/intellij/openapi/util/Key;", "Lorg/jetbrains/plugins/ruby/brakeman/BrakemanGlobalInspectionContext;", "getID", "()Lcom/intellij/openapi/util/Key;", "intellij.ruby.backend"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Key<BrakemanGlobalInspectionContext> getID() {
            return ID;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

