/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IconProvider;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.indexing.DumbModeAccessType;
import icons.RubyIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.i18n.I18nProvider;
import org.jetbrains.plugins.ruby.rack.RackUtil;
import org.jetbrains.plugins.ruby.rails.RailsIcons;
import org.jetbrains.plugins.ruby.ruby.codeInsight.RubyExceptionUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.v2.LoadPathUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyCallTypesCore;
import org.jetbrains.plugins.ruby.testing.rspec.RSpecUtil;
import org.jetbrains.plugins.ruby.testing.testunit.runConfigurations.TestUnitUtil;

public final class RubyIconProvider
extends IconProvider
implements DumbAware {
    public Icon getIcon(@NotNull PsiElement element, int flags) {
        if (element == null) {
            RubyIconProvider.$$$reportNull$$$0(0);
        }
        if (element instanceof RFile) {
            RFile file = (RFile)element;
            if (RackUtil.isRackConfig((PsiFile)file)) {
                return RubyIcons.Rack.RackFile;
            }
            VirtualFile virtualFile = file.getVirtualFile();
            if (virtualFile != null) {
                if (RSpecUtil.isFileWithRSpecTestFileName(virtualFile)) {
                    return RubyIcons.Rspec.RspecTest;
                }
                if (TestUnitUtil.isFileWithValidTestUnitFileName(virtualFile)) {
                    return RubyIcons.TestUnit.TestUnitFile;
                }
            }
            if (I18nProvider.EXTENSION.forLanguage(element.getLanguage()) != null && I18nProvider.isLocaleFile((PsiFile)file)) {
                return RailsIcons.I18N_PROPERTY_ICON;
            }
        }
        if (element instanceof PsiDirectory && LoadPathUtil.isLoadPathRoot(element)) {
            return AllIcons.Modules.SourceRoot;
        }
        if (RubyCallTypesCore.getDefinedAttributeName((PsiElement)element) != null) {
            return RubyIcons.Ruby.Nodes.Variable;
        }
        if (RubyCallTypesCore.isClassName((PsiElement)element)) {
            return AllIcons.Nodes.Class;
        }
        RClass clazz = (RClass)ObjectUtils.tryCast((Object)element, RClass.class);
        return (Icon)DumbModeAccessType.RELIABLE_DATA_ONLY.ignoreDumbMode(() -> {
            if (clazz != null && RubyExceptionUtil.isExceptionClass(clazz)) {
                return AllIcons.Nodes.ExceptionClass;
            }
            return null;
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/ruby/RubyIconProvider", "getIcon"));
    }
}

