/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.sshAgentProxy;

import com.intellij.community.wintools.ErrorToolsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.codeWithMe.model.SshRequesterProcessInfo;
import com.jetbrains.rdserver.actions.ActionTimestamp;
import com.jetbrains.rdserver.portForwarding.utils.ProcessInfoUtil;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpc;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpcService;
import com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.win32.W32APIOptions;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 '2\u00020\u0001:\u0005&'()*B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\b\u0010#\u001a\u00020\u0012H\u0002J\b\u0010$\u001a\u00020\u0012H\u0016J\b\u0010%\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006+"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc;", "pipePath", "", "WindowsNamedPipeAgentIpc", "(Ljava/lang/String;)V", "key", "getKey", "()Ljava/lang/String;", "hPipe", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lock", "", "connectionThread", "Ljava/lang/Thread;", "state", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "assertConnectionThread", "", "open", "isOpen", "", "()Z", "accept", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc$Streams;", "getRequesterPid", "", "isSshProcess", "process", "Lcom/jetbrains/rdserver/portForwarding/utils/ProcessInfoUtil$ProcessInfo;", "requestorProcessValue", "Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "requesterProcessInfo", "getRequesterProcessInfo", "()Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "disconnect", "close", "cleanup", "NamedPipeState", "Companion", "Kernel32Ex", "PipeReadableByteChannel", "PipeWritableByteChannel", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n1#2:392\n24#3:393\n24#3:394\n24#3:395\n24#3:396\n24#3:397\n24#3:398\n24#3:399\n24#3:400\n24#3:401\n24#3:402\n24#3:403\n24#3:404\n24#3:405\n24#3:406\n24#3:407\n24#3:408\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n*L\n131#1:393\n142#1:394\n151#1:395\n161#1:396\n179#1:397\n203#1:398\n208#1:399\n228#1:400\n236#1:401\n238#1:402\n249#1:403\n264#1:404\n274#1:405\n284#1:406\n288#1:407\n290#1:408\n*E\n"})
public final class WindowsNamedPipeAgentIpc
extends SshAgentIpc {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String pipePath;
    @NotNull
    private final String key;
    @NotNull
    private WinNT.HANDLE hPipe;
    @NotNull
    private final Object lock;
    @Nullable
    private Thread connectionThread;
    @NotNull
    private NamedPipeState state;
    @NotNull
    private SshRequesterProcessInfo requestorProcessValue;
    private static final String[] c;
    private static final String[] d;

    public WindowsNamedPipeAgentIpc(@NotNull String pipePath) {
        long l2 = 97143218669127L;
        Intrinsics.checkNotNullParameter((Object)pipePath, (String)WindowsNamedPipeAgentIpc.b(-351660810 - -30510, -351660810 - -((char)-13709), (int)l2));
        this.key = this.pipePath = pipePath;
        WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(-351660810 - -30511, -351660810 - -((char)-27793), (int)l2));
        this.hPipe = hANDLE;
        this.lock = new Object();
        this.state = NamedPipeState.Initial;
        this.requestorProcessValue = SshAgentIpc.Companion.getMissingProcessInfo();
    }

    @Override
    @NotNull
    public String getKey() {
        return this.key;
    }

    private final void assertConnectionThread() {
        block3: {
            boolean bl;
            Thread thread;
            long l2;
            block2: {
                l2 = 8105758299046L;
                thread = Thread.currentThread();
                String string = SshAgentIpcService.C();
                try {
                    bl = Intrinsics.areEqual((Object)thread, (Object)this.connectionThread);
                    if (string != null) break block2;
                    if (bl) break block3;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                bl = false;
            }
            boolean bl2 = bl;
            Thread thread2 = thread;
            Thread thread3 = this.connectionThread;
            String string = this.pipePath;
            String string2 = WindowsNamedPipeAgentIpc.b(1154988840 + 24223, -1154988840 + -21612, (int)l2) + string + WindowsNamedPipeAgentIpc.b(1154988840 + 24222, -1154988840 + -25513, (int)l2) + thread3 + WindowsNamedPipeAgentIpc.b(1154988840 + 24217, -1154988840 + -((char)-29887), (int)l2) + thread2;
            throw new IllegalArgumentException(string2.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() {
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        long l2;
        block14: {
            block15: {
                l2 = 85090901433102L;
                Object object = this.lock;
                String string = SshAgentIpcService.C();
                synchronized (object) {
                    boolean bl;
                    boolean bl2 = false;
                    try {
                        bl = this.connectionThread == null;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl3 = false;
                        String string2 = WindowsNamedPipeAgentIpc.b(-990627060 + -10660, -990627060 - -10542, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-990627060 + -10657, -990627060 + -6759, (int)l2) + this.state;
                        throw new IllegalArgumentException(string2.toString());
                    }
                    this.connectionThread = Thread.currentThread();
                    Unit unit = Unit.INSTANCE;
                }
                try {
                    try {
                        WinNT.HANDLE hANDLE = Kernel32.INSTANCE.CreateNamedPipe(this.pipePath, 3, 0, 1, 16384, 16384, 0, null);
                        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(-990627060 + -10658, 990627060 + 344, (int)l2));
                        this.hPipe = hANDLE;
                        windowsNamedPipeAgentIpc = this;
                        if (string != null) break block14;
                        if (Intrinsics.areEqual((Object)windowsNamedPipeAgentIpc.hPipe, (Object)WinNT.INVALID_HANDLE_VALUE)) {
                        }
                        break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    throw new RuntimeException(WindowsNamedPipeAgentIpc.b(-990627060 + -10663, -990627060 + -13738, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-990627060 + -10664, -990627060 + -3398, (int)l2) + ErrorToolsKt.kernel32LastError());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            this.state = NamedPipeState.Open;
            windowsNamedPipeAgentIpc = this;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = windowsNamedPipeAgentIpc;
        boolean bl = false;
        try {
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-990627060 + -10661, -990627060 - -3091, (int)l2));
            logger.info(WindowsNamedPipeAgentIpc.b(-990627060 + -10663, -990627060 + -13738, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-990627060 + -10662, -990627060 + -11865, (int)l2));
            if (ActionTimestamp.C() != null) {
                SshAgentIpcService.C("ikwfg");
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
    }

    @Override
    public boolean isOpen() {
        int n2;
        block8: {
            block7: {
                String string;
                block6: {
                    long l2 = 47814666208527L;
                    string = SshAgentIpcService.C();
                    try {
                        try {
                            n2 = this.state.compareTo((Enum)NamedPipeState.Open);
                            if (string != null) break block6;
                            if (n2 < 0) break block7;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = this.state.compareTo((Enum)NamedPipeState.Disconnecting);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                try {
                    if (string != null) break block8;
                    if (n2 > 0) break block7;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                n2 = 1;
                break block8;
            }
            n2 = 0;
        }
        return n2 != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    @NotNull
    public SshAgentIpc.Streams accept() {
        SshAgentIpc.Streams streams;
        Object object;
        Object object2;
        String string;
        long l2;
        block27: {
            block28: {
                l2 = 43033406409858L;
                this.assertConnectionThread();
                Object object3 = this.lock;
                string = SshAgentIpcService.C();
                synchronized (object3) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block25: {
                        block26: {
                            boolean bl2 = false;
                            try {
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Closing;
                                if (string != null) break block25;
                                if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block26;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(2129101080 - 31275, -2129101080 - -32387, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(2129101080 - 31279, 2129101080 - 28202, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(2129101080 - 31276, -2129101080 - -31278, (int)l2) + this.state);
                            throw new ClosedChannelException();
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Open;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string2 = WindowsNamedPipeAgentIpc.b(2129101080 - 31279, 2129101080 - 28202, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(2129101080 - 31273, -2129101080 - -22843, (int)l2) + this.state;
                        throw new IllegalArgumentException(string2.toString());
                    }
                    this.state = NamedPipeState.Connecting;
                    Unit unit = Unit.INSTANCE;
                }
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(2129101080 - 31275, -2129101080 - -32387, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(2129101080 - 31279, 2129101080 - 28202, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(2129101080 - 31274, -2129101080 - -24637, (int)l2));
                    object2 = Kernel32.INSTANCE;
                    if (string != null) break block27;
                    if (object2.ConnectNamedPipe(this.hPipe, null)) break block28;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                int n2 = Kernel32.INSTANCE.GetLastError();
                if (n2 == 535) {
                    WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                    boolean bl5 = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(2129101080 - 31275, -2129101080 - -32387, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(2129101080 - 31279, 2129101080 - 28202, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(2129101080 - 31271, 2129101080 - 29342, (int)l2));
                } else {
                    throw new IllegalStateException((WindowsNamedPipeAgentIpc.b(2129101080 - 31279, 2129101080 - 28202, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(2129101080 - 31272, -2129101080 - -27426, (int)l2) + ErrorToolsKt.prettyHRESULT(n2)).toString());
                }
            }
            object2 = this.lock;
        }
        Kernel32 kernel32 = object2;
        synchronized (kernel32) {
            boolean bl;
            NamedPipeState namedPipeState;
            NamedPipeState namedPipeState3;
            block29: {
                block30: {
                    boolean bl6 = false;
                    namedPipeState3 = this.state;
                    namedPipeState = NamedPipeState.Closing;
                    if (string != null) break block29;
                    try {
                        block31: {
                            if (namedPipeState3.compareTo((Enum)namedPipeState) < 0) break block30;
                            break block31;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                namedPipeState3 = this.state;
                namedPipeState = NamedPipeState.Connecting;
            }
            try {
                bl = namedPipeState3 == namedPipeState;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
            }
            if (!bl) {
                boolean bl7 = false;
                String string3 = WindowsNamedPipeAgentIpc.b(2129101080 - 31279, 2129101080 - 28202, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(2129101080 - 31273, -2129101080 - -22843, (int)l2) + this.state;
                throw new IllegalArgumentException(string3.toString());
            }
            this.state = NamedPipeState.Connected;
            object = Unit.INSTANCE;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(2129101080 - 31275, -2129101080 - -32387, (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(2129101080 - 31279, 2129101080 - 28202, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(2129101080 - 31269, -2129101080 - -27390, (int)l2));
        long l3 = this.getRequesterPid();
        this.requestorProcessValue = this.calcRequesterProcessInfo(l3);
        object = new PipeReadableByteChannel(this);
        PipeWritableByteChannel pipeWritableByteChannel = new PipeWritableByteChannel(this);
        try {
            streams = new SshAgentIpc.Streams((PipeReadableByteChannel)object, pipeWritableByteChannel, this){
                final /* synthetic */ PipeReadableByteChannel $read;
                final /* synthetic */ PipeWritableByteChannel $write;
                final /* synthetic */ WindowsNamedPipeAgentIpc this$0;
                private static final String[] a;
                private static final String[] b;
                {
                    this.$read = $read;
                    this.$write = $write;
                    this.this$0 = $receiver;
                }

                public InputStream getInputStream() {
                    long l2 = 81604621189804L;
                    InputStream inputStream = Channels.newInputStream(this.$read);
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)accept.3.a(242610570 - (char)-24108, -242610570 - -((char)-15967), (int)l2));
                    return inputStream;
                }

                public OutputStream getOutputStream() {
                    long l2 = 23153072623968L;
                    OutputStream outputStream = Channels.newOutputStream(this.$write);
                    Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)accept.3.a(-1096007340 + -((char)-6951), 1096138410 - (char)-8458, (int)l2));
                    return outputStream;
                }

                public void close() {
                    WindowsNamedPipeAgentIpc.access$disconnect(this.this$0);
                }

                /*
                 * Unable to fully structure code
                 */
                static {
                    block13: {
                        var5 = new String[2];
                        var3_1 = 0;
                        var2_2 = "]=\u0086\u00ad\u00905\u00b6\u00cb\u0002\u000e\u0081\u00e9\u00fd\u00eb\u00bd\u00cfM\u00b6\u00dc\u00145\u00ea\u008bQ*h\u009c\u00e5\u00c5\u00cd\u00bcE\u0098\u0087\u00d0\u00c9\r\u00b0\u00d3D";
                        var4_3 = "]=\u0086\u00ad\u00905\u00b6\u00cb\u0002\u000e\u0081\u00e9\u00fd\u00eb\u00bd\u00cfM\u00b6\u00dc\u00145\u00ea\u008bQ*h\u009c\u00e5\u00c5\u00cd\u00bcE\u0098\u0087\u00d0\u00c9\r\u00b0\u00d3D".length();
                        var1_4 = 19;
                        var0_5 = -1;
lbl7:
                        // 2 sources

                        while (true) {
                            continue;
                            break;
                        }
lbl9:
                        // 1 sources

                        while (true) {
                            var5[var3_1++] = new String(v0).intern();
                            if ((var0_5 += var1_4) < var4_3) {
                                var1_4 = var2_2.charAt(var0_5);
                                ** continue;
                            }
                            break block13;
                            break;
                        }
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                        v3 = v2.length;
                        var6_6 = 0;
                        v4 = 43;
                        v5 = v2;
                        v6 = v3;
                        if (v3 > 1) ** GOTO lbl67
                        do {
                            v7 = v4;
                            v5 = v5;
                            v8 = v5;
                            v9 = v4;
                            v10 = var6_6;
                            while (true) {
                                switch (var6_6 % 7) {
                                    case 0: {
                                        v11 = 79;
                                        break;
                                    }
                                    case 1: {
                                        v11 = 93;
                                        break;
                                    }
                                    case 2: {
                                        v11 = 94;
                                        break;
                                    }
                                    case 3: {
                                        v11 = 111;
                                        break;
                                    }
                                    case 4: {
                                        v11 = 50;
                                        break;
                                    }
                                    case 5: {
                                        v11 = 51;
                                        break;
                                    }
                                    default: {
                                        v11 = 122;
                                    }
                                }
                                v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                                ++var6_6;
                                v4 = v7;
                                if (v7 != 0) break;
                                v7 = v4;
                                v5 = v5;
                                v10 = v4;
                                v8 = v5;
                                v9 = v4;
                            }
lbl67:
                            // 2 sources

                            v0 = v5;
                            v6 = v6;
                        } while (v6 > var6_6);
                        ** while (true)
                    }
                    accept.3.a = var5;
                    accept.3.b = new String[2];
                }

                private static String a(int n2, int n3, int n4) {
                    int n5 = (n2 ^ n4 ^ 0xD1A) & 0xFFFF;
                    if (b[n5] == null) {
                        int n6;
                        char[] cArray = a[n5].toCharArray();
                        int n7 = switch (cArray[0] & 0xFF) {
                            case 0 -> 11;
                            case 1 -> 246;
                            case 2 -> 115;
                            case 3 -> 95;
                            case 4 -> 56;
                            case 5 -> 54;
                            case 6 -> 88;
                            case 7 -> 252;
                            case 8 -> 172;
                            case 9 -> 72;
                            case 10 -> 185;
                            case 11 -> 29;
                            case 12 -> 183;
                            case 13 -> 75;
                            case 14 -> 165;
                            case 15 -> 21;
                            case 16 -> 61;
                            case 17 -> 224;
                            case 18 -> 253;
                            case 19 -> 215;
                            case 20 -> 158;
                            case 21 -> 94;
                            case 22 -> 255;
                            case 23 -> 32;
                            case 24 -> 19;
                            case 25 -> 89;
                            case 26 -> 68;
                            case 27 -> 5;
                            case 28 -> 48;
                            case 29 -> 196;
                            case 30 -> 104;
                            case 31 -> 134;
                            case 32 -> 237;
                            case 33 -> 170;
                            case 34 -> 173;
                            case 35 -> 12;
                            case 36 -> 202;
                            case 37 -> 182;
                            case 38 -> 148;
                            case 39 -> 197;
                            case 40 -> 111;
                            case 41 -> 10;
                            case 42 -> 138;
                            case 43 -> 204;
                            case 44 -> 110;
                            case 45 -> 200;
                            case 46 -> 244;
                            case 47 -> 194;
                            case 48 -> 112;
                            case 49 -> 18;
                            case 50 -> 155;
                            case 51 -> 229;
                            case 52 -> 102;
                            case 53 -> 186;
                            case 54 -> 156;
                            case 55 -> 205;
                            case 56 -> 41;
                            case 57 -> 100;
                            case 58 -> 203;
                            case 59 -> 159;
                            case 60 -> 101;
                            case 61 -> 238;
                            case 62 -> 55;
                            case 63 -> 15;
                            case 64 -> 175;
                            case 65 -> 161;
                            case 66 -> 45;
                            case 67 -> 218;
                            case 68 -> 248;
                            case 69 -> 117;
                            case 70 -> 187;
                            case 71 -> 93;
                            case 72 -> 90;
                            case 73 -> 160;
                            case 74 -> 80;
                            case 75 -> 16;
                            case 76 -> 51;
                            case 77 -> 211;
                            case 78 -> 193;
                            case 79 -> 216;
                            case 80 -> 105;
                            case 81 -> 149;
                            case 82 -> 120;
                            case 83 -> 206;
                            case 84 -> 43;
                            case 85 -> 78;
                            case 86 -> 121;
                            case 87 -> 192;
                            case 88 -> 132;
                            case 89 -> 141;
                            case 90 -> 108;
                            case 91 -> 188;
                            case 92 -> 150;
                            case 93 -> 201;
                            case 94 -> 124;
                            case 95 -> 236;
                            case 96 -> 106;
                            case 97 -> 58;
                            case 98 -> 151;
                            case 99 -> 63;
                            case 100 -> 232;
                            case 101 -> 167;
                            case 102 -> 250;
                            case 103 -> 59;
                            case 104 -> 249;
                            case 105 -> 223;
                            case 106 -> 209;
                            case 107 -> 207;
                            case 108 -> 85;
                            case 109 -> 210;
                            case 110 -> 1;
                            case 111 -> 96;
                            case 112 -> 231;
                            case 113 -> 199;
                            case 114 -> 23;
                            case 115 -> 146;
                            case 116 -> 87;
                            case 117 -> 154;
                            case 118 -> 181;
                            case 119 -> 9;
                            case 120 -> 57;
                            case 121 -> 49;
                            case 122 -> 92;
                            case 123 -> 140;
                            case 124 -> 71;
                            case 125 -> 82;
                            case 126 -> 195;
                            case 127 -> 33;
                            case 128 -> 107;
                            case 129 -> 66;
                            case 130 -> 157;
                            case 131 -> 241;
                            case 132 -> 168;
                            case 133 -> 169;
                            case 134 -> 178;
                            case 135 -> 2;
                            case 136 -> 129;
                            case 137 -> 189;
                            case 138 -> 247;
                            case 139 -> 0;
                            case 140 -> 98;
                            case 141 -> 64;
                            case 142 -> 136;
                            case 143 -> 65;
                            case 144 -> 184;
                            case 145 -> 77;
                            case 146 -> 25;
                            case 147 -> 39;
                            case 148 -> 84;
                            case 149 -> 62;
                            case 150 -> 251;
                            case 151 -> 30;
                            case 152 -> 176;
                            case 153 -> 114;
                            case 154 -> 213;
                            case 155 -> 47;
                            case 156 -> 177;
                            case 157 -> 228;
                            case 158 -> 24;
                            case 159 -> 221;
                            case 160 -> 22;
                            case 161 -> 76;
                            case 162 -> 171;
                            case 163 -> 240;
                            case 164 -> 113;
                            case 165 -> 166;
                            case 166 -> 217;
                            case 167 -> 119;
                            case 168 -> 242;
                            case 169 -> 69;
                            case 170 -> 8;
                            case 171 -> 133;
                            case 172 -> 179;
                            case 173 -> 190;
                            case 174 -> 14;
                            case 175 -> 116;
                            case 176 -> 220;
                            case 177 -> 35;
                            case 178 -> 243;
                            case 179 -> 20;
                            case 180 -> 174;
                            case 181 -> 128;
                            case 182 -> 254;
                            case 183 -> 214;
                            case 184 -> 147;
                            case 185 -> 6;
                            case 186 -> 198;
                            case 187 -> 191;
                            case 188 -> 27;
                            case 189 -> 152;
                            case 190 -> 60;
                            case 191 -> 122;
                            case 192 -> 123;
                            case 193 -> 28;
                            case 194 -> 3;
                            case 195 -> 180;
                            case 196 -> 13;
                            case 197 -> 86;
                            case 198 -> 139;
                            case 199 -> 31;
                            case 200 -> 222;
                            case 201 -> 7;
                            case 202 -> 34;
                            case 203 -> 153;
                            case 204 -> 145;
                            case 205 -> 83;
                            case 206 -> 137;
                            case 207 -> 4;
                            case 208 -> 99;
                            case 209 -> 142;
                            case 210 -> 226;
                            case 211 -> 109;
                            case 212 -> 70;
                            case 213 -> 125;
                            case 214 -> 135;
                            case 215 -> 234;
                            case 216 -> 163;
                            case 217 -> 73;
                            case 218 -> 162;
                            case 219 -> 219;
                            case 220 -> 131;
                            case 221 -> 81;
                            case 222 -> 227;
                            case 223 -> 53;
                            case 224 -> 79;
                            case 225 -> 235;
                            case 226 -> 67;
                            case 227 -> 50;
                            case 228 -> 36;
                            case 229 -> 225;
                            case 230 -> 40;
                            case 231 -> 230;
                            case 232 -> 245;
                            case 233 -> 46;
                            case 234 -> 17;
                            case 235 -> 26;
                            case 236 -> 44;
                            case 237 -> 127;
                            case 238 -> 164;
                            case 239 -> 126;
                            case 240 -> 118;
                            case 241 -> 239;
                            case 242 -> 233;
                            case 243 -> 97;
                            case 244 -> 52;
                            case 245 -> 130;
                            case 246 -> 38;
                            case 247 -> 103;
                            case 248 -> 144;
                            case 249 -> 37;
                            case 250 -> 74;
                            case 251 -> 143;
                            case 252 -> 42;
                            case 253 -> 212;
                            case 254 -> 208;
                            default -> 91;
                        };
                        int n8 = ((n3 ^= n4) & 0xFF) - n7;
                        if (n8 < 0) {
                            n8 += 256;
                        }
                        if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                            n6 += 256;
                        }
                        int n9 = 0;
                        while (n9 < cArray.length) {
                            int n10 = n9 % 2;
                            int n11 = n9;
                            char[] cArray2 = cArray;
                            char c2 = cArray[n11];
                            if (n10 == 0) {
                                cArray2[n11] = (char)(c2 ^ n8);
                                n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                            } else {
                                cArray2[n11] = (char)(c2 ^ n6);
                                n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                            }
                            ++n9;
                        }
                        accept.3.b[n5] = new String(cArray).intern();
                    }
                    return b[n5];
                }
            };
            if (string != null) {
                ActionTimestamp.C("z32ubb");
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
        return streams;
    }

    public final long getRequesterPid() {
        long l2;
        block4: {
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            int n2;
            long l3;
            block2: {
                block3: {
                    l3 = 9097634146914L;
                    WinDef.ULONGByReference uLONGByReference = new WinDef.ULONGByReference();
                    String string = SshAgentIpcService.C();
                    try {
                        n2 = Kernel32.INSTANCE.GetNamedPipeClientProcessId(this.hPipe, uLONGByReference);
                        if (string != null) break block2;
                        if (n2 == 0) break block3;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    WinDef.ULONG uLONG = uLONGByReference.getValue();
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(893373120 + (char)-27315, -893373120 + -((char)-26187), (int)l3));
                    logger.info(WindowsNamedPipeAgentIpc.b(893373120 + (char)-27319, 893373120 + (char)-22194, (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(893373120 + (char)-27310, 893373120 + (char)-32762, (int)l3) + uLONG);
                    l2 = uLONGByReference.getValue().longValue();
                    break block4;
                }
                n2 = Kernel32.INSTANCE.GetLastError();
            }
            int n3 = n2;
            windowsNamedPipeAgentIpc = this;
            bl = false;
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(893373120 + (char)-27315, -893373120 + -((char)-26187), (int)l3));
            logger.warn(WindowsNamedPipeAgentIpc.b(893373120 + (char)-27319, 893373120 + (char)-22194, (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(893373120 + (char)-27307, 893373120 + (char)-31810, (int)l3) + ErrorToolsKt.prettyHRESULT(n3));
            l2 = -1L;
        }
        long l4 = l2;
        return l4;
    }

    @Override
    protected boolean isSshProcess(@NotNull ProcessInfoUtil.ProcessInfo process2) {
        boolean bl;
        block14: {
            block12: {
                block15: {
                    String string;
                    Object object;
                    String string2;
                    block13: {
                        long l2 = 109421916992707L;
                        String string3 = SshAgentIpcService.C();
                        Intrinsics.checkNotNullParameter((Object)process2, (String)WindowsNamedPipeAgentIpc.b(-964806270 - -1331, 964806270 + 1844, (int)l2));
                        string2 = string3;
                        try {
                            try {
                                try {
                                    try {
                                        if (string2 != null || (object = process2.getExecutable()) == null) break block12;
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                    if ((object = object.getFileName()) == null) break block12;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                String string4 = object.toString();
                                string = string4;
                                object = string4;
                                if (string2 != null) break block13;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            if (string == null) break block12;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        string = WindowsNamedPipeAgentIpc.b(-964806270 - -1332, -964806270 - -8365, (int)l2);
                    }
                    try {
                        try {
                            bl = StringsKt.equals((String)object, (String)string, (boolean)true);
                            if (string2 != null) break block14;
                            if (!bl) break block15;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        bl = true;
                        break block14;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                bl = false;
                break block14;
            }
            bl = false;
        }
        return bl;
    }

    @Override
    @NotNull
    public SshRequesterProcessInfo getRequesterProcessInfo() {
        return this.requestorProcessValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private final void disconnect() {
        Object object;
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        String string;
        long l2;
        block25: {
            block26: {
                l2 = 30117921846075L;
                this.assertConnectionThread();
                Object object2 = this.lock;
                synchronized (object2) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block23: {
                        block24: {
                            block21: {
                                block22: {
                                    string = SshAgentIpcService.C();
                                    boolean bl2 = false;
                                    namedPipeState2 = this.state;
                                    namedPipeState = NamedPipeState.Closing;
                                    if (string != null) break block21;
                                    try {
                                        block29: {
                                            if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block22;
                                            break block29;
                                            catch (IllegalArgumentException illegalArgumentException) {
                                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                            }
                                        }
                                        throw new ClosedChannelException();
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                }
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Open;
                            }
                            try {
                                if (string != null) break block23;
                                if (namedPipeState2 != namedPipeState) break block24;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1611112440 + (char)-9892, -1611112440 + -((char)-8906), (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(1611112440 + (char)-9896, 1611112440 + (char)-12961, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1611112440 + (char)-9897, -1611112440 + -((char)-8452), (int)l2));
                            return;
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Connected;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string2 = WindowsNamedPipeAgentIpc.b(1611112440 + (char)-9896, 1611112440 + (char)-12961, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1611112440 + (char)-9890, -1611112440 + -((char)-18322), (int)l2) + this.state;
                        throw new IllegalArgumentException(string2.toString());
                    }
                    this.state = NamedPipeState.Disconnecting;
                    Unit unit = Unit.INSTANCE;
                }
                windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1611112440 + (char)-9892, -1611112440 + -((char)-8906), (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(1611112440 + (char)-9896, 1611112440 + (char)-12961, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1611112440 + (char)-9912, -1611112440 + -((char)-30960), (int)l2));
                    object = Kernel32.INSTANCE;
                    if (string != null) break block25;
                    if (object.DisconnectNamedPipe(this.hPipe)) break block26;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1611112440 + (char)-9892, -1611112440 + -((char)-8906), (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(1611112440 + (char)-9896, 1611112440 + (char)-12961, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1611112440 + (char)-9911, 1611112440 + 28273, (int)l2) + ErrorToolsKt.kernel32LastError());
                return;
            }
            object = this.lock;
        }
        Kernel32 kernel32 = object;
        synchronized (kernel32) {
            block27: {
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3;
                block28: {
                    boolean bl = false;
                    windowsNamedPipeAgentIpc3 = this;
                    if (string != null) break block27;
                    try {
                        block30: {
                            if (windowsNamedPipeAgentIpc3.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block28;
                            break block30;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                windowsNamedPipeAgentIpc3 = this;
            }
            windowsNamedPipeAgentIpc3.state = NamedPipeState.Open;
            Unit unit = Unit.INSTANCE;
        }
        windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1611112440 + (char)-9892, -1611112440 + -((char)-8906), (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(1611112440 + (char)-9896, 1611112440 + (char)-12961, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1611112440 + (char)-9910, 1611112440 + (char)-8185, (int)l2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        block17: {
            int n2;
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            long l2;
            block15: {
                String string;
                block16: {
                    l2 = 125907170115072L;
                    Object object = this.lock;
                    synchronized (object) {
                        block13: {
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2;
                            block14: {
                                string = SshAgentIpcService.C();
                                boolean bl2 = false;
                                try {
                                    windowsNamedPipeAgentIpc2 = this;
                                    if (string != null) break block13;
                                    if (windowsNamedPipeAgentIpc2.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block14;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3 = this;
                                boolean bl3 = false;
                                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(203813850 + 16533, -203813850 + -15421, (int)l2));
                                logger.info(WindowsNamedPipeAgentIpc.b(203813850 + 16529, 203813850 + 11410, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(203813850 + 16542, -203813850 + -18954, (int)l2) + this.state + WindowsNamedPipeAgentIpc.b(203813850 + 16549, 203813850 + 24700, (int)l2));
                                return;
                            }
                            windowsNamedPipeAgentIpc2 = this;
                        }
                        windowsNamedPipeAgentIpc2.state = NamedPipeState.Closing;
                        Unit unit = Unit.INSTANCE;
                    }
                    WindowsNamedPipeAgentIpc.Companion.connectToPipe(this.pipePath);
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    try {
                        try {
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(203813850 + 16533, -203813850 + -15421, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(203813850 + 16529, 203813850 + 11410, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(203813850 + 16548, -203813850 + -((char)-30674), (int)l2));
                            n2 = Kernel32Ex.Companion.getINSTANCE().CancelIoEx(this.hPipe, null);
                            if (string != null) break block15;
                            if (n2 != 0) break block16;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = Kernel32.INSTANCE.GetLastError();
                        if (string != null) break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    int n3 = n2;
                    if (n3 != 1168) {
                        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc4 = this;
                        boolean bl4 = false;
                        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(203813850 + 16533, -203813850 + -15421, (int)l2));
                        logger.info(WindowsNamedPipeAgentIpc.b(203813850 + 16529, 203813850 + 11410, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(203813850 + 16547, 203813850 + 15197, (int)l2) + ErrorToolsKt.prettyHRESULT(n3));
                    }
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(203813850 + 16533, -203813850 + -15421, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(203813850 + 16529, 203813850 + 11410, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(203813850 + 16546, 203813850 + 8262, (int)l2));
                    if (string != null) break block17;
                    n2 = Kernel32.INSTANCE.CloseHandle(this.hPipe) ? 1 : 0;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            if (n2 == 0) {
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(203813850 + 16533, -203813850 + -15421, (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(203813850 + 16529, 203813850 + 11410, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(203813850 + 16489, 203813850 + 9293, (int)l2) + ErrorToolsKt.kernel32LastError());
            }
            WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
            Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(203813850 + 16488, -203813850 + -23390, (int)l2));
            this.hPipe = hANDLE;
            this.state = NamedPipeState.Closed;
        }
    }

    @Override
    public void cleanup() {
    }

    public static final /* synthetic */ String access$getPipePath$p(WindowsNamedPipeAgentIpc $this) {
        return $this.pipePath;
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[34];
                var3_1 = 0;
                var2_2 = "\u00f1\u00c2Q\u00c3)g\u00cf\u00f9\u0014\u00f6\u0090\u0089n\u00ccZ\u00dcD\\\u001c>\u0083\u00bb=\u00dd_/\u0081\u00f4\u0007\u00064\u007f\u00e9tT\u00d0\u00183hQAUz\u00ed\u0080\u00b2\u00f9\u00ecO\u0087[\b\u0011<!\u00b8\u008en\u008b\u0010\u00e4\t\u00cb;\u00d0\u009a\u000e\u009e\u009eT\u00e0\u0005}f\u00c0Wk\bz\u00a5 ^U\u00f2F\u00a9\u0014I\u00b0\u0006\u00f1P\u00a1z\u00ac\u00e6\u00dc\u00c2/n\u000b\u00dct\u001d7K\u0093\u0005\u001c.\u00ec^\u00ee\u001e\u0001\u00c0Z\u00e7\u00a5jQ\u00f8\u0080\u00e2\u00e1\u00abj\u00e7\u0017\u00e2>\u00ce*\u0087\u0090\u0085\u00c3\u00e8\u009a\u00b8{\u0080\u0011\u00ec\u0010)\u00ab\u00bbO\u00ceM\u00ca\u00e5\u008e\u00f3\u00adt\u00e5II\u00a8\te\u00d0\u00d3\u00f6=4\u00de\u009e\u0006\u0010\u00b0\u00df\u0088\u00c1\u00a8\u009c\u0006\u00df\u0017\u00b4\u009e\u009c\u0083T\u0085\u000b?\u00ffq\u008d\u00d1R\u00a5*m\u009e\u0081g<\u0005\u00e3\u00c7[\u00e1\u009c\u00ac\b\u00ce&s\u00fa\u009c\u0012\u00b6a\u009f\u0086\u0015<-o)\u00bd\u00f4=W\u00a9\u00d2Z\u00a0M\u00140cf\ngE\u00a3x&\u0005PJ\u00d1x\u00fc\u00ac\u0000\u0096\b+s\n\u0084\u0010\u00a9\u00ee\u00c2\f\u00e1\u00a2C\u00a5$\u00ef\u0086\r.\u00a6\u00eb\u00daF\u008f\u00f6\u008e/\u009d\u00be\u00b1'\u00c8\u00ef=7\u00d8\u008acP\u0089\u009a\u00a1g}\u0099\u0006?\u0004\u0081V\u0018<\u0080[\u00c0\u00d8FU\u00b9\u00a1\u00f0V\u00d4a\u00e0]\u00e1u \u001b\u0019\u00e2p>\u00eb\u00f8\u00b9\u0003\u00b8\u0015\u00b8\u0005m0[Y\u00b1@\u00f3+\u00d2\u00f8\u00bf\u001f\u00ba\u00b7-\tK\u00b7\u008cC;\u0095\u0096E\u0084'\u00c1K\u009f\u0013c\u00f6r+H\u0096\u008a\u00a7n\u00af\u00ae\u00f8\u000b\u000b\u009bu\f_\u00cd\u00b0\u00bb\u00e6\u0089\u00d7\u0015\u0015\u008df\u00ce>\u0092\u00f4\u00bc\u0013W\u0089\u0006\r(\u0082I\u00a9u\u00db\u00e3\u0096T)j\u001d7\\\b\u001d\u00e4\u00166?7\u0010\u00b4\u0087YZ\u00d3\u00b91\u0004\u00c8\r\u00d9J\u00d7u\u0012\u008d\u000eH\u009d\u00e7\u00fe\u0007\u00f7\u001c\u00ebY\u0094H\u009a\u00076\u00f9\u00b6\u00da\u001c\u0090\u00fd\u0007B\u00b1\\\u00bf\u00a6\u00d3\u00bc(/\u00c8\u00d3\u00c7$\u0004\u0097\u0012(h\u00de\u00cc\u00aa\u009d\u00d8\u009a\u00e4\fy\u00f1\u00a0\u008d\u00bb\u0091\u000b\u00b2?\u000e\u009cX\u0014\u00fc4\u000f0\u00b0\u00a9\u00b1O\u00a6\u000f\u008c\u00db\u00e9\u008c\u008b\u0001\u00c7qW\u0089\u0090\u00a1\u00c3dk\"L\u00d6\u00f3%\u00902\u00f7\u00f3T\u0083{\u0087>ylK\u009e\u00b2\u0012'Fi\u00a8\u0096j\u00bah\u00aae\u009eR:)O\u000e'\u0000\u009c\u00f7%n\u0012\u009c\u00ed4\u00c7\u0016%\u0098\u001bje2^\u000b\u00eeB\u00d0\u00b0:\u00e1\u00d6\u00b1\u00b6\u00bb\u00a4\u00cc\u00e5\u00e5Q\u0083\u0093coX\u00e8{\nT91\u00d2\u007f\u009b\u001fT\u00b0\u00c8\u0018\u008f=\u008eX\u009d\u0092\u00b1\u0001\u00d0\u00c9/7\u00d1\u00d9Kh\u00a5}\u001f;\u00a4\u0095\u00dc\u00fc)\u0013B\u0018\u00b7\u00ed`X\u00b9\u00a1\u00ca\u00c5\u00ae\u00eeY\u008d\u00fa7\u00d8r\u00ed\u009a \u00da\u00e3\u00c2\u00d2-\u0095\u00ba\u0017\u00b0\u009d~\u00962\u00ba\u008d\u00a9XV\u0003\t\u00fb\u00aa\u0000\u00a7M\u00d1\u0086y\u00b0";
                var4_3 = "\u00f1\u00c2Q\u00c3)g\u00cf\u00f9\u0014\u00f6\u0090\u0089n\u00ccZ\u00dcD\\\u001c>\u0083\u00bb=\u00dd_/\u0081\u00f4\u0007\u00064\u007f\u00e9tT\u00d0\u00183hQAUz\u00ed\u0080\u00b2\u00f9\u00ecO\u0087[\b\u0011<!\u00b8\u008en\u008b\u0010\u00e4\t\u00cb;\u00d0\u009a\u000e\u009e\u009eT\u00e0\u0005}f\u00c0Wk\bz\u00a5 ^U\u00f2F\u00a9\u0014I\u00b0\u0006\u00f1P\u00a1z\u00ac\u00e6\u00dc\u00c2/n\u000b\u00dct\u001d7K\u0093\u0005\u001c.\u00ec^\u00ee\u001e\u0001\u00c0Z\u00e7\u00a5jQ\u00f8\u0080\u00e2\u00e1\u00abj\u00e7\u0017\u00e2>\u00ce*\u0087\u0090\u0085\u00c3\u00e8\u009a\u00b8{\u0080\u0011\u00ec\u0010)\u00ab\u00bbO\u00ceM\u00ca\u00e5\u008e\u00f3\u00adt\u00e5II\u00a8\te\u00d0\u00d3\u00f6=4\u00de\u009e\u0006\u0010\u00b0\u00df\u0088\u00c1\u00a8\u009c\u0006\u00df\u0017\u00b4\u009e\u009c\u0083T\u0085\u000b?\u00ffq\u008d\u00d1R\u00a5*m\u009e\u0081g<\u0005\u00e3\u00c7[\u00e1\u009c\u00ac\b\u00ce&s\u00fa\u009c\u0012\u00b6a\u009f\u0086\u0015<-o)\u00bd\u00f4=W\u00a9\u00d2Z\u00a0M\u00140cf\ngE\u00a3x&\u0005PJ\u00d1x\u00fc\u00ac\u0000\u0096\b+s\n\u0084\u0010\u00a9\u00ee\u00c2\f\u00e1\u00a2C\u00a5$\u00ef\u0086\r.\u00a6\u00eb\u00daF\u008f\u00f6\u008e/\u009d\u00be\u00b1'\u00c8\u00ef=7\u00d8\u008acP\u0089\u009a\u00a1g}\u0099\u0006?\u0004\u0081V\u0018<\u0080[\u00c0\u00d8FU\u00b9\u00a1\u00f0V\u00d4a\u00e0]\u00e1u \u001b\u0019\u00e2p>\u00eb\u00f8\u00b9\u0003\u00b8\u0015\u00b8\u0005m0[Y\u00b1@\u00f3+\u00d2\u00f8\u00bf\u001f\u00ba\u00b7-\tK\u00b7\u008cC;\u0095\u0096E\u0084'\u00c1K\u009f\u0013c\u00f6r+H\u0096\u008a\u00a7n\u00af\u00ae\u00f8\u000b\u000b\u009bu\f_\u00cd\u00b0\u00bb\u00e6\u0089\u00d7\u0015\u0015\u008df\u00ce>\u0092\u00f4\u00bc\u0013W\u0089\u0006\r(\u0082I\u00a9u\u00db\u00e3\u0096T)j\u001d7\\\b\u001d\u00e4\u00166?7\u0010\u00b4\u0087YZ\u00d3\u00b91\u0004\u00c8\r\u00d9J\u00d7u\u0012\u008d\u000eH\u009d\u00e7\u00fe\u0007\u00f7\u001c\u00ebY\u0094H\u009a\u00076\u00f9\u00b6\u00da\u001c\u0090\u00fd\u0007B\u00b1\\\u00bf\u00a6\u00d3\u00bc(/\u00c8\u00d3\u00c7$\u0004\u0097\u0012(h\u00de\u00cc\u00aa\u009d\u00d8\u009a\u00e4\fy\u00f1\u00a0\u008d\u00bb\u0091\u000b\u00b2?\u000e\u009cX\u0014\u00fc4\u000f0\u00b0\u00a9\u00b1O\u00a6\u000f\u008c\u00db\u00e9\u008c\u008b\u0001\u00c7qW\u0089\u0090\u00a1\u00c3dk\"L\u00d6\u00f3%\u00902\u00f7\u00f3T\u0083{\u0087>ylK\u009e\u00b2\u0012'Fi\u00a8\u0096j\u00bah\u00aae\u009eR:)O\u000e'\u0000\u009c\u00f7%n\u0012\u009c\u00ed4\u00c7\u0016%\u0098\u001bje2^\u000b\u00eeB\u00d0\u00b0:\u00e1\u00d6\u00b1\u00b6\u00bb\u00a4\u00cc\u00e5\u00e5Q\u0083\u0093coX\u00e8{\nT91\u00d2\u007f\u009b\u001fT\u00b0\u00c8\u0018\u008f=\u008eX\u009d\u0092\u00b1\u0001\u00d0\u00c9/7\u00d1\u00d9Kh\u00a5}\u001f;\u00a4\u0095\u00dc\u00fc)\u0013B\u0018\u00b7\u00ed`X\u00b9\u00a1\u00ca\u00c5\u00ae\u00eeY\u008d\u00fa7\u00d8r\u00ed\u009a \u00da\u00e3\u00c2\u00d2-\u0095\u00ba\u0017\u00b0\u009d~\u00962\u00ba\u008d\u00a9XV\u0003\t\u00fb\u00aa\u0000\u00a7M\u00d1\u0086y\u00b0".length();
                var1_4 = 8;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = 24;
                    v1 = ++var0_5;
                    v2 = var2_2.substring(v1, v1 + var1_4);
                    v3 = -1;
                    break block19;
                    break;
                }
lbl13:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "\u009f\u00f3\u00ad\u00a5\u007f\u0006.QK\u00f3\u00bc\u00ad\u00e5\u001d\u00c8V\u00bbe\u0097\u00faW\u00d9\u00b4&\u0080R\u00d0\u00e4\u00b1\u0014\u00b3\u0087\u0005\u00a8y\u00a6N\u00ff*O\u00d4\u00cd\u00c2\u00d0\u00d6\u00c6j\u0096x\u00c1";
                    var4_3 = "\u009f\u00f3\u00ad\u00a5\u007f\u0006.QK\u00f3\u00bc\u00ad\u00e5\u001d\u00c8V\u00bbe\u0097\u00faW\u00d9\u00b4&\u0080R\u00d0\u00e4\u00b1\u0014\u00b3\u0087\u0005\u00a8y\u00a6N\u00ff*O\u00d4\u00cd\u00c2\u00d0\u00d6\u00c6j\u0096x\u00c1".length();
                    var1_4 = 29;
                    var0_5 = -1;
lbl22:
                    // 2 sources

                    while (true) {
                        v0 = 56;
                        v5 = ++var0_5;
                        v2 = var2_2.substring(v5, v5 + var1_4);
                        v3 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl28:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v6 = v2.toCharArray();
            v7 = v6.length;
            var6_6 = 0;
            v8 = v0;
            v9 = v6;
            v10 = v7;
            if (v7 > 1) ** GOTO lbl85
            do {
                v11 = v8;
                v9 = v9;
                v12 = v9;
                v13 = v8;
                v14 = var6_6;
                while (true) {
                    switch (var6_6 % 7) {
                        case 0: {
                            v15 = 3;
                            break;
                        }
                        case 1: {
                            v15 = 118;
                            break;
                        }
                        case 2: {
                            v15 = 26;
                            break;
                        }
                        case 3: {
                            v15 = 111;
                            break;
                        }
                        case 4: {
                            v15 = 117;
                            break;
                        }
                        case 5: {
                            v15 = 65;
                            break;
                        }
                        default: {
                            v15 = 113;
                        }
                    }
                    v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                    ++var6_6;
                    v8 = v11;
                    if (v11 != 0) break;
                    v11 = v8;
                    v9 = v9;
                    v14 = v8;
                    v12 = v9;
                    v13 = v8;
                }
lbl85:
                // 2 sources

                v16 = v9;
                v10 = v10;
            } while (v10 > var6_6);
            v4 = new String(v16);
            switch (v3) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl95:
                // 1 sources

                ** continue;
            }
        }
        WindowsNamedPipeAgentIpc.c = var5;
        WindowsNamedPipeAgentIpc.d = new String[34];
        WindowsNamedPipeAgentIpc.Companion = new Companion(null);
    }

    private static IllegalArgumentException a(IllegalArgumentException illegalArgumentException) {
        return illegalArgumentException;
    }

    private static String b(int n2, int n3, int n4) {
        int n5 = (n2 ^ n4 ^ 0xA63) & 0xFFFF;
        if (d[n5] == null) {
            int n6;
            char[] cArray = c[n5].toCharArray();
            int n7 = switch (cArray[0] & 0xFF) {
                case 0 -> 149;
                case 1 -> 92;
                case 2 -> 55;
                case 3 -> 52;
                case 4 -> 77;
                case 5 -> 83;
                case 6 -> 12;
                case 7 -> 245;
                case 8 -> 5;
                case 9 -> 223;
                case 10 -> 177;
                case 11 -> 102;
                case 12 -> 86;
                case 13 -> 6;
                case 14 -> 84;
                case 15 -> 125;
                case 16 -> 193;
                case 17 -> 252;
                case 18 -> 178;
                case 19 -> 157;
                case 20 -> 130;
                case 21 -> 233;
                case 22 -> 187;
                case 23 -> 174;
                case 24 -> 239;
                case 25 -> 15;
                case 26 -> 168;
                case 27 -> 211;
                case 28 -> 59;
                case 29 -> 33;
                case 30 -> 154;
                case 31 -> 241;
                case 32 -> 198;
                case 33 -> 62;
                case 34 -> 8;
                case 35 -> 96;
                case 36 -> 79;
                case 37 -> 89;
                case 38 -> 46;
                case 39 -> 0;
                case 40 -> 129;
                case 41 -> 69;
                case 42 -> 228;
                case 43 -> 19;
                case 44 -> 185;
                case 45 -> 20;
                case 46 -> 201;
                case 47 -> 107;
                case 48 -> 151;
                case 49 -> 236;
                case 50 -> 188;
                case 51 -> 73;
                case 52 -> 35;
                case 53 -> 202;
                case 54 -> 18;
                case 55 -> 213;
                case 56 -> 217;
                case 57 -> 119;
                case 58 -> 225;
                case 59 -> 142;
                case 60 -> 190;
                case 61 -> 145;
                case 62 -> 105;
                case 63 -> 93;
                case 64 -> 224;
                case 65 -> 234;
                case 66 -> 47;
                case 67 -> 141;
                case 68 -> 204;
                case 69 -> 60;
                case 70 -> 122;
                case 71 -> 94;
                case 72 -> 2;
                case 73 -> 56;
                case 74 -> 36;
                case 75 -> 143;
                case 76 -> 97;
                case 77 -> 254;
                case 78 -> 216;
                case 79 -> 243;
                case 80 -> 14;
                case 81 -> 26;
                case 82 -> 49;
                case 83 -> 71;
                case 84 -> 144;
                case 85 -> 21;
                case 86 -> 54;
                case 87 -> 229;
                case 88 -> 136;
                case 89 -> 194;
                case 90 -> 165;
                case 91 -> 90;
                case 92 -> 153;
                case 93 -> 162;
                case 94 -> 120;
                case 95 -> 218;
                case 96 -> 235;
                case 97 -> 80;
                case 98 -> 172;
                case 99 -> 82;
                case 100 -> 88;
                case 101 -> 100;
                case 102 -> 30;
                case 103 -> 39;
                case 104 -> 78;
                case 105 -> 249;
                case 106 -> 75;
                case 107 -> 118;
                case 108 -> 205;
                case 109 -> 34;
                case 110 -> 9;
                case 111 -> 87;
                case 112 -> 206;
                case 113 -> 209;
                case 114 -> 67;
                case 115 -> 63;
                case 116 -> 181;
                case 117 -> 104;
                case 118 -> 220;
                case 119 -> 113;
                case 120 -> 109;
                case 121 -> 17;
                case 122 -> 247;
                case 123 -> 210;
                case 124 -> 31;
                case 125 -> 131;
                case 126 -> 121;
                case 127 -> 81;
                case 128 -> 170;
                case 129 -> 85;
                case 130 -> 27;
                case 131 -> 199;
                case 132 -> 230;
                case 133 -> 103;
                case 134 -> 68;
                case 135 -> 11;
                case 136 -> 7;
                case 137 -> 13;
                case 138 -> 48;
                case 139 -> 164;
                case 140 -> 180;
                case 141 -> 158;
                case 142 -> 57;
                case 143 -> 232;
                case 144 -> 44;
                case 145 -> 147;
                case 146 -> 111;
                case 147 -> 197;
                case 148 -> 74;
                case 149 -> 173;
                case 150 -> 248;
                case 151 -> 22;
                case 152 -> 37;
                case 153 -> 66;
                case 154 -> 23;
                case 155 -> 238;
                case 156 -> 179;
                case 157 -> 42;
                case 158 -> 242;
                case 159 -> 32;
                case 160 -> 132;
                case 161 -> 237;
                case 162 -> 214;
                case 163 -> 16;
                case 164 -> 137;
                case 165 -> 127;
                case 166 -> 138;
                case 167 -> 98;
                case 168 -> 133;
                case 169 -> 72;
                case 170 -> 167;
                case 171 -> 29;
                case 172 -> 4;
                case 173 -> 155;
                case 174 -> 41;
                case 175 -> 43;
                case 176 -> 150;
                case 177 -> 251;
                case 178 -> 117;
                case 179 -> 112;
                case 180 -> 110;
                case 181 -> 58;
                case 182 -> 227;
                case 183 -> 208;
                case 184 -> 184;
                case 185 -> 116;
                case 186 -> 45;
                case 187 -> 192;
                case 188 -> 169;
                case 189 -> 140;
                case 190 -> 108;
                case 191 -> 106;
                case 192 -> 99;
                case 193 -> 160;
                case 194 -> 123;
                case 195 -> 1;
                case 196 -> 61;
                case 197 -> 240;
                case 198 -> 171;
                case 199 -> 135;
                case 200 -> 115;
                case 201 -> 3;
                case 202 -> 166;
                case 203 -> 152;
                case 204 -> 128;
                case 205 -> 134;
                case 206 -> 95;
                case 207 -> 203;
                case 208 -> 53;
                case 209 -> 10;
                case 210 -> 246;
                case 211 -> 25;
                case 212 -> 163;
                case 213 -> 101;
                case 214 -> 176;
                case 215 -> 222;
                case 216 -> 207;
                case 217 -> 146;
                case 218 -> 200;
                case 219 -> 255;
                case 220 -> 114;
                case 221 -> 51;
                case 222 -> 40;
                case 223 -> 64;
                case 224 -> 70;
                case 225 -> 195;
                case 226 -> 28;
                case 227 -> 76;
                case 228 -> 182;
                case 229 -> 24;
                case 230 -> 191;
                case 231 -> 159;
                case 232 -> 215;
                case 233 -> 189;
                case 234 -> 148;
                case 235 -> 221;
                case 236 -> 50;
                case 237 -> 126;
                case 238 -> 196;
                case 239 -> 244;
                case 240 -> 186;
                case 241 -> 183;
                case 242 -> 253;
                case 243 -> 226;
                case 244 -> 38;
                case 245 -> 124;
                case 246 -> 91;
                case 247 -> 212;
                case 248 -> 156;
                case 249 -> 250;
                case 250 -> 231;
                case 251 -> 219;
                case 252 -> 65;
                case 253 -> 175;
                case 254 -> 139;
                default -> 161;
            };
            int n8 = ((n3 ^= n4) & 0xFF) - n7;
            if (n8 < 0) {
                n8 += 256;
            }
            if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                n6 += 256;
            }
            int n9 = 0;
            while (n9 < cArray.length) {
                int n10 = n9 % 2;
                int n11 = n9;
                char[] cArray2 = cArray;
                char c2 = cArray[n11];
                if (n10 == 0) {
                    cArray2[n11] = (char)(c2 ^ n8);
                    n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                } else {
                    cArray2[n11] = (char)(c2 ^ n6);
                    n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                }
                ++n9;
            }
            WindowsNamedPipeAgentIpc.d[n5] = new String(cArray).intern();
        }
        return d[n5];
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion;", "", "WindowsNamedPipeAgentIpc$Companion", "()V", "connectToPipeTest", "", "pipePath", "", "connectToPipe", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n24#2:392\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n*L\n84#1:392\n*E\n"})
    public static final class Companion {
        private static final String[] a;
        private static final String[] b;

        private Companion() {
        }

        @TestOnly
        public final void connectToPipeTest(@NotNull String pipePath) {
            long l2 = 3055371927911L;
            Intrinsics.checkNotNullParameter((Object)pipePath, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(1650171300 + 2286, 1650171300 - 1809, (int)l2));
            this.connectToPipe(pipePath);
        }

        private final void connectToPipe(String pipePath) {
            block6: {
                boolean bl;
                WinNT.HANDLE hANDLE;
                block7: {
                    long l2;
                    block5: {
                        WinNT.HANDLE hANDLE2;
                        String string;
                        block4: {
                            l2 = 102378030694018L;
                            hANDLE = Kernel32.INSTANCE.CreateFile(pipePath, -1073741824, 0, null, 3, 0, null);
                            string = SshAgentIpcService.C();
                            try {
                                hANDLE2 = hANDLE;
                                if (string != null) break block4;
                                if (hANDLE2 == null) break block5;
                            }
                            catch (RuntimeException runtimeException) {
                                throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                            }
                            hANDLE2 = WinNT.INVALID_HANDLE_VALUE;
                        }
                        try {
                            bl = Intrinsics.areEqual((Object)hANDLE2, (Object)hANDLE);
                            if (string != null) break block6;
                            if (!bl) break block7;
                        }
                        catch (RuntimeException runtimeException) {
                            throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                        }
                    }
                    Companion companion = this;
                    boolean bl2 = false;
                    Logger logger = Logger.getInstance(Companion.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-1104789030 - -22428, 1104789030 - 21305, (int)l2));
                    logger.info(com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-1104789030 - -22427, 1104789030 - 24643, (int)l2) + pipePath + com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-1104789030 - -22426, 1104789030 - (char)-31101, (int)l2));
                }
                bl = Kernel32.INSTANCE.CloseHandle(hANDLE);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[4];
                    var3_1 = 0;
                    var2_2 = "\u00e7\u00be\u00a1o,\u00fbn~\u0010\u00d0\u0090\u00b6\u000bt\u00cc\u009c\u00c1\u00c1Eg\u00b9\u00b5\u00f1W:";
                    var4_3 = "\u00e7\u00be\u00a1o,\u00fbn~\u0010\u00d0\u0090\u00b6\u000bt\u00cc\u009c\u00c1\u00c1Eg\u00b9\u00b5\u00f1W:".length();
                    var1_4 = 8;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 125;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "k\u001d\"\t>5\u00b4[\u00ce\u00adq36\u0087\u00f1$\u00e1G\u0080\u00d6\u00e6F\u00fb\u00c7q\u00e9z\u0099\u00deyy\u00c4\u000e\u0082\u001e]\u00d41\u00e0i\u0087:s\u00c7\u00d2\u0094\u00c9\u00c1RA?k\u00fd\u0084~\u00cbO3M";
                        var4_3 = "k\u001d\"\t>5\u00b4[\u00ce\u00adq36\u0087\u00f1$\u00e1G\u0080\u00d6\u00e6F\u00fb\u00c7q\u00e9z\u0099\u00deyy\u00c4\u000e\u0082\u001e]\u00d41\u00e0i\u0087:s\u00c7\u00d2\u0094\u00c9\u00c1RA?k\u00fd\u0084~\u00cbO3M".length();
                        var1_4 = 5;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 109;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 127;
                                break;
                            }
                            case 1: {
                                v15 = 82;
                                break;
                            }
                            case 2: {
                                v15 = 110;
                                break;
                            }
                            case 3: {
                                v15 = 1;
                                break;
                            }
                            case 4: {
                                v15 = 41;
                                break;
                            }
                            case 5: {
                                v15 = 76;
                                break;
                            }
                            default: {
                                v15 = 50;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a = var5;
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b = new String[4];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0x67F5) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 73;
                    case 1 -> 147;
                    case 2 -> 160;
                    case 3 -> 183;
                    case 4 -> 41;
                    case 5 -> 2;
                    case 6 -> 69;
                    case 7 -> 152;
                    case 8 -> 28;
                    case 9 -> 206;
                    case 10 -> 216;
                    case 11 -> 115;
                    case 12 -> 173;
                    case 13 -> 29;
                    case 14 -> 241;
                    case 15 -> 143;
                    case 16 -> 106;
                    case 17 -> 6;
                    case 18 -> 137;
                    case 19 -> 55;
                    case 20 -> 21;
                    case 21 -> 175;
                    case 22 -> 44;
                    case 23 -> 48;
                    case 24 -> 60;
                    case 25 -> 161;
                    case 26 -> 244;
                    case 27 -> 229;
                    case 28 -> 78;
                    case 29 -> 34;
                    case 30 -> 235;
                    case 31 -> 11;
                    case 32 -> 79;
                    case 33 -> 158;
                    case 34 -> 131;
                    case 35 -> 117;
                    case 36 -> 110;
                    case 37 -> 212;
                    case 38 -> 151;
                    case 39 -> 202;
                    case 40 -> 126;
                    case 41 -> 197;
                    case 42 -> 154;
                    case 43 -> 16;
                    case 44 -> 67;
                    case 45 -> 239;
                    case 46 -> 25;
                    case 47 -> 97;
                    case 48 -> 237;
                    case 49 -> 87;
                    case 50 -> 71;
                    case 51 -> 178;
                    case 52 -> 91;
                    case 53 -> 96;
                    case 54 -> 111;
                    case 55 -> 234;
                    case 56 -> 80;
                    case 57 -> 30;
                    case 58 -> 46;
                    case 59 -> 92;
                    case 60 -> 84;
                    case 61 -> 243;
                    case 62 -> 15;
                    case 63 -> 217;
                    case 64 -> 12;
                    case 65 -> 17;
                    case 66 -> 90;
                    case 67 -> 24;
                    case 68 -> 184;
                    case 69 -> 150;
                    case 70 -> 240;
                    case 71 -> 238;
                    case 72 -> 45;
                    case 73 -> 51;
                    case 74 -> 203;
                    case 75 -> 107;
                    case 76 -> 35;
                    case 77 -> 39;
                    case 78 -> 49;
                    case 79 -> 68;
                    case 80 -> 128;
                    case 81 -> 66;
                    case 82 -> 192;
                    case 83 -> 221;
                    case 84 -> 64;
                    case 85 -> 82;
                    case 86 -> 230;
                    case 87 -> 227;
                    case 88 -> 251;
                    case 89 -> 195;
                    case 90 -> 208;
                    case 91 -> 165;
                    case 92 -> 179;
                    case 93 -> 83;
                    case 94 -> 214;
                    case 95 -> 53;
                    case 96 -> 63;
                    case 97 -> 33;
                    case 98 -> 94;
                    case 99 -> 136;
                    case 100 -> 62;
                    case 101 -> 213;
                    case 102 -> 10;
                    case 103 -> 236;
                    case 104 -> 139;
                    case 105 -> 224;
                    case 106 -> 93;
                    case 107 -> 210;
                    case 108 -> 19;
                    case 109 -> 222;
                    case 110 -> 124;
                    case 111 -> 209;
                    case 112 -> 85;
                    case 113 -> 130;
                    case 114 -> 36;
                    case 115 -> 247;
                    case 116 -> 148;
                    case 117 -> 144;
                    case 118 -> 190;
                    case 119 -> 204;
                    case 120 -> 185;
                    case 121 -> 88;
                    case 122 -> 81;
                    case 123 -> 169;
                    case 124 -> 242;
                    case 125 -> 225;
                    case 126 -> 218;
                    case 127 -> 103;
                    case 128 -> 226;
                    case 129 -> 0;
                    case 130 -> 233;
                    case 131 -> 253;
                    case 132 -> 47;
                    case 133 -> 194;
                    case 134 -> 8;
                    case 135 -> 182;
                    case 136 -> 99;
                    case 137 -> 250;
                    case 138 -> 13;
                    case 139 -> 1;
                    case 140 -> 14;
                    case 141 -> 70;
                    case 142 -> 189;
                    case 143 -> 149;
                    case 144 -> 198;
                    case 145 -> 142;
                    case 146 -> 123;
                    case 147 -> 121;
                    case 148 -> 23;
                    case 149 -> 27;
                    case 150 -> 86;
                    case 151 -> 140;
                    case 152 -> 9;
                    case 153 -> 166;
                    case 154 -> 120;
                    case 155 -> 114;
                    case 156 -> 159;
                    case 157 -> 157;
                    case 158 -> 153;
                    case 159 -> 26;
                    case 160 -> 109;
                    case 161 -> 138;
                    case 162 -> 187;
                    case 163 -> 211;
                    case 164 -> 199;
                    case 165 -> 134;
                    case 166 -> 133;
                    case 167 -> 232;
                    case 168 -> 219;
                    case 169 -> 108;
                    case 170 -> 74;
                    case 171 -> 255;
                    case 172 -> 201;
                    case 173 -> 155;
                    case 174 -> 75;
                    case 175 -> 38;
                    case 176 -> 193;
                    case 177 -> 119;
                    case 178 -> 167;
                    case 179 -> 61;
                    case 180 -> 164;
                    case 181 -> 125;
                    case 182 -> 141;
                    case 183 -> 162;
                    case 184 -> 101;
                    case 185 -> 56;
                    case 186 -> 252;
                    case 187 -> 171;
                    case 188 -> 249;
                    case 189 -> 220;
                    case 190 -> 245;
                    case 191 -> 122;
                    case 192 -> 37;
                    case 193 -> 170;
                    case 194 -> 231;
                    case 195 -> 200;
                    case 196 -> 177;
                    case 197 -> 77;
                    case 198 -> 18;
                    case 199 -> 43;
                    case 200 -> 163;
                    case 201 -> 215;
                    case 202 -> 146;
                    case 203 -> 118;
                    case 204 -> 129;
                    case 205 -> 59;
                    case 206 -> 52;
                    case 207 -> 98;
                    case 208 -> 172;
                    case 209 -> 4;
                    case 210 -> 186;
                    case 211 -> 180;
                    case 212 -> 32;
                    case 213 -> 132;
                    case 214 -> 135;
                    case 215 -> 104;
                    case 216 -> 181;
                    case 217 -> 116;
                    case 218 -> 191;
                    case 219 -> 246;
                    case 220 -> 156;
                    case 221 -> 223;
                    case 222 -> 5;
                    case 223 -> 254;
                    case 224 -> 22;
                    case 225 -> 205;
                    case 226 -> 31;
                    case 227 -> 113;
                    case 228 -> 3;
                    case 229 -> 95;
                    case 230 -> 58;
                    case 231 -> 54;
                    case 232 -> 76;
                    case 233 -> 174;
                    case 234 -> 50;
                    case 235 -> 72;
                    case 236 -> 188;
                    case 237 -> 7;
                    case 238 -> 168;
                    case 239 -> 57;
                    case 240 -> 65;
                    case 241 -> 42;
                    case 242 -> 228;
                    case 243 -> 127;
                    case 244 -> 196;
                    case 245 -> 100;
                    case 246 -> 207;
                    case 247 -> 89;
                    case 248 -> 102;
                    case 249 -> 248;
                    case 250 -> 20;
                    case 251 -> 145;
                    case 252 -> 105;
                    case 253 -> 112;
                    case 254 -> 40;
                    default -> 176;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000 \b2\u00020\u0001:\u0001\bJ\u001c\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "Lcom/sun/jna/platform/win32/Kernel32;", "CancelIoEx", "", "hFile", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lpOverlapped", "Lcom/sun/jna/Pointer;", "Companion", "intellij.platform.backend.split"})
    public static interface Kernel32Ex
    extends Kernel32 {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        public boolean CancelIoEx(@Nullable WinNT.HANDLE var1, @Nullable Pointer var2);

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex$Companion;", "", "WindowsNamedPipeAgentIpc$Kernel32Ex$Companion", "()V", "INSTANCE", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "getINSTANCE", "()Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "intellij.platform.backend.split"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;
            @NotNull
            private static final Kernel32Ex INSTANCE;

            private Companion() {
            }

            @NotNull
            public final Kernel32Ex getINSTANCE() {
                return INSTANCE;
            }

            /*
             * Unable to fully structure code
             */
            static {
                block13: {
                    var7 = 113141728745296L;
                    var0_1 = new String[2];
                    var4_2 = 0;
                    var3_3 = "r[\u0001c-mP+\tuQ\u0012i`/M7\u0017";
                    var5_4 = "r[\u0001c-mP+\tuQ\u0012i`/M7\u0017".length();
                    var2_5 = 8;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        continue;
                        break;
                    }
lbl10:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = new String(v0).intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block13;
                        break;
                    }
                    v1 = ++var1_6;
                    v2 = var3_3.substring(v1, v1 + var2_5).toCharArray();
                    v3 = v2.length;
                    var6_7 = 0;
                    v4 = 41;
                    v5 = v2;
                    v6 = v3;
                    if (v3 > 1) ** GOTO lbl68
                    do {
                        v7 = v4;
                        v5 = v5;
                        v8 = v5;
                        v9 = v4;
                        v10 = var6_7;
                        while (true) {
                            switch (var6_7 % 7) {
                                case 0: {
                                    v11 = 48;
                                    break;
                                }
                                case 1: {
                                    v11 = 23;
                                    break;
                                }
                                case 2: {
                                    v11 = 90;
                                    break;
                                }
                                case 3: {
                                    v11 = 36;
                                    break;
                                }
                                case 4: {
                                    v11 = 97;
                                    break;
                                }
                                case 5: {
                                    v11 = 40;
                                    break;
                                }
                                default: {
                                    v11 = 74;
                                }
                            }
                            v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                            ++var6_7;
                            v4 = v7;
                            if (v7 != 0) break;
                            v7 = v4;
                            v5 = v5;
                            v10 = v4;
                            v8 = v5;
                            v9 = v4;
                        }
lbl68:
                        // 2 sources

                        v0 = v5;
                        v6 = v6;
                    } while (v6 > var6_7);
                    ** while (true)
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.$$INSTANCE = new Companion();
                v12 = Native.load((String)var0_1[0], Kernel32Ex.class, (Map)W32APIOptions.DEFAULT_OPTIONS);
                Intrinsics.checkNotNullExpressionValue((Object)v12, (String)var0_1[1]);
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.INSTANCE = (Kernel32Ex)v12;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\n\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "", "WindowsNamedPipeAgentIpc$NamedPipeState", "(Ljava/lang/String;I)V", "Initial", "Open", "Connecting", "Connected", "Disconnecting", "Closing", "Closed", "intellij.platform.backend.split"})
    public static final class NamedPipeState
    extends Enum<NamedPipeState> {
        public static final /* enum */ NamedPipeState Initial;
        public static final /* enum */ NamedPipeState Open;
        public static final /* enum */ NamedPipeState Connecting;
        public static final /* enum */ NamedPipeState Connected;
        public static final /* enum */ NamedPipeState Disconnecting;
        public static final /* enum */ NamedPipeState Closing;
        public static final /* enum */ NamedPipeState Closed;
        private static final /* synthetic */ NamedPipeState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static NamedPipeState[] values() {
            return (NamedPipeState[])$VALUES.clone();
        }

        public static NamedPipeState valueOf(String value) {
            return Enum.valueOf(NamedPipeState.class, value);
        }

        @NotNull
        public static EnumEntries<NamedPipeState> getEntries() {
            return $ENTRIES;
        }

        private static final /* synthetic */ NamedPipeState[] $values() {
            NamedPipeState[] namedPipeStateArray = new NamedPipeState[]{Initial, Open, Connecting, Connected, Disconnecting, Closing, Closed};
            return namedPipeStateArray;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var7 = 14115737591384L;
                    var0_1 = new String[7];
                    var4_2 = 0;
                    var3_3 = "\u000bC\u0001F\u0015v\u0005\u0004\r]\r\\\n\u0001B\u0006\\\u0019t\u001d+C\u000f\t\u0001B\u0006\\\u0019t\u001d'I\r\u0006D\u001bQ\u0013y\u0007'N\u001c[\u0012p";
                    var5_4 = "\u000bC\u0001F\u0015v\u0005\u0004\r]\r\\\n\u0001B\u0006\\\u0019t\u001d+C\u000f\t\u0001B\u0006\\\u0019t\u001d'I\r\u0006D\u001bQ\u0013y\u0007'N\u001c[\u0012p".length();
                    var2_5 = 7;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        v0 = 39;
                        v1 = ++var1_6;
                        v2 = var3_3.substring(v1, v1 + var2_5);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl14:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        var3_3 = " `&`4X/\u0006 `&`8R";
                        var5_4 = " `&`4X/\u0006 `&`8R".length();
                        var2_5 = 7;
                        var1_6 = -1;
lbl23:
                        // 2 sources

                        while (true) {
                            v0 = 6;
                            v5 = ++var1_6;
                            v2 = var3_3.substring(v5, v5 + var2_5);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl29:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_7 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl86
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_7;
                    while (true) {
                        switch (var6_7 % 7) {
                            case 0: {
                                v15 = 101;
                                break;
                            }
                            case 1: {
                                v15 = 10;
                                break;
                            }
                            case 2: {
                                v15 = 79;
                                break;
                            }
                            case 3: {
                                v15 = 21;
                                break;
                            }
                            case 4: {
                                v15 = 91;
                                break;
                            }
                            case 5: {
                                v15 = 48;
                                break;
                            }
                            default: {
                                v15 = 78;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_7;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl86:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_7);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl96:
                    // 1 sources

                    ** continue;
                }
            }
            NamedPipeState.Initial = new NamedPipeState();
            NamedPipeState.Open = new NamedPipeState();
            NamedPipeState.Connecting = new NamedPipeState();
            NamedPipeState.Connected = new NamedPipeState();
            NamedPipeState.Disconnecting = new NamedPipeState();
            NamedPipeState.Closing = new NamedPipeState();
            NamedPipeState.Closed = new NamedPipeState();
            NamedPipeState.$VALUES = NamedPipeState.$values();
            NamedPipeState.$ENTRIES = EnumEntriesKt.enumEntries((Enum[])NamedPipeState.$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel;", "Ljava/nio/channels/ReadableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeReadableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "read", "", "dst", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n24#2:392\n24#2:393\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n*L\n315#1:392\n320#1:393\n*E\n"})
    private static final class PipeReadableByteChannel
    implements ReadableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeReadableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 280549022490L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeReadableByteChannel.a(1376103930 + (char)-28375, -1376103930 + -21750, (int)l2));
            this.agent = agent;
        }

        /*
         * Exception decompiling
         */
        @Override
        public int read(@NotNull ByteBuffer dst) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 5[SWITCH]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 119877491892647L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeReadableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[9];
                    var3_1 = 0;
                    var2_2 = "N\u00c9:\u009bm\u0003\u00ba\u0015\u0010\u0005x\t\u00daG\u0092\rk\u007f\u008e\u00c3\u00ed9\u00ea?\u0004\u0096\u00e2/\u009a\u0010^\u00ae\u00ef\u0012\u00fe\u0096\u00a3\u00f7\u00e4\u000b\u001d\u00d1\u0083\u0092\u00ec\u0094\u0005\u00023\u0095\u0000{3\u00f6\u00d6\u001a\u00cb\u0095\u00e9\u00fe\f2\u0089L\u00a8o\u00ec]D&P\u000epN\u00c3\u00ee x\u00c3\u00acH\u009b`\u00c1\u00070b\u0001_\u0089\u00b3\u00f1\u00a3[\u0001~\u00bbQ\u008a\u00ed\u00f9\u0089;\u0091";
                    var4_3 = "N\u00c9:\u009bm\u0003\u00ba\u0015\u0010\u0005x\t\u00daG\u0092\rk\u007f\u008e\u00c3\u00ed9\u00ea?\u0004\u0096\u00e2/\u009a\u0010^\u00ae\u00ef\u0012\u00fe\u0096\u00a3\u00f7\u00e4\u000b\u001d\u00d1\u0083\u0092\u00ec\u0094\u0005\u00023\u0095\u0000{3\u00f6\u00d6\u001a\u00cb\u0095\u00e9\u00fe\f2\u0089L\u00a8o\u00ec]D&P\u000epN\u00c3\u00ee x\u00c3\u00acH\u009b`\u00c1\u00070b\u0001_\u0089\u00b3\u00f1\u00a3[\u0001~\u00bbQ\u008a\u00ed\u00f9\u0089;\u0091".length();
                    var1_4 = 5;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 99;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "\u001fD\u00ecd\u00b5s\u00e1`\u0087\u00d2Z\u00c1@\u00bb\u00bf\u009aL\u00cav\u00a1\u00e86*\u00ff%\u00cd\u00e9\u00bf\u001f\u00f2\u00eezI\u00ec\u000b\u0083\u00c6\u00bcZ\u00b1\u009a\u009bT\u00deW\u0004\u00e1\u00f6s\u00ed)\u00e0\u0001\u00ac\u008dD)\u00f0\u0086\u00ef\u001d]\u00ab\u008c\u00ce|\u00c2\u00ec7\u00b4\u00fc8\u00bd\u00ab\u00d4\u001a\u00b3E\u00caG\u00b4\u009a\u00c2\\\u0004\u00e4v\u00ee\u008a\u0091L!\u00b9";
                        var4_3 = "\u001fD\u00ecd\u00b5s\u00e1`\u0087\u00d2Z\u00c1@\u00bb\u00bf\u009aL\u00cav\u00a1\u00e86*\u00ff%\u00cd\u00e9\u00bf\u001f\u00f2\u00eezI\u00ec\u000b\u0083\u00c6\u00bcZ\u00b1\u009a\u009bT\u00deW\u0004\u00e1\u00f6s\u00ed)\u00e0\u0001\u00ac\u008dD)\u00f0\u0086\u00ef\u001d]\u00ab\u008c\u00ce|\u00c2\u00ec7\u00b4\u00fc8\u00bd\u00ab\u00d4\u001a\u00b3E\u00caG\u00b4\u009a\u00c2\\\u0004\u00e4v\u00ee\u008a\u0091L!\u00b9".length();
                        var1_4 = 16;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 32;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 95;
                                break;
                            }
                            case 1: {
                                v15 = 98;
                                break;
                            }
                            case 2: {
                                v15 = 63;
                                break;
                            }
                            case 3: {
                                v15 = 4;
                                break;
                            }
                            case 4: {
                                v15 = 127;
                                break;
                            }
                            case 5: {
                                v15 = 72;
                                break;
                            }
                            default: {
                                v15 = 75;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            PipeReadableByteChannel.a = var5;
            PipeReadableByteChannel.b = new String[9];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0x6439) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 35;
                    case 1 -> 19;
                    case 2 -> 14;
                    case 3 -> 194;
                    case 4 -> 109;
                    case 5 -> 191;
                    case 6 -> 26;
                    case 7 -> 88;
                    case 8 -> 195;
                    case 9 -> 63;
                    case 10 -> 244;
                    case 11 -> 172;
                    case 12 -> 168;
                    case 13 -> 221;
                    case 14 -> 134;
                    case 15 -> 48;
                    case 16 -> 220;
                    case 17 -> 222;
                    case 18 -> 129;
                    case 19 -> 159;
                    case 20 -> 54;
                    case 21 -> 55;
                    case 22 -> 98;
                    case 23 -> 131;
                    case 24 -> 178;
                    case 25 -> 66;
                    case 26 -> 140;
                    case 27 -> 83;
                    case 28 -> 82;
                    case 29 -> 32;
                    case 30 -> 180;
                    case 31 -> 128;
                    case 32 -> 144;
                    case 33 -> 229;
                    case 34 -> 212;
                    case 35 -> 76;
                    case 36 -> 253;
                    case 37 -> 177;
                    case 38 -> 64;
                    case 39 -> 149;
                    case 40 -> 225;
                    case 41 -> 248;
                    case 42 -> 154;
                    case 43 -> 231;
                    case 44 -> 101;
                    case 45 -> 179;
                    case 46 -> 123;
                    case 47 -> 234;
                    case 48 -> 24;
                    case 49 -> 163;
                    case 50 -> 254;
                    case 51 -> 60;
                    case 52 -> 16;
                    case 53 -> 51;
                    case 54 -> 214;
                    case 55 -> 207;
                    case 56 -> 199;
                    case 57 -> 206;
                    case 58 -> 137;
                    case 59 -> 10;
                    case 60 -> 161;
                    case 61 -> 106;
                    case 62 -> 150;
                    case 63 -> 103;
                    case 64 -> 193;
                    case 65 -> 208;
                    case 66 -> 105;
                    case 67 -> 227;
                    case 68 -> 143;
                    case 69 -> 23;
                    case 70 -> 46;
                    case 71 -> 115;
                    case 72 -> 228;
                    case 73 -> 62;
                    case 74 -> 11;
                    case 75 -> 71;
                    case 76 -> 210;
                    case 77 -> 92;
                    case 78 -> 133;
                    case 79 -> 80;
                    case 80 -> 251;
                    case 81 -> 141;
                    case 82 -> 126;
                    case 83 -> 111;
                    case 84 -> 58;
                    case 85 -> 166;
                    case 86 -> 209;
                    case 87 -> 156;
                    case 88 -> 202;
                    case 89 -> 20;
                    case 90 -> 93;
                    case 91 -> 187;
                    case 92 -> 142;
                    case 93 -> 158;
                    case 94 -> 42;
                    case 95 -> 121;
                    case 96 -> 232;
                    case 97 -> 18;
                    case 98 -> 120;
                    case 99 -> 77;
                    case 100 -> 57;
                    case 101 -> 157;
                    case 102 -> 165;
                    case 103 -> 113;
                    case 104 -> 182;
                    case 105 -> 49;
                    case 106 -> 216;
                    case 107 -> 117;
                    case 108 -> 0;
                    case 109 -> 130;
                    case 110 -> 89;
                    case 111 -> 192;
                    case 112 -> 22;
                    case 113 -> 7;
                    case 114 -> 247;
                    case 115 -> 146;
                    case 116 -> 97;
                    case 117 -> 217;
                    case 118 -> 250;
                    case 119 -> 205;
                    case 120 -> 245;
                    case 121 -> 230;
                    case 122 -> 107;
                    case 123 -> 147;
                    case 124 -> 90;
                    case 125 -> 116;
                    case 126 -> 184;
                    case 127 -> 152;
                    case 128 -> 79;
                    case 129 -> 45;
                    case 130 -> 181;
                    case 131 -> 132;
                    case 132 -> 219;
                    case 133 -> 110;
                    case 134 -> 238;
                    case 135 -> 174;
                    case 136 -> 84;
                    case 137 -> 100;
                    case 138 -> 236;
                    case 139 -> 65;
                    case 140 -> 31;
                    case 141 -> 86;
                    case 142 -> 136;
                    case 143 -> 36;
                    case 144 -> 17;
                    case 145 -> 52;
                    case 146 -> 119;
                    case 147 -> 185;
                    case 148 -> 200;
                    case 149 -> 50;
                    case 150 -> 171;
                    case 151 -> 242;
                    case 152 -> 249;
                    case 153 -> 3;
                    case 154 -> 176;
                    case 155 -> 12;
                    case 156 -> 104;
                    case 157 -> 21;
                    case 158 -> 5;
                    case 159 -> 241;
                    case 160 -> 28;
                    case 161 -> 40;
                    case 162 -> 108;
                    case 163 -> 13;
                    case 164 -> 198;
                    case 165 -> 70;
                    case 166 -> 87;
                    case 167 -> 94;
                    case 168 -> 72;
                    case 169 -> 53;
                    case 170 -> 38;
                    case 171 -> 239;
                    case 172 -> 223;
                    case 173 -> 44;
                    case 174 -> 201;
                    case 175 -> 243;
                    case 176 -> 197;
                    case 177 -> 47;
                    case 178 -> 125;
                    case 179 -> 211;
                    case 180 -> 164;
                    case 181 -> 169;
                    case 182 -> 41;
                    case 183 -> 61;
                    case 184 -> 190;
                    case 185 -> 29;
                    case 186 -> 8;
                    case 187 -> 15;
                    case 188 -> 67;
                    case 189 -> 170;
                    case 190 -> 56;
                    case 191 -> 173;
                    case 192 -> 81;
                    case 193 -> 37;
                    case 194 -> 43;
                    case 195 -> 213;
                    case 196 -> 151;
                    case 197 -> 4;
                    case 198 -> 27;
                    case 199 -> 233;
                    case 200 -> 25;
                    case 201 -> 237;
                    case 202 -> 226;
                    case 203 -> 127;
                    case 204 -> 255;
                    case 205 -> 155;
                    case 206 -> 74;
                    case 207 -> 69;
                    case 208 -> 102;
                    case 209 -> 6;
                    case 210 -> 186;
                    case 211 -> 39;
                    case 212 -> 85;
                    case 213 -> 153;
                    case 214 -> 78;
                    case 215 -> 196;
                    case 216 -> 99;
                    case 217 -> 118;
                    case 218 -> 138;
                    case 219 -> 183;
                    case 220 -> 218;
                    case 221 -> 175;
                    case 222 -> 204;
                    case 223 -> 162;
                    case 224 -> 235;
                    case 225 -> 246;
                    case 226 -> 124;
                    case 227 -> 145;
                    case 228 -> 96;
                    case 229 -> 167;
                    case 230 -> 112;
                    case 231 -> 34;
                    case 232 -> 59;
                    case 233 -> 2;
                    case 234 -> 9;
                    case 235 -> 122;
                    case 236 -> 215;
                    case 237 -> 139;
                    case 238 -> 95;
                    case 239 -> 203;
                    case 240 -> 160;
                    case 241 -> 75;
                    case 242 -> 148;
                    case 243 -> 1;
                    case 244 -> 189;
                    case 245 -> 33;
                    case 246 -> 30;
                    case 247 -> 68;
                    case 248 -> 135;
                    case 249 -> 224;
                    case 250 -> 188;
                    case 251 -> 240;
                    case 252 -> 114;
                    case 253 -> 91;
                    case 254 -> 252;
                    default -> 73;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeReadableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeWritableByteChannel;", "Ljava/nio/channels/WritableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeWritableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "write", "", "src", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    private static final class PipeWritableByteChannel
    implements WritableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeWritableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 64125086947603L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeWritableByteChannel.a(-1225242360 - -((char)-24112), 1225242360 - 14658, (int)l2));
            this.agent = agent;
        }

        @Override
        public int write(@NotNull ByteBuffer src) {
            int n2;
            block7: {
                IntByReference intByReference;
                block8: {
                    long l2 = 33262264122357L;
                    String string = SshAgentIpcService.C();
                    Intrinsics.checkNotNullParameter((Object)src, (String)PipeWritableByteChannel.a(-2037352080 + -12593, -2037352080 + -3353, (int)l2));
                    String string2 = string;
                    try {
                        if (!this.agent.isOpen()) {
                            throw new ClosedChannelException();
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                    intByReference = new IntByReference();
                    byte[] byArray = new byte[src.remaining()];
                    try {
                        try {
                            src.get(byArray);
                            n2 = Kernel32.INSTANCE.WriteFile(this.agent.hPipe, byArray, byArray.length, intByReference, null);
                            if (string2 != null) break block7;
                            if (n2 != 0) break block8;
                        }
                        catch (RuntimeException runtimeException) {
                            throw PipeWritableByteChannel.a(runtimeException);
                        }
                        return -1;
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                }
                n2 = intByReference.getValue();
            }
            return n2;
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 35453063922468L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeWritableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block13: {
                var5 = new String[2];
                var3_1 = 0;
                var2_2 = "]\u00bc\u00a4\u00ef@\u00034N\u00df";
                var4_3 = "]\u00bc\u00a4\u00ef@\u00034N\u00df".length();
                var1_4 = 5;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    continue;
                    break;
                }
lbl9:
                // 1 sources

                while (true) {
                    var5[var3_1++] = new String(v0).intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block13;
                    break;
                }
                v1 = ++var0_5;
                v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                v3 = v2.length;
                var6_6 = 0;
                v4 = 10;
                v5 = v2;
                v6 = v3;
                if (v3 > 1) ** GOTO lbl67
                do {
                    v7 = v4;
                    v5 = v5;
                    v8 = v5;
                    v9 = v4;
                    v10 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v11 = 59;
                                break;
                            }
                            case 1: {
                                v11 = 93;
                                break;
                            }
                            case 2: {
                                v11 = 11;
                                break;
                            }
                            case 3: {
                                v11 = 125;
                                break;
                            }
                            case 4: {
                                v11 = 67;
                                break;
                            }
                            case 5: {
                                v11 = 14;
                                break;
                            }
                            default: {
                                v11 = 11;
                            }
                        }
                        v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                        ++var6_6;
                        v4 = v7;
                        if (v7 != 0) break;
                        v7 = v4;
                        v5 = v5;
                        v10 = v4;
                        v8 = v5;
                        v9 = v4;
                    }
lbl67:
                    // 2 sources

                    v0 = v5;
                    v6 = v6;
                } while (v6 > var6_6);
                ** while (true)
            }
            PipeWritableByteChannel.a = var5;
            PipeWritableByteChannel.b = new String[2];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0xFFFFB3CB) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 220;
                    case 1 -> 91;
                    case 2 -> 150;
                    case 3 -> 86;
                    case 4 -> 17;
                    case 5 -> 44;
                    case 6 -> 66;
                    case 7 -> 199;
                    case 8 -> 214;
                    case 9 -> 223;
                    case 10 -> 121;
                    case 11 -> 62;
                    case 12 -> 221;
                    case 13 -> 24;
                    case 14 -> 198;
                    case 15 -> 103;
                    case 16 -> 247;
                    case 17 -> 122;
                    case 18 -> 200;
                    case 19 -> 6;
                    case 20 -> 15;
                    case 21 -> 161;
                    case 22 -> 222;
                    case 23 -> 43;
                    case 24 -> 5;
                    case 25 -> 60;
                    case 26 -> 18;
                    case 27 -> 229;
                    case 28 -> 188;
                    case 29 -> 176;
                    case 30 -> 59;
                    case 31 -> 16;
                    case 32 -> 29;
                    case 33 -> 195;
                    case 34 -> 28;
                    case 35 -> 21;
                    case 36 -> 37;
                    case 37 -> 249;
                    case 38 -> 219;
                    case 39 -> 33;
                    case 40 -> 158;
                    case 41 -> 224;
                    case 42 -> 225;
                    case 43 -> 90;
                    case 44 -> 192;
                    case 45 -> 168;
                    case 46 -> 10;
                    case 47 -> 117;
                    case 48 -> 71;
                    case 49 -> 108;
                    case 50 -> 99;
                    case 51 -> 242;
                    case 52 -> 64;
                    case 53 -> 173;
                    case 54 -> 228;
                    case 55 -> 25;
                    case 56 -> 81;
                    case 57 -> 83;
                    case 58 -> 65;
                    case 59 -> 106;
                    case 60 -> 41;
                    case 61 -> 175;
                    case 62 -> 204;
                    case 63 -> 201;
                    case 64 -> 58;
                    case 65 -> 184;
                    case 66 -> 153;
                    case 67 -> 243;
                    case 68 -> 55;
                    case 69 -> 110;
                    case 70 -> 194;
                    case 71 -> 189;
                    case 72 -> 172;
                    case 73 -> 84;
                    case 74 -> 126;
                    case 75 -> 237;
                    case 76 -> 130;
                    case 77 -> 212;
                    case 78 -> 11;
                    case 79 -> 47;
                    case 80 -> 124;
                    case 81 -> 36;
                    case 82 -> 123;
                    case 83 -> 138;
                    case 84 -> 134;
                    case 85 -> 193;
                    case 86 -> 20;
                    case 87 -> 164;
                    case 88 -> 178;
                    case 89 -> 67;
                    case 90 -> 155;
                    case 91 -> 148;
                    case 92 -> 7;
                    case 93 -> 113;
                    case 94 -> 73;
                    case 95 -> 0;
                    case 96 -> 70;
                    case 97 -> 38;
                    case 98 -> 181;
                    case 99 -> 217;
                    case 100 -> 160;
                    case 101 -> 26;
                    case 102 -> 131;
                    case 103 -> 52;
                    case 104 -> 128;
                    case 105 -> 96;
                    case 106 -> 8;
                    case 107 -> 182;
                    case 108 -> 152;
                    case 109 -> 218;
                    case 110 -> 154;
                    case 111 -> 135;
                    case 112 -> 250;
                    case 113 -> 111;
                    case 114 -> 14;
                    case 115 -> 100;
                    case 116 -> 251;
                    case 117 -> 170;
                    case 118 -> 233;
                    case 119 -> 127;
                    case 120 -> 72;
                    case 121 -> 211;
                    case 122 -> 245;
                    case 123 -> 4;
                    case 124 -> 159;
                    case 125 -> 40;
                    case 126 -> 120;
                    case 127 -> 234;
                    case 128 -> 78;
                    case 129 -> 156;
                    case 130 -> 93;
                    case 131 -> 207;
                    case 132 -> 76;
                    case 133 -> 118;
                    case 134 -> 205;
                    case 135 -> 208;
                    case 136 -> 46;
                    case 137 -> 45;
                    case 138 -> 57;
                    case 139 -> 236;
                    case 140 -> 34;
                    case 141 -> 144;
                    case 142 -> 248;
                    case 143 -> 240;
                    case 144 -> 1;
                    case 145 -> 196;
                    case 146 -> 241;
                    case 147 -> 105;
                    case 148 -> 54;
                    case 149 -> 30;
                    case 150 -> 235;
                    case 151 -> 109;
                    case 152 -> 169;
                    case 153 -> 137;
                    case 154 -> 210;
                    case 155 -> 98;
                    case 156 -> 31;
                    case 157 -> 216;
                    case 158 -> 232;
                    case 159 -> 89;
                    case 160 -> 146;
                    case 161 -> 79;
                    case 162 -> 23;
                    case 163 -> 132;
                    case 164 -> 165;
                    case 165 -> 75;
                    case 166 -> 107;
                    case 167 -> 2;
                    case 168 -> 143;
                    case 169 -> 167;
                    case 170 -> 115;
                    case 171 -> 42;
                    case 172 -> 203;
                    case 173 -> 39;
                    case 174 -> 183;
                    case 175 -> 129;
                    case 176 -> 68;
                    case 177 -> 215;
                    case 178 -> 254;
                    case 179 -> 87;
                    case 180 -> 157;
                    case 181 -> 12;
                    case 182 -> 238;
                    case 183 -> 125;
                    case 184 -> 69;
                    case 185 -> 94;
                    case 186 -> 97;
                    case 187 -> 49;
                    case 188 -> 253;
                    case 189 -> 206;
                    case 190 -> 48;
                    case 191 -> 50;
                    case 192 -> 35;
                    case 193 -> 163;
                    case 194 -> 140;
                    case 195 -> 179;
                    case 196 -> 56;
                    case 197 -> 136;
                    case 198 -> 162;
                    case 199 -> 149;
                    case 200 -> 227;
                    case 201 -> 63;
                    case 202 -> 213;
                    case 203 -> 9;
                    case 204 -> 246;
                    case 205 -> 252;
                    case 206 -> 230;
                    case 207 -> 77;
                    case 208 -> 197;
                    case 209 -> 19;
                    case 210 -> 185;
                    case 211 -> 226;
                    case 212 -> 255;
                    case 213 -> 61;
                    case 214 -> 92;
                    case 215 -> 186;
                    case 216 -> 139;
                    case 217 -> 32;
                    case 218 -> 190;
                    case 219 -> 171;
                    case 220 -> 141;
                    case 221 -> 114;
                    case 222 -> 177;
                    case 223 -> 80;
                    case 224 -> 88;
                    case 225 -> 166;
                    case 226 -> 102;
                    case 227 -> 174;
                    case 228 -> 239;
                    case 229 -> 145;
                    case 230 -> 231;
                    case 231 -> 187;
                    case 232 -> 85;
                    case 233 -> 22;
                    case 234 -> 53;
                    case 235 -> 191;
                    case 236 -> 101;
                    case 237 -> 147;
                    case 238 -> 133;
                    case 239 -> 27;
                    case 240 -> 74;
                    case 241 -> 116;
                    case 242 -> 119;
                    case 243 -> 142;
                    case 244 -> 95;
                    case 245 -> 104;
                    case 246 -> 82;
                    case 247 -> 112;
                    case 248 -> 3;
                    case 249 -> 180;
                    case 250 -> 209;
                    case 251 -> 151;
                    case 252 -> 202;
                    case 253 -> 13;
                    case 254 -> 51;
                    default -> 244;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeWritableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }
}

