/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import java.io.IOException;
import java.util.function.Supplier;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.EmptyStorageOperator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyCallType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyCallTypeOperators;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RIdentifier;

public abstract class RubyCallTypeBase<T>
implements RubyCallType<T> {
    @NotNull
    @NlsSafe
    private final String myCommandName;
    @Nullable
    private Supplier<? extends Icon> iconSupplier;

    public RubyCallTypeBase(@NotNull @NlsSafe String commandName) {
        if (commandName == null) {
            RubyCallTypeBase.$$$reportNull$$$0(0);
        }
        this.myCommandName = commandName;
    }

    @Override
    @NotNull
    @NlsSafe
    public String getCommandName() {
        String string = this.myCommandName;
        if (string == null) {
            RubyCallTypeBase.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public String getUniqueName() {
        String string = this.myCommandName;
        if (string == null) {
            RubyCallTypeBase.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NonNls
    public String toString() {
        return "CallType:" + this.myCommandName;
    }

    public RubyCallType<T> withIcon(@NotNull Supplier<? extends Icon> icon) {
        if (icon == null) {
            RubyCallTypeBase.$$$reportNull$$$0(3);
        }
        this.iconSupplier = icon;
        return this;
    }

    @Override
    @Nullable
    public final Icon getIcon() {
        return this.iconSupplier == null ? null : this.iconSupplier.get();
    }

    @Override
    public boolean process(@NotNull Processor<? super Symbol> processor, @NotNull Symbol symbol, @NotNull RCall call, PsiElement invocationPoint) {
        if (processor == null) {
            RubyCallTypeBase.$$$reportNull$$$0(4);
        }
        if (symbol == null) {
            RubyCallTypeBase.$$$reportNull$$$0(5);
        }
        if (call == null) {
            RubyCallTypeBase.$$$reportNull$$$0(6);
        }
        return true;
    }

    @Override
    public boolean processRIdentifier(Processor<? super Symbol> processor, Symbol symbol, RIdentifier identifier, PsiElement invocationPoint) {
        return true;
    }

    @Override
    public boolean processElements(@NotNull Processor<? super PsiElement> processor, @NotNull Symbol parent, @NotNull RCall call, @Nullable PsiElement invocationPoint) {
        if (processor == null) {
            RubyCallTypeBase.$$$reportNull$$$0(7);
        }
        if (parent == null) {
            RubyCallTypeBase.$$$reportNull$$$0(8);
        }
        if (call == null) {
            RubyCallTypeBase.$$$reportNull$$$0(9);
        }
        return this.process((Processor<Symbol>)((Processor)symbol -> symbol.getPsiElement() == null || processor.process((Object)symbol.getPsiElement())), parent, call, invocationPoint);
    }

    @Override
    public boolean canBeArrayIndexing() {
        return false;
    }

    @Override
    public int getStubVersion() {
        return 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandName";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/lang/psi/methodCall/RubyCallTypeBase";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/lang/psi/methodCall/RubyCallTypeBase";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getUniqueName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "withIcon";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "process";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "processElements";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }

    public static interface Storage<T> {
        public static final Storage EMPTY = new Storage<Void>(){

            @Override
            public Void getData() {
                return null;
            }
        };

        public static <T> Storage<T> empty() {
            return EMPTY;
        }

        public T getData();
    }

    public static abstract class StorageOperator<T> {
        @NotNull
        protected Storage<T> createStorage(@NotNull T data) {
            if (data == null) {
                StorageOperator.$$$reportNull$$$0(0);
            }
            Storage<Object> storage = () -> data;
            if (storage == null) {
                StorageOperator.$$$reportNull$$$0(1);
            }
            return storage;
        }

        @NotNull
        protected final T getCallData(@NotNull Storage<? extends T> storage) {
            if (storage == null) {
                StorageOperator.$$$reportNull$$$0(2);
            }
            T t = storage.getData();
            if (t == null) {
                StorageOperator.$$$reportNull$$$0(3);
            }
            return t;
        }

        @NotNull
        protected abstract Storage<T> readCallData(@NotNull StubInputStream var1) throws IOException;

        protected abstract void writeCallData(@NotNull Storage<T> var1, @NotNull StubOutputStream var2) throws IOException;

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/lang/psi/methodCall/RubyCallTypeBase$StorageOperator";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "storage";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/lang/psi/methodCall/RubyCallTypeBase$StorageOperator";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createStorage";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCallData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "createStorage";
                    break;
                }
                case 1: 
                case 3: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getCallData";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 3 -> new IllegalStateException(string);
            };
        }
    }

    public static final class Data<T> {
        @NotNull
        final RubyCallType<T> myCallType;
        @NotNull
        final Storage<T> myStorage;

        Data(@NotNull RubyCallType<T> callType, @NotNull Storage<T> storage) {
            if (callType == null) {
                Data.$$$reportNull$$$0(0);
            }
            if (storage == null) {
                Data.$$$reportNull$$$0(1);
            }
            this.myCallType = callType;
            this.myStorage = storage;
        }

        public <D> D getData(RubyCallType<D> o, RubyCallType<D> ... callTypes) {
            assert (this.myCallType == o || ArrayUtil.contains(this.myCallType, (Object[])callTypes));
            return (D)this.myStorage.getData();
        }

        @NotNull
        public RubyCallType<T> getCallType() {
            RubyCallType<T> rubyCallType = this.myCallType;
            if (rubyCallType == null) {
                Data.$$$reportNull$$$0(2);
            }
            return rubyCallType;
        }

        public void writeStub(@NotNull StubOutputStream dataStream) throws IOException {
            if (dataStream == null) {
                Data.$$$reportNull$$$0(3);
            }
            RubyCallTypeOperators.get(this.getCallType()).writeCallData(this.myStorage, dataStream);
        }

        public static <D> Data<D> readStub(@NotNull RubyCallType<D> callType, StubInputStream inputStream) throws IOException {
            if (callType == null) {
                Data.$$$reportNull$$$0(4);
            }
            Storage<D> callData = RubyCallTypeOperators.get(callType).readCallData(inputStream);
            return new Data<D>(callType, callData);
        }

        public static Data<?> createData(@NotNull RPossibleCall call) {
            if (call == null) {
                Data.$$$reportNull$$$0(5);
            }
            return Data.createData(call.getCallType(), call);
        }

        @NotNull
        public static <D> Data<D> createData(@NotNull RubyCallType<D> callType, @NotNull RPossibleCall call) {
            StorageOperator<D> storageOperator;
            if (callType == null) {
                Data.$$$reportNull$$$0(6);
            }
            if (call == null) {
                Data.$$$reportNull$$$0(7);
            }
            return new Data<D>(callType, (storageOperator = RubyCallTypeOperators.get(callType)) instanceof EmptyStorageOperator ? Storage.empty() : storageOperator.createStorage(callType.getCallData(call)));
        }

        public String toString() {
            return "Data{myCallType=" + String.valueOf(this.myCallType) + ", myData=" + String.valueOf(this.myStorage.getData()) + "}";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "callType";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "storage";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/lang/psi/methodCall/RubyCallTypeBase$Data";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataStream";
                    break;
                }
                case 5: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "call";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/lang/psi/methodCall/RubyCallTypeBase$Data";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCallType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "writeStub";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "readStub";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "createData";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }
}

