/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods;

import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import java.io.IOException;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArgumentInfo {
    private final String myName;
    private final Type myType;

    public ArgumentInfo(@NotNull String name, @NotNull Type type) {
        if (name == null) {
            ArgumentInfo.$$$reportNull$$$0(0);
        }
        if (type == null) {
            ArgumentInfo.$$$reportNull$$$0(1);
        }
        this.myName = name;
        this.myType = type;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ArgumentInfo info = (ArgumentInfo)obj;
        return this.myName.equals(info.myName) && this.myType == info.myType;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            ArgumentInfo.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public Type getType() {
        Type type = this.myType;
        if (type == null) {
            ArgumentInfo.$$$reportNull$$$0(3);
        }
        return type;
    }

    @NotNull
    public String getPresentableName() {
        Object object = switch (this.myType) {
            case Type.PREDEFINED -> this.myName + " = \u2026";
            case Type.ARRAY -> "*" + this.myName;
            case Type.KEYREQ -> this.myName + ":";
            case Type.NAMED -> this.myName + ": \u2026";
            case Type.HASH -> "**" + this.myName;
            case Type.BLOCK, Type.BLOCK_REQUIRED -> "&" + this.myName;
            case Type.CAPTURE -> "...";
            default -> this.myName;
        };
        if (object == null) {
            ArgumentInfo.$$$reportNull$$$0(4);
        }
        return object;
    }

    public int hashCode() {
        return 31 * this.myName.hashCode() + this.myType.hashCode();
    }

    public boolean isAnonymousBlock() {
        return this.myName.isEmpty() && this.myType.isBlock();
    }

    public boolean isAnonymousKeywordRest() {
        return this.myName.isEmpty() && this.myType == Type.HASH;
    }

    public boolean isAnonymousRest() {
        return this.myName.isEmpty() && this.myType == Type.ARRAY;
    }

    public void serialize(@NotNull StubOutputStream dataStream) throws IOException {
        if (dataStream == null) {
            ArgumentInfo.$$$reportNull$$$0(5);
        }
        dataStream.writeByte(switch (this.myType) {
            default -> throw new IncompatibleClassChangeError();
            case Type.SIMPLE -> 0;
            case Type.PREDEFINED -> 1;
            case Type.BLOCK -> 2;
            case Type.ARRAY -> 3;
            case Type.HASH -> 4;
            case Type.NAMED -> 5;
            case Type.KEYREQ -> 6;
            case Type.CAPTURE -> 7;
            case Type.BLOCK_REQUIRED -> 8;
        });
        dataStream.writeName(this.myName);
    }

    @NotNull
    public String toString() {
        String string = "ArgumentInfo{myName=%s, myType=%s}".formatted(new Object[]{this.myName, this.myType});
        if (string == null) {
            ArgumentInfo.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public static ArgumentInfo deserialize(@NotNull StubInputStream dataStream) throws IOException {
        if (dataStream == null) {
            ArgumentInfo.$$$reportNull$$$0(7);
        }
        Type type = switch (dataStream.readByte()) {
            case 0 -> Type.SIMPLE;
            case 1 -> Type.PREDEFINED;
            case 2 -> Type.BLOCK;
            case 3 -> Type.ARRAY;
            case 4 -> Type.HASH;
            case 5 -> Type.NAMED;
            case 6 -> Type.KEYREQ;
            case 7 -> Type.CAPTURE;
            case 8 -> Type.BLOCK_REQUIRED;
            default -> throw new RuntimeException("Couldn't parse type");
        };
        return new ArgumentInfo(Objects.requireNonNull(dataStream.readNameString()), type);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/lang/psi/controlStructures/methods/ArgumentInfo";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataStream";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/lang/psi/controlStructures/methods/ArgumentInfo";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "deserialize";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 6 -> new IllegalStateException(string);
        };
    }

    public static enum Type {
        SIMPLE,
        PREDEFINED,
        ARRAY,
        KEYREQ,
        NAMED,
        HASH,
        BLOCK,
        BLOCK_REQUIRED,
        CAPTURE;


        @NotNull
        public Type cleanDefaultValue() {
            Type type = switch (this) {
                case PREDEFINED -> SIMPLE;
                case NAMED -> KEYREQ;
                default -> this;
            };
            if (type == null) {
                Type.$$$reportNull$$$0(0);
            }
            return type;
        }

        @Deprecated
        public boolean hasName() {
            return this.isKeyword();
        }

        public boolean isBlock() {
            return this == BLOCK || this == BLOCK_REQUIRED;
        }

        public boolean isKeyword() {
            return this == KEYREQ || this == NAMED;
        }

        public boolean isKeywordOrRest() {
            return this == KEYREQ || this == NAMED || this == HASH;
        }

        public boolean isOptional() {
            return this == PREDEFINED || this == NAMED;
        }

        public boolean isPositional() {
            return this == SIMPLE || this == PREDEFINED;
        }

        public boolean isPositionalOrRest() {
            return this == SIMPLE || this == PREDEFINED || this == ARRAY;
        }

        public boolean isRequired() {
            return this == SIMPLE || this == KEYREQ;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/ruby/ruby/lang/psi/controlStructures/methods/ArgumentInfo$Type", "cleanDefaultValue"));
        }
    }
}

