/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight.values;

import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.values.ConstantStringValue;
import org.jetbrains.plugins.ruby.ruby.codeInsight.values.InvalidStringValue;
import org.jetbrains.plugins.ruby.ruby.codeInsight.values.StringValue;
import org.jetbrains.plugins.ruby.ruby.codeInsight.values.StringValueArray;
import org.jetbrains.plugins.ruby.ruby.codeInsight.values.StringValueConcatenation;
import org.jetbrains.plugins.ruby.ruby.codeInsight.values.StringValueHash;
import org.jetbrains.plugins.ruby.ruby.codeInsight.values.StringValueUnion;

public final class StringValueUtil {
    @NotNull
    public static StringValue createConstantStringValue(@Nullable String string) {
        int limit = Registry.intValue((String)"ruby.index.string.limit", (int)2000);
        if (string != null && string.length() <= limit) {
            return new ConstantStringValue(string, str -> "\"" + StringUtil.escapeStringCharacters((String)str) + "\"");
        }
        InvalidStringValue invalidStringValue = InvalidStringValue.INSTANCE;
        if (invalidStringValue == null) {
            StringValueUtil.$$$reportNull$$$0(0);
        }
        return invalidStringValue;
    }

    @NotNull
    public static StringValue createNumericStringValue(@Nullable String number) {
        int limit = Registry.intValue((String)"ruby.index.string.limit", (int)2000);
        if (number != null && number.length() <= limit) {
            return new ConstantStringValue(number, Function.identity());
        }
        InvalidStringValue invalidStringValue = InvalidStringValue.INSTANCE;
        if (invalidStringValue == null) {
            StringValueUtil.$$$reportNull$$$0(1);
        }
        return invalidStringValue;
    }

    @NotNull
    public static StringValue createSymbolStringValue(@Nullable String symbol) {
        int limit = Registry.intValue((String)"ruby.index.string.limit", (int)2000);
        if (symbol != null && symbol.length() <= limit) {
            return new ConstantStringValue(symbol, str -> ":" + str);
        }
        InvalidStringValue invalidStringValue = InvalidStringValue.INSTANCE;
        if (invalidStringValue == null) {
            StringValueUtil.$$$reportNull$$$0(2);
        }
        return invalidStringValue;
    }

    @NotNull
    public static StringValue createStringValueConcatenation(@NotNull List<StringValue> stringParts) {
        if (stringParts == null) {
            StringValueUtil.$$$reportNull$$$0(3);
        }
        if (stringParts.size() == 1) {
            StringValue stringValue = stringParts.get(0);
            if (stringValue == null) {
                StringValueUtil.$$$reportNull$$$0(4);
            }
            return stringValue;
        }
        int size = 1;
        for (StringValue value : stringParts) {
            if (value == null) {
                InvalidStringValue invalidStringValue = InvalidStringValue.INSTANCE;
                if (invalidStringValue == null) {
                    StringValueUtil.$$$reportNull$$$0(5);
                }
                return invalidStringValue;
            }
            int valueSize = value.getNumberOfStrings();
            if ((size *= valueSize) != 0 && size <= StringValue.MAX_NUMBER_OF_STRINGS) continue;
            InvalidStringValue invalidStringValue = InvalidStringValue.INSTANCE;
            if (invalidStringValue == null) {
                StringValueUtil.$$$reportNull$$$0(6);
            }
            return invalidStringValue;
        }
        return new StringValueConcatenation(stringParts);
    }

    @NotNull
    public static StringValue createStringValueUnion(@NotNull List<StringValue> stringValues) {
        if (stringValues == null) {
            StringValueUtil.$$$reportNull$$$0(7);
        }
        if (stringValues.size() == 1) {
            StringValue stringValue = stringValues.get(0);
            if (stringValue == null) {
                StringValueUtil.$$$reportNull$$$0(8);
            }
            return stringValue;
        }
        int size = 0;
        boolean hasNullValues = false;
        for (StringValue value : stringValues) {
            if (value == null) {
                hasNullValues = true;
                continue;
            }
            int valueSize = value.getNumberOfStrings();
            if ((size += valueSize) <= StringValue.MAX_NUMBER_OF_STRINGS) continue;
            InvalidStringValue invalidStringValue = InvalidStringValue.INSTANCE;
            if (invalidStringValue == null) {
                StringValueUtil.$$$reportNull$$$0(9);
            }
            return invalidStringValue;
        }
        if (size == 0) {
            InvalidStringValue invalidStringValue = InvalidStringValue.INSTANCE;
            if (invalidStringValue == null) {
                StringValueUtil.$$$reportNull$$$0(10);
            }
            return invalidStringValue;
        }
        if (hasNullValues) {
            stringValues = ContainerUtil.filter(stringValues, Objects::nonNull);
        }
        return new StringValueUnion(stringValues);
    }

    @NotNull
    public static StringValue createStringValueArray(@NotNull List<StringValue> stringValues) {
        if (stringValues == null) {
            StringValueUtil.$$$reportNull$$$0(11);
        }
        int size = 0;
        boolean hasNullValues = false;
        for (StringValue value2 : stringValues) {
            if (value2 == null) {
                hasNullValues = true;
                continue;
            }
            int valueSize = value2.getNumberOfStrings();
            size += valueSize;
        }
        if (size > StringValue.MAX_NUMBER_OF_STRINGS || size == 0) {
            InvalidStringValue invalidStringValue = InvalidStringValue.INSTANCE;
            if (invalidStringValue == null) {
                StringValueUtil.$$$reportNull$$$0(12);
            }
            return invalidStringValue;
        }
        if (hasNullValues) {
            stringValues = ContainerUtil.map(stringValues, value -> value != null ? value : InvalidStringValue.INSTANCE);
        }
        return new StringValueArray(stringValues);
    }

    @NotNull
    public static StringValue createStringValueHash(@NotNull Map<StringValue, StringValue> map) {
        if (map == null) {
            StringValueUtil.$$$reportNull$$$0(13);
        }
        int size = 0;
        for (Map.Entry<StringValue, StringValue> entry : map.entrySet()) {
            size += entry.getKey().getNumberOfStrings() + entry.getValue().getNumberOfStrings();
        }
        if (size > StringValue.MAX_NUMBER_OF_STRINGS || size == 0) {
            InvalidStringValue invalidStringValue = InvalidStringValue.INSTANCE;
            if (invalidStringValue == null) {
                StringValueUtil.$$$reportNull$$$0(14);
            }
            return invalidStringValue;
        }
        return new StringValueHash(map);
    }

    public static void appendStringValueArrayLists(@Nullable StringValue stringValue, @NotNull List<StringValue> stringValueList, int parameterNumber, int totalNumberOfParameters) {
        if (stringValueList == null) {
            StringValueUtil.$$$reportNull$$$0(15);
        }
        if (stringValue instanceof StringValueUnion) {
            for (StringValue value : ((StringValueUnion)stringValue).getStringValues()) {
                StringValueUtil.appendStringValueArrayLists(value, stringValueList, parameterNumber, totalNumberOfParameters);
            }
        } else if (stringValue instanceof StringValueArray) {
            List<StringValue> stringValues = ((StringValueArray)stringValue).getStringValueList();
            for (StringValue value : stringValues) {
                if (value instanceof StringValueArray && totalNumberOfParameters > 1) {
                    List<StringValue> values = ((StringValueArray)value).getStringValueList();
                    if (parameterNumber >= values.size()) continue;
                    stringValueList.add(values.get(parameterNumber));
                    continue;
                }
                if (parameterNumber != 0) continue;
                stringValueList.add(value);
            }
        } else if (totalNumberOfParameters == 2 && stringValue instanceof StringValueHash) {
            Collection<StringValue> stringValues = parameterNumber == 0 ? ((StringValueHash)stringValue).getStringValueMap().keySet() : ((StringValueHash)stringValue).getStringValueMap().values();
            stringValueList.addAll(stringValues);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3, 7, 11, 13, 15 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/codeInsight/values/StringValueUtil";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringParts";
                break;
            }
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringValues";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringValueList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createConstantStringValue";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createNumericStringValue";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createSymbolStringValue";
                break;
            }
            case 3: 
            case 7: 
            case 11: 
            case 13: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/values/StringValueUtil";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createStringValueConcatenation";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createStringValueUnion";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createStringValueArray";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createStringValueHash";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createStringValueConcatenation";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createStringValueUnion";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createStringValueArray";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createStringValueHash";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "appendStringValueArrayLists";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 3, 7, 11, 13, 15 -> new IllegalArgumentException(string);
        };
    }
}

