/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure;

import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;

public final class SymbolInheritanceInfo {
    public static final SymbolInheritanceInfo EMPTY = new SymbolInheritanceInfo(null, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
    @Nullable
    private final Symbol mySuperClass;
    @NotNull
    private final List<RCall> myPrependCalls;
    @NotNull
    private final List<RCall> myIncludeCalls;
    @NotNull
    private final List<RCall> myExtendCalls;
    @NotNull
    private final List<RCall> myDynamicCalls;

    public SymbolInheritanceInfo(@Nullable Symbol superClassSymbol, @NotNull List<RCall> prependCalls, @NotNull List<RCall> includeCalls, @NotNull List<RCall> extendCalls, @NotNull List<RCall> dynamicCalls) {
        if (prependCalls == null) {
            SymbolInheritanceInfo.$$$reportNull$$$0(0);
        }
        if (includeCalls == null) {
            SymbolInheritanceInfo.$$$reportNull$$$0(1);
        }
        if (extendCalls == null) {
            SymbolInheritanceInfo.$$$reportNull$$$0(2);
        }
        if (dynamicCalls == null) {
            SymbolInheritanceInfo.$$$reportNull$$$0(3);
        }
        this.mySuperClass = superClassSymbol;
        this.myPrependCalls = prependCalls;
        this.myIncludeCalls = includeCalls;
        this.myExtendCalls = extendCalls;
        this.myDynamicCalls = dynamicCalls;
    }

    @Nullable
    public Symbol getSuperClass() {
        return this.mySuperClass;
    }

    @NotNull
    public List<RCall> getIncludes() {
        List<RCall> list = this.myIncludeCalls;
        if (list == null) {
            SymbolInheritanceInfo.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    public List<RCall> getExtends() {
        List<RCall> list = this.myExtendCalls;
        if (list == null) {
            SymbolInheritanceInfo.$$$reportNull$$$0(5);
        }
        return list;
    }

    @NotNull
    public List<RCall> getDynamicCalls() {
        List<RCall> list = this.myDynamicCalls;
        if (list == null) {
            SymbolInheritanceInfo.$$$reportNull$$$0(6);
        }
        return list;
    }

    @NotNull
    public List<RCall> getPrepends() {
        List<RCall> list = this.myPrependCalls;
        if (list == null) {
            SymbolInheritanceInfo.$$$reportNull$$$0(7);
        }
        return list;
    }

    public boolean isValid() {
        boolean hasValidDynamicCalls = ContainerUtil.all(this.myDynamicCalls, PsiElement::isValid);
        boolean hasValidIncludeCalls = ContainerUtil.all(this.myIncludeCalls, PsiElement::isValid);
        boolean hasValidExtendCalls = ContainerUtil.all(this.myExtendCalls, PsiElement::isValid);
        boolean hasValidPrependCalls = ContainerUtil.all(this.myPrependCalls, PsiElement::isValid);
        boolean hasValidInheritanceCalls = hasValidDynamicCalls && hasValidIncludeCalls && hasValidExtendCalls && hasValidPrependCalls;
        boolean hasValidSuperclassSymbol = this.mySuperClass == null || this.mySuperClass.getPsiElement() != null && this.mySuperClass.getPsiElement().isValid();
        return hasValidInheritanceCalls && hasValidSuperclassSymbol;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prependCalls";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "includeCalls";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extendCalls";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dynamicCalls";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/codeInsight/symbols/structure/SymbolInheritanceInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/symbols/structure/SymbolInheritanceInfo";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getIncludes";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtends";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDynamicCalls";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrepends";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 7 -> new IllegalStateException(string);
        };
    }
}

