/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQNBase;

class ConstantFQN
extends FQNBase {
    @NotNull
    private final List<String> myPath;
    private final byte @NotNull [] myPathColors;
    private final boolean myIsToplevel;

    ConstantFQN(@NotNull List<String> path, byte @NotNull [] colors, boolean isToplevel) {
        if (path == null) {
            ConstantFQN.$$$reportNull$$$0(0);
        }
        if (colors == null) {
            ConstantFQN.$$$reportNull$$$0(1);
        }
        this.myPath = path;
        this.myPathColors = colors;
        this.myIsToplevel = isToplevel;
    }

    ConstantFQN(@NotNull ConstantFQN other) {
        if (other == null) {
            ConstantFQN.$$$reportNull$$$0(2);
        }
        this(other.myPath, other.myPathColors, other.myIsToplevel);
    }

    @Override
    @NotNull
    List<String> getRawPath() {
        List<String> list = this.myPath;
        if (list == null) {
            ConstantFQN.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Override
    final byte @NotNull [] getPathColors() {
        if (this.myPathColors == null) {
            ConstantFQN.$$$reportNull$$$0(4);
        }
        return this.myPathColors;
    }

    @Override
    @NotNull
    public String getFullPath() {
        if (this.myPath.isEmpty()) {
            return "";
        }
        if (this.myPath.size() == 1) {
            String string = this.myPath.get(0);
            if (string == null) {
                ConstantFQN.$$$reportNull$$$0(5);
            }
            return string;
        }
        String string = StringUtil.join(this.myPath, (String)"::");
        if (string == null) {
            ConstantFQN.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Override
    @NotNull
    public String getShortName() {
        if (this.myPath.isEmpty()) {
            return "";
        }
        String string = this.myPath.get(this.myPath.size() - 1);
        if (string == null) {
            ConstantFQN.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Override
    @NotNull
    public ConstantFQN normalize() {
        if (this == INVALID || this.myPathColors.length == 0) {
            ConstantFQN constantFQN = this;
            if (constantFQN == null) {
                ConstantFQN.$$$reportNull$$$0(8);
            }
            return constantFQN;
        }
        if (this.myPathColors.length > 1 && this.myPath.get(0).equals("Object") && !this.myPath.get(1).startsWith("$")) {
            return new ConstantFQN(this.myPath.subList(1, this.myPath.size()), ConstantFQN.createSameColors(this.myPath.size() - 1), false);
        }
        if (!this.myIsToplevel && this.myPathColors[0] == this.myPathColors[this.myPathColors.length - 1]) {
            ConstantFQN constantFQN = this;
            if (constantFQN == null) {
                ConstantFQN.$$$reportNull$$$0(9);
            }
            return constantFQN;
        }
        return new ConstantFQN(this.myPath, ConstantFQN.createSameColors(this.myPath.size()), false);
    }

    @Override
    public boolean isToplevel() {
        return this.myIsToplevel;
    }

    @Override
    @NotNull
    public Stream<String> asStream() {
        Stream<String> stream = this.myPath.stream();
        if (stream == null) {
            ConstantFQN.$$$reportNull$$$0(10);
        }
        return stream;
    }

    @Override
    @NotNull
    public List<String> asList() {
        List<String> list = Collections.unmodifiableList(this.getRawPath());
        if (list == null) {
            ConstantFQN.$$$reportNull$$$0(11);
        }
        return list;
    }

    @Override
    public boolean processNestingResolution(@NotNull Processor<? super FQN> processor) {
        if (processor == null) {
            ConstantFQN.$$$reportNull$$$0(12);
        }
        for (int i = this.myPath.size(); i > 0; --i) {
            if (i != this.myPath.size() && this.myPathColors[i - 1] == this.myPathColors[i] || processor.process((Object)new ConstantFQN(this.myPath.subList(0, i), Arrays.copyOf(this.myPathColors, i), this.myIsToplevel))) continue;
            return false;
        }
        return processor.process((Object)FQN.INVALID);
    }

    @Override
    @NotNull
    public FQN getCallerFQN() {
        int length = this.myPath.size();
        if (length <= 1) {
            FQN fQN = INVALID;
            if (fQN == null) {
                ConstantFQN.$$$reportNull$$$0(13);
            }
            return fQN;
        }
        return new ConstantFQN(this.myPath.subList(0, length - 1), Arrays.copyOf(this.myPathColors, length - 1), this.myIsToplevel);
    }

    @Override
    public final String toString() {
        return this.getFullPath();
    }

    @Override
    @NotNull
    protected FQNBase.SerializationFactory getSerializationFactory() {
        SerializationFactory serializationFactory = SerializationFactory.INSTANCE;
        if (serializationFactory == null) {
            ConstantFQN.$$$reportNull$$$0(14);
        }
        return serializationFactory;
    }

    static byte[] createSameColors(int length) {
        return new byte[length];
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 6, 7, 8, 9, 10, 11, 13, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colors";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/codeInsight/symbols/fqn/ConstantFQN";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/symbols/fqn/ConstantFQN";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRawPath";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathColors";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFullPath";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "normalize";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "asStream";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "asList";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getCallerFQN";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getSerializationFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "processNestingResolution";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 6, 7, 8, 9, 10, 11, 13, 14 -> new IllegalStateException(string);
        };
    }

    static enum SerializationFactory implements FQNBase.SerializationFactory
    {
        INSTANCE;


        @Override
        public void serialize(@NotNull FQN fqn, @NotNull StubOutputStream stream) throws IllegalArgumentException, IOException {
            if (fqn == null) {
                SerializationFactory.$$$reportNull$$$0(0);
            }
            if (stream == null) {
                SerializationFactory.$$$reportNull$$$0(1);
            }
            if (!(fqn instanceof ConstantFQN)) {
                throw new IllegalArgumentException("unexpected class " + String.valueOf(fqn));
            }
            ConstantFQN constantFQN = (ConstantFQN)fqn;
            stream.writeVarInt(constantFQN.myPath.size());
            for (String s : constantFQN.myPath) {
                stream.writeName(s);
            }
            stream.writeBoolean(constantFQN.myIsToplevel);
        }

        @Override
        @NotNull
        public ConstantFQN deserialize(@NotNull StubInputStream stream) throws IllegalArgumentException, IOException {
            if (stream == null) {
                SerializationFactory.$$$reportNull$$$0(2);
            }
            int listSize = stream.readVarInt();
            ArrayList<String> path = new ArrayList<String>(listSize);
            for (int i = 0; i < listSize; ++i) {
                path.add(StringUtil.notNullize((String)stream.readNameString()));
            }
            boolean isToplevel = stream.readBoolean();
            return new ConstantFQN(ContainerUtil.map(path, arg_0 -> FQNBase.INTERNER.intern(arg_0)), ConstantFQN.createSameColors(listSize), isToplevel);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fqn";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "stream";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/symbols/fqn/ConstantFQN$SerializationFactory";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "serialize";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "deserialize";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

