/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight.symbols;

import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Type;

public class TypeSet {
    public static final TypeSet EMPTY = new TypeSet(new Type[0]);
    private long myMask;

    public TypeSet(Type ... types) {
        for (Type type : types) {
            this.myMask |= 1L << type.getId();
        }
    }

    public boolean contains(@Nullable Type type) {
        return type != null && (this.myMask & 1L << type.getId()) != 0L;
    }

    @NotNull
    public TypeSet difference(TypeSet typeSet) {
        TypeSet result = new TypeSet(new Type[0]);
        result.myMask = this.myMask & (typeSet.myMask ^ 0xFFFFFFFFFFFFFFFFL);
        TypeSet typeSet2 = result;
        if (typeSet2 == null) {
            TypeSet.$$$reportNull$$$0(0);
        }
        return typeSet2;
    }

    public TypeSet union(Type ... types) {
        TypeSet result = new TypeSet(new Type[0]);
        result.myMask = this.myMask;
        for (Type type : types) {
            result.myMask |= 1L << type.getId();
        }
        return result;
    }

    public TypeSet union(TypeSet typeSet) {
        TypeSet result = new TypeSet(new Type[0]);
        result.myMask = this.myMask | typeSet.myMask;
        return result;
    }

    public TypeSet intersect(TypeSet typeSet) {
        TypeSet result = new TypeSet(new Type[0]);
        result.myMask = this.myMask & typeSet.myMask;
        return result;
    }

    public String toString() {
        @NonNls StringBuilder result = new StringBuilder("TypeSet(");
        boolean first = true;
        for (int bit = 0; bit < 63; ++bit) {
            long mask = 1L << bit;
            if ((this.myMask & mask) == 0L) continue;
            if (first) {
                first = false;
            } else {
                result.append(",");
            }
            result.append(((Type)Type.ourIdToTypeMap.get(bit)).getDebugName());
        }
        result.append(")");
        return result.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypeSet typeSet = (TypeSet)o;
        return this.myMask == typeSet.myMask;
    }

    public int hashCode() {
        return Long.hashCode(this.myMask);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/ruby/ruby/codeInsight/symbols/TypeSet", "difference"));
    }
}

