/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ruby.rbs.frontend.psi;

import com.intellij.extapi.psi.ASTWrapperPsiElement;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiParser;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.ruby.rbs.frontback.psi.RbsBnfParser;
import com.intellij.ruby.rbs.frontback.psi.RbsLexerAdapter;
import com.intellij.ruby.rbs.frontback.psi.tree.RbsElementTypes;
import com.intellij.ruby.rbs.frontback.psi.tree.RbsTokenSets;
import com.intellij.ruby.rbs.frontend.psi.RbsFrontendFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016J\u0012\u0010\b\u001a\u00020\t2\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\rH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016\u00a8\u0006\u0017"}, d2={"Lcom/intellij/ruby/rbs/frontend/psi/RbsFrontendParserDefinition;", "Lcom/intellij/lang/ParserDefinition;", "<init>", "()V", "createLexer", "Lcom/intellij/lexer/Lexer;", "project", "Lcom/intellij/openapi/project/Project;", "createParser", "Lcom/intellij/lang/PsiParser;", "getFileNodeType", "Lcom/intellij/psi/tree/IFileElementType;", "getCommentTokens", "Lcom/intellij/psi/tree/TokenSet;", "getStringLiteralElements", "createElement", "Lcom/intellij/psi/PsiElement;", "node", "Lcom/intellij/lang/ASTNode;", "createFile", "Lcom/intellij/psi/PsiFile;", "viewProvider", "Lcom/intellij/psi/FileViewProvider;", "intellij.ruby.rbs.frontend.split"})
public final class RbsFrontendParserDefinition
implements ParserDefinition {
    @NotNull
    public Lexer createLexer(@Nullable Project project) {
        return (Lexer)new RbsLexerAdapter();
    }

    @NotNull
    public PsiParser createParser(@Nullable Project project) {
        return (PsiParser)new RbsBnfParser();
    }

    @NotNull
    public IFileElementType getFileNodeType() {
        IFileElementType iFileElementType = RbsElementTypes.RBS_FILE;
        Intrinsics.checkNotNullExpressionValue((Object)iFileElementType, (String)"RBS_FILE");
        return iFileElementType;
    }

    @NotNull
    public TokenSet getCommentTokens() {
        TokenSet tokenSet = RbsTokenSets.RBS_COMMENTS;
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"RBS_COMMENTS");
        return tokenSet;
    }

    @NotNull
    public TokenSet getStringLiteralElements() {
        TokenSet tokenSet = RbsTokenSets.RBS_LITERALS;
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"RBS_LITERALS");
        return tokenSet;
    }

    @NotNull
    public PsiElement createElement(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return (PsiElement)new ASTWrapperPsiElement(node);
    }

    @NotNull
    public PsiFile createFile(@NotNull FileViewProvider viewProvider) {
        Intrinsics.checkNotNullParameter((Object)viewProvider, (String)"viewProvider");
        return (PsiFile)new RbsFrontendFile(viewProvider);
    }
}

