/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.intentions;

import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.intentions.SqlBaseElementAtCaretIntentionAction;
import com.intellij.sql.intentions.UtilsKt;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlInsertDmlInstruction;
import com.intellij.sql.psi.SqlInsertStatement;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlValuesExpression;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import com.intellij.sql.psi.impl.SqlPsiUtilKt;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\f0\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\u0002\b\u0007H\u0016J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000bH\u0016J\"\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0014\u0010\u0017\u001a\u00020\u0013*\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0014\u0010\u001a\u001a\u00020\t*\u00020\t2\u0006\u0010\u001b\u001a\u00020\u0013H\u0002J!\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000bH\u0096\u0002\u00a8\u0006\u001e"}, d2={"Lcom/intellij/sql/intentions/SqlSplitInsertStatementIntention;", "Lcom/intellij/sql/intentions/SqlBaseElementAtCaretIntentionAction;", "<init>", "()V", "getFamilyName", "", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "getInsertIfApplicable", "Lcom/intellij/sql/psi/SqlInsertStatement;", "element", "Lcom/intellij/psi/PsiElement;", "isAvailable", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "createValuesExpression", "Lcom/intellij/sql/psi/SqlValuesExpression;", "text", "dialect", "Lcom/intellij/sql/dialects/SqlLanguageDialectEx;", "withNewRow", "expression", "Lcom/intellij/sql/psi/SqlExpression;", "withNewValues", "values", "invoke", "", "intellij.database.sql.impl"})
@SourceDebugExtension(value={"SMAP\nSqlSplitInsertStatementIntention.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlSplitInsertStatementIntention.kt\ncom/intellij/sql/intentions/SqlSplitInsertStatementIntention\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,71:1\n1563#2:72\n1634#2,3:73\n1#3:76\n*S KotlinDebug\n*F\n+ 1 SqlSplitInsertStatementIntention.kt\ncom/intellij/sql/intentions/SqlSplitInsertStatementIntention\n*L\n62#1:72\n62#1:73,3\n*E\n"})
public final class SqlSplitInsertStatementIntention
extends SqlBaseElementAtCaretIntentionAction {
    @NotNull
    public String getFamilyName() {
        String string = SqlBundle.message((String)"intention.family.name.split.insert.statement", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    private final SqlInsertStatement getInsertIfApplicable(PsiElement element) {
        SqlInsertStatement sqlInsertStatement = (SqlInsertStatement)PsiTreeUtil.getParentOfType((PsiElement)element, SqlInsertStatement.class);
        if (sqlInsertStatement == null) {
            return null;
        }
        SqlInsertStatement insertStatement = sqlInsertStatement;
        SqlInsertDmlInstruction sqlInsertDmlInstruction = insertStatement.getDmlInstruction();
        if (sqlInsertDmlInstruction == null || (sqlInsertDmlInstruction = sqlInsertDmlInstruction.getValuesExpression()) == null) {
            return null;
        }
        SqlInsertDmlInstruction valuesExpression = sqlInsertDmlInstruction;
        if (valuesExpression.getExpressions().size() <= 1) {
            return null;
        }
        return insertStatement;
    }

    public boolean isAvailable(@NotNull Project project, @NotNull Editor editor2, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return this.getInsertIfApplicable(element) != null;
    }

    private final SqlValuesExpression createValuesExpression(String text, SqlLanguageDialectEx dialect, Project project) {
        SqlStatement statement2 = SqlPsiElementFactory.createStatementFromText((String)("INSERT INTO foo " + text), (SqlLanguageDialect)((SqlLanguageDialect)dialect), (Project)project, null);
        SqlInsertStatement sqlInsertStatement = statement2 instanceof SqlInsertStatement ? (SqlInsertStatement)statement2 : null;
        return sqlInsertStatement != null && (sqlInsertStatement = sqlInsertStatement.getDmlInstruction()) != null ? sqlInsertStatement.getValuesExpression() : null;
    }

    private final SqlValuesExpression withNewRow(SqlValuesExpression $this$withNewRow, SqlExpression expression) {
        SqlValuesExpression copy;
        block0: {
            PsiElement psiElement = $this$withNewRow.copy();
            Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type com.intellij.sql.psi.SqlValuesExpression");
            copy = (SqlValuesExpression)psiElement;
            JBIterable jBIterable = copy.getExpressions();
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"getExpressions(...)");
            SqlExpression sqlExpression = (SqlExpression)CollectionsKt.singleOrNull((Iterable)((Iterable)jBIterable));
            if (sqlExpression == null) break block0;
            sqlExpression.replace((PsiElement)expression);
        }
        return copy;
    }

    private final SqlInsertStatement withNewValues(SqlInsertStatement $this$withNewValues, SqlValuesExpression values) {
        SqlInsertStatement copy;
        block0: {
            PsiElement psiElement = $this$withNewValues.copy();
            Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type com.intellij.sql.psi.SqlInsertStatement");
            copy = (SqlInsertStatement)psiElement;
            SqlInsertDmlInstruction sqlInsertDmlInstruction = copy.getDmlInstruction();
            if (sqlInsertDmlInstruction == null || (sqlInsertDmlInstruction = sqlInsertDmlInstruction.getValuesExpression()) == null) break block0;
            sqlInsertDmlInstruction.replace((PsiElement)values);
        }
        return copy;
    }

    /*
     * WARNING - void declaration
     */
    public void invoke(@NotNull Project project, @NotNull Editor editor2, @NotNull PsiElement element) {
        Template template;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        SqlLanguageDialectEx dialect = SqlPsiUtilKt.getSqlDialect((PsiElement)element);
        SqlInsertStatement sqlInsertStatement = this.getInsertIfApplicable(element);
        if (sqlInsertStatement == null) {
            return;
        }
        SqlInsertStatement insertStatement = sqlInsertStatement;
        String string = DbSqlUtil.getDelimiterAt((PsiFile)element.getContainingFile(), (int)element.getTextRange().getStartOffset());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDelimiterAt(...)");
        String delimiter = string;
        String string2 = UtilsKt.getValuesKeyword((SqlInsertStatement)insertStatement);
        if (string2 == null) {
            return;
        }
        String valuesKeyword = string2;
        SqlInsertDmlInstruction sqlInsertDmlInstruction = insertStatement.getDmlInstruction();
        Intrinsics.checkNotNull((Object)sqlInsertDmlInstruction);
        SqlValuesExpression sqlValuesExpression = sqlInsertDmlInstruction.getValuesExpression();
        Intrinsics.checkNotNull((Object)sqlValuesExpression);
        SqlValuesExpression originalValues = sqlValuesExpression;
        SqlValuesExpression sqlValuesExpression2 = this.createValuesExpression(valuesKeyword + " (1)", dialect, project);
        if (sqlValuesExpression2 == null) {
            return;
        }
        SqlValuesExpression dummyValues = sqlValuesExpression2;
        List list = originalValues.getExpressions().map(arg_0 -> SqlSplitInsertStatementIntention.invoke$lambda$1(arg_0 -> SqlSplitInsertStatementIntention.invoke$lambda$0(this, dummyValues, arg_0), arg_0)).toList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"toList(...)");
        List valuesExpressions = list;
        originalValues.replace((PsiElement)dummyValues);
        Iterable $this$map$iv = valuesExpressions;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            SqlValuesExpression sqlValuesExpression3 = (SqlValuesExpression)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            collection.add(this.withNewValues(insertStatement, (SqlValuesExpression)it));
        }
        List insertStatements = (List)destination$iv$iv;
        String fullText = CollectionsKt.joinToString$default((Iterable)insertStatements, (CharSequence)delimiter, null, null, (int)0, null, SqlSplitInsertStatementIntention::invoke$lambda$3, (int)30, null);
        editor2.getCaretModel().moveToOffset(insertStatement.getTextRange().getStartOffset());
        insertStatement.delete();
        PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(editor2.getDocument());
        TemplateManager templateManager = TemplateManager.getInstance((Project)project);
        Template it = template = templateManager.createTemplate("", "", fullText);
        boolean bl = false;
        it.setToReformat(true);
        Template template2 = template;
        templateManager.startTemplate(editor2, template2);
    }

    private static final SqlValuesExpression invoke$lambda$0(SqlSplitInsertStatementIntention this$0, SqlValuesExpression $dummyValues, SqlExpression it) {
        Intrinsics.checkNotNull((Object)it);
        return this$0.withNewRow($dummyValues, it);
    }

    private static final SqlValuesExpression invoke$lambda$1(Function1 $tmp0, Object p0) {
        return (SqlValuesExpression)$tmp0.invoke(p0);
    }

    private static final CharSequence invoke$lambda$3(SqlInsertStatement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return string;
    }
}

