/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid.editors;

import com.intellij.database.Dbms;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.grid.editors.BitStringEditorFactory;
import com.intellij.database.run.ui.grid.editors.DbBooleanEditorFactory;
import com.intellij.database.run.ui.grid.editors.DbNumericEditorFactory;
import com.intellij.database.run.ui.grid.editors.DbTextEditorFactory;
import com.intellij.database.run.ui.grid.editors.DbTimestampEditorFactory;
import com.intellij.database.run.ui.grid.editors.DefaultBlobEditorFactory;
import com.intellij.database.run.ui.grid.editors.DefaultDateEditorFactory;
import com.intellij.database.run.ui.grid.editors.DefaultRangeEditorFactory;
import com.intellij.database.run.ui.grid.editors.DefaultTimeEditorFactory;
import com.intellij.database.run.ui.grid.editors.FactoryWithDomainSupport;
import com.intellij.database.run.ui.grid.editors.GeoTextEditorFactory;
import com.intellij.database.run.ui.grid.editors.GridCellEditorFactory;
import com.intellij.database.run.ui.grid.editors.GridCellEditorFactoryImpl;
import com.intellij.database.run.ui.grid.editors.GridCellEditorFactoryProvider;
import com.intellij.database.run.ui.grid.editors.MongoKeyEditorFactory;
import com.intellij.database.run.ui.grid.editors.MongoObjectEditorFactory;
import com.intellij.database.run.ui.grid.editors.MongoObjectIdEditorFactory;
import com.intellij.database.run.ui.grid.editors.PgHstoreEditorFactory;
import com.intellij.database.run.ui.grid.editors.TimeZonedTimeEditorFactory;
import com.intellij.database.run.ui.grid.editors.TimeZonedTimestampEditorFactory;
import com.intellij.database.run.ui.grid.editors.TypeBasedGridCellEditorFactoryProvider;
import com.intellij.database.run.ui.grid.editors.UnparsedValueWithDomain;
import com.intellij.database.run.ui.grid.editors.UuidEditorFactory;
import com.intellij.util.ui.CalendarView;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GridCellEditorFactories
extends GridCellEditorFactoryImpl
implements TypeBasedGridCellEditorFactoryProvider<Domain> {
    private static final GridCellEditorFactories INSTANCE = new GridCellEditorFactories();

    protected List<? extends GridCellEditorFactory> createFactories() {
        return Arrays.asList(new GridCellEditorFactory[]{new DbNumericEditorFactory(), new DefaultDateEditorFactory(), new DbTimestampEditorFactory(CalendarView.Mode.DATE), new DbTimestampEditorFactory(CalendarView.Mode.TIME), new DbTimestampEditorFactory(CalendarView.Mode.DATETIME), new DefaultTimeEditorFactory(), new DbTextEditorFactory(), new DefaultBlobEditorFactory(), new DbBooleanEditorFactory(), new PgHstoreEditorFactory(), new TimeZonedTimestampEditorFactory(), new TimeZonedTimeEditorFactory(), new DefaultRangeEditorFactory(), new BitStringEditorFactory(), new MongoKeyEditorFactory(), new MongoObjectIdEditorFactory(), new MongoObjectEditorFactory(), new UuidEditorFactory(), new GeoTextEditorFactory()});
    }

    public static GridCellEditorFactories getInstance() {
        return INSTANCE;
    }

    @Nullable
    public GridCellEditorFactory getEditorFactory(@NotNull DataGrid grid, @NotNull ModelIndex<GridRow> row, @NotNull ModelIndex<GridColumn> column2) {
        if (grid == null) {
            GridCellEditorFactories.$$$reportNull$$$0(0);
        }
        if (row == null) {
            GridCellEditorFactories.$$$reportNull$$$0(1);
        }
        if (column2 == null) {
            GridCellEditorFactories.$$$reportNull$$$0(2);
        }
        Object value = grid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS).getValueAt(row, column2);
        return DataGridUtil.getDbms(grid).in(Dbms.DOCUMENT_ORIENTED) && value instanceof UnparsedValueWithDomain ? this.getEditorFactory(grid, ((UnparsedValueWithDomain)value).getDomain()) : super.getEditorFactory(grid, row, column2);
    }

    @Override
    @Nullable
    public FactoryWithDomainSupport getEditorFactory(@NotNull DataGrid grid, @NotNull Domain domain) {
        if (grid == null) {
            GridCellEditorFactories.$$$reportNull$$$0(3);
        }
        if (domain == null) {
            GridCellEditorFactories.$$$reportNull$$$0(4);
        }
        return (FactoryWithDomainSupport)GridCellEditorFactoryProvider.getEditorFactory((List)this.myDefaultFactories, factory -> factory.getSuitability(grid, domain), FactoryWithDomainSupport.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "grid";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "row";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "column";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[0] = "domain";
                break;
            }
        }
        objectArray[1] = "com/intellij/database/run/ui/grid/editors/GridCellEditorFactories";
        objectArray[2] = "getEditorFactory";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

