/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.extractors;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.data.types.ColumnRef;
import com.intellij.database.data.types.ConsumerColumnRef;
import com.intellij.database.data.types.PredicateValuesKt;
import com.intellij.database.data.types.PredicatesHelperKt;
import com.intellij.database.datagrid.DataGridUtilCore;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.extractors.DataExtractor;
import com.intellij.database.extractors.DataExtractorFactory;
import com.intellij.database.extractors.DbExtractorConfig;
import com.intellij.database.extractors.ExtractionConfig;
import com.intellij.database.extractors.ExtractorConfig;
import com.intellij.database.extractors.ExtractorsUtil;
import com.intellij.database.extractors.GridExtractorsUtilCore;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.model.DasObject;
import com.intellij.database.run.ui.grid.editors.GridCellEditorHelper;
import com.intellij.database.script.generator.dml.DmlTask;
import com.intellij.database.script.generator.dml.DmlTaskKt;
import com.intellij.database.script.generator.dml.DmlUtilKt;
import com.intellij.database.script.generator.dml.WhereClause;
import com.intellij.database.script.generator.dml.WhereClauseTask;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.Out;
import com.intellij.database.util.Version;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiFunction;
import kotlin.Triple;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WhereClauseExtractorFactory
implements DataExtractorFactory {
    @NotNull
    public String getName() {
        String string = DatabaseBundle.message((String)"sql.where.clause", (Object[])new Object[0]);
        if (string == null) {
            WhereClauseExtractorFactory.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean supportsText() {
        return true;
    }

    @NotNull
    public String getFileExtension() {
        return "sql";
    }

    @Nullable
    public DataExtractor createExtractor(@NotNull ExtractorConfig config) {
        if (config == null) {
            WhereClauseExtractorFactory.$$$reportNull$$$0(1);
        }
        DbExtractorConfig dbConfig = (DbExtractorConfig)ObjectUtils.tryCast((Object)config, DbExtractorConfig.class);
        return new WhereClauseExtractor(config.getObjectFormatter(), dbConfig == null ? Dbms.UNKNOWN : dbConfig.getDbms(), dbConfig == null ? null : dbConfig.getTable(), dbConfig == null ? null : dbConfig.getVersion());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/extractors/WhereClauseExtractorFactory";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/extractors/WhereClauseExtractorFactory";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createExtractor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }

    private static class WhereClauseExtractor
    implements DataExtractor {
        private final ObjectFormatter myFormatter;
        private final Dbms myDbms;
        private final DasObject myTable;
        private final Version myVersion;

        WhereClauseExtractor(@NotNull ObjectFormatter formatter, @NotNull Dbms dbms, @Nullable DasObject table, @Nullable Version version) {
            if (formatter == null) {
                WhereClauseExtractor.$$$reportNull$$$0(0);
            }
            if (dbms == null) {
                WhereClauseExtractor.$$$reportNull$$$0(1);
            }
            this.myFormatter = formatter;
            this.myDbms = dbms;
            this.myTable = table;
            this.myVersion = version;
        }

        @NotNull
        public String getFileExtension() {
            return "sql";
        }

        public boolean supportsText() {
            return true;
        }

        public DataExtractor.Extraction startExtraction(@NotNull Out out, @NotNull List<? extends GridColumn> allColumns, @NotNull String query, @NotNull ExtractionConfig config, int ... selectedColumns) {
            if (out == null) {
                WhereClauseExtractor.$$$reportNull$$$0(2);
            }
            if (allColumns == null) {
                WhereClauseExtractor.$$$reportNull$$$0(3);
            }
            if (query == null) {
                WhereClauseExtractor.$$$reportNull$$$0(4);
            }
            if (config == null) {
                WhereClauseExtractor.$$$reportNull$$$0(5);
            }
            return new WhereClauseExtraction(out, allColumns, selectedColumns, this.myFormatter, this.myDbms, this.myTable, this.myVersion);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "formatter";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dbms";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "allColumns";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "query";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "config";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/extractors/WhereClauseExtractorFactory$WhereClauseExtractor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "startExtraction";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class WhereClauseExtraction
    implements DataExtractor.Extraction {
        private static final int LIMIT = 10000;
        private final IntSet mySelectedColumns;
        private final ObjectFormatter myFormatter;
        private final Dbms myDbms;
        private final DasObject myTable;
        private final Version myVersion;
        private List<? extends GridColumn> myAllColumns;
        private final Out myOut;
        private final List<GridRow> myRows;

        WhereClauseExtraction(@NotNull Out out, @NotNull List<? extends GridColumn> allColumns, int @NotNull [] selectedColumns, @NotNull ObjectFormatter formatter, @NotNull Dbms dbms, @Nullable DasObject table, @Nullable Version version) {
            if (out == null) {
                WhereClauseExtraction.$$$reportNull$$$0(0);
            }
            if (allColumns == null) {
                WhereClauseExtraction.$$$reportNull$$$0(1);
            }
            if (formatter == null) {
                WhereClauseExtraction.$$$reportNull$$$0(2);
            }
            if (dbms == null) {
                WhereClauseExtraction.$$$reportNull$$$0(3);
            }
            if (selectedColumns == null) {
                WhereClauseExtraction.$$$reportNull$$$0(4);
            }
            this.myRows = new ArrayList<GridRow>();
            this.myOut = out;
            this.myAllColumns = allColumns;
            this.mySelectedColumns = new IntOpenHashSet(GridExtractorsUtilCore.getNonEmptySelection(allColumns, (int[])selectedColumns));
            this.myFormatter = formatter;
            this.myDbms = dbms;
            this.myTable = table;
            this.myVersion = version;
        }

        public void updateColumns(GridColumn @NotNull [] columns) {
            if (columns == null) {
                WhereClauseExtraction.$$$reportNull$$$0(5);
            }
            this.myAllColumns = Arrays.asList(columns);
        }

        public void addData(List<? extends GridRow> rows) {
            if (this.myRows.size() >= 10000) {
                return;
            }
            this.myRows.addAll(rows);
        }

        public void complete() {
            ModelIndexSet rowIndexes = ModelIndexSet.forRows((GridModel)null, (Iterable)JBIterable.generate((Object)0, idx -> idx + 1).take(this.myRows.size()).map(idx -> ModelIndex.forRow((GridModel)null, (int)idx)));
            List columnsAndValues = ExtractorsUtil.collectColumnsAndValuesList((ModelIndexSet)rowIndexes, (IntSet)this.mySelectedColumns, (row, column2) -> this.myAllColumns.get(column2.asInteger()).getValue(this.myRows.get(row.asInteger())), (o1, o2) -> GridCellEditorHelper.areValuesEqual((Object)o1, (Object)o2, (BiFunction)DataGridUtilCore.numberEqualsInner((Dbms)this.myDbms)), this::collectValues);
            WhereClause whereClause = ExtractorsUtil.createWhereClauseTask((boolean)true, (boolean)PredicatesHelperKt.predicatesHelper((Dbms)this.myDbms).getSupportsInOperator(), (List)columnsAndValues, (column2, object) -> PredicateValuesKt.predicateValue((String)DataGridUtilCore.formatValue((GridColumn)this.myAllColumns.get(column2.asInteger()), (ObjectFormatter)this.myFormatter, (Dbms)this.myDbms, (Object)object)));
            WhereClauseTask task = DmlTaskKt.whereClause((WhereClause)whereClause).table(this.myTable).version(this.myVersion).build(DbImplUtilCore.createBuilderForUIExec((Dbms)this.myDbms, (DasObject)this.myTable));
            this.myOut.appendText((CharSequence)((DdlBuilder)DmlUtilKt.dmlGenerator((Dbms)this.myDbms).generate((DmlTask)task)).getStatement());
        }

        @NotNull
        private List<Triple<ColumnRef, ModelIndex<GridColumn>, Object>> collectValues(@NotNull ModelIndex<GridRow> rowIdx) {
            if (rowIdx == null) {
                WhereClauseExtraction.$$$reportNull$$$0(6);
            }
            ArrayList<Triple<ColumnRef, ModelIndex<GridColumn>, Object>> list = new ArrayList<Triple<ColumnRef, ModelIndex<GridColumn>, Object>>();
            GridRow row = this.myRows.get(rowIdx.asInteger());
            IntSet columns = this.mySelectedColumns.isEmpty() ? ContainerUtil.map(this.myAllColumns, c2 -> c2.getColumnNumber()) : this.mySelectedColumns;
            Iterator iterator = columns.iterator();
            while (iterator.hasNext()) {
                int columnIdx = (Integer)iterator.next();
                GridColumn column2 = this.myAllColumns.get(columnIdx);
                ModelIndex idx = ModelIndex.forColumn((GridModel)null, (int)columnIdx);
                list.add((Triple<ColumnRef, ModelIndex<GridColumn>, Object>)new Triple((Object)new ConsumerColumnRef(column2, this.myTable), (Object)idx, column2.getValue(row)));
            }
            ArrayList<Triple<ColumnRef, ModelIndex<GridColumn>, Object>> arrayList = list;
            if (arrayList == null) {
                WhereClauseExtraction.$$$reportNull$$$0(7);
            }
            return arrayList;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 7 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "allColumns";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "formatter";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dbms";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selectedColumns";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "columns";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rowIdx";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/extractors/WhereClauseExtractorFactory$WhereClauseExtraction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/extractors/WhereClauseExtractorFactory$WhereClauseExtraction";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "collectValues";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "updateColumns";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "collectValues";
                    break;
                }
                case 7: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 7 -> new IllegalStateException(string);
            };
        }
    }
}

