/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.diagram;

import com.intellij.database.diagram.DbDiagramElementManager;
import com.intellij.database.diagram.DbDiagramNode;
import com.intellij.database.diagram.DbDiagramProvider;
import com.intellij.database.diagram.DbEdge;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.ModelRelationManager;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbTable;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.view.DatabaseColorManager;
import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramProvider;
import com.intellij.diagram.DiagramRelationshipInfo;
import com.intellij.diagram.DiagramRelationshipInfoAdapter;
import com.intellij.diagram.presentation.DiagramLineType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DbDiagramDataModel
extends DiagramDataModel<DbElement> {
    private final Object underlyingElementsLock = new Object();
    private final Set<DbElement> myTableSetsAddedByUser = new HashSet<DbElement>();
    private final Map<String, DbTable> myTablesAddedByUser = new HashMap<String, DbTable>();
    private final Set<DbTable> myTablesRemovedByUser = new HashSet<DbTable>();
    private final Object nodesAndEdgesLock = new Object();
    private Collection<DbDiagramNode> myNodes = new HashSet<DbDiagramNode>();
    private Collection<DbEdge> myEdges = new HashSet<DbEdge>();
    private final AtomicReference<ProgressIndicator> modelBuildingProgress = new AtomicReference();

    public DbDiagramDataModel(Project project, DbElement element, DiagramProvider<DbElement> provider) {
        super(project, provider);
        this.addElementInner(element);
        project.getMessageBus().connect((Disposable)this).subscribe(DatabaseColorManager.COLOR_CHANGE_TOPIC, () -> this.getBuilder().getPresentationModel().update());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public Collection<DbDiagramNode> getNodes() {
        Object object = this.nodesAndEdgesLock;
        // MONITORENTER : object
        HashSet<DbDiagramNode> hashSet = new HashSet<DbDiagramNode>(this.myNodes);
        // MONITOREXIT : object
        if (hashSet != null) return hashSet;
        DbDiagramDataModel.$$$reportNull$$$0(0);
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public Collection<DbEdge> getEdges() {
        Object object = this.nodesAndEdgesLock;
        // MONITORENTER : object
        HashSet<DbEdge> hashSet = new HashSet<DbEdge>(this.myEdges);
        // MONITOREXIT : object
        if (hashSet != null) return hashSet;
        DbDiagramDataModel.$$$reportNull$$$0(1);
        return hashSet;
    }

    @NotNull
    @NonNls
    public String getNodeName(@NotNull DiagramNode<DbElement> node) {
        if (node == null) {
            DbDiagramDataModel.$$$reportNull$$$0(2);
        }
        DbElement element = (DbElement)node.getIdentifyingElement();
        String string = String.format("%s %s", element.getTypeName(), element.getName());
        if (string == null) {
            DbDiagramDataModel.$$$reportNull$$$0(3);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNode(@NotNull DiagramNode<DbElement> node) {
        if (node == null) {
            DbDiagramDataModel.$$$reportNull$$$0(4);
        }
        Object object = this.underlyingElementsLock;
        synchronized (object) {
            DbElement element = (DbElement)node.getIdentifyingElement();
            if (element instanceof DbTable) {
                this.myTablesRemovedByUser.add((DbTable)element);
                this.myTablesAddedByUser.remove(element.getName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DiagramNode<DbElement> addElement(@Nullable DbElement element) {
        Object object = this.underlyingElementsLock;
        synchronized (object) {
            this.addElementInner(element);
            if (element instanceof DbTable) {
                DbTable table = (DbTable)element;
                this.myTablesRemovedByUser.remove(table);
                return this.createDbNode(table);
            }
            return null;
        }
    }

    private DbDiagramNode createDbNode(DbTable table) {
        return new DbDiagramNode(table, (DiagramProvider<DbElement>)this.getProvider());
    }

    private void addElementInner(@Nullable DbElement element) {
        if (element instanceof DbTable) {
            this.myTablesAddedByUser.put(element.getName(), (DbTable)element);
        } else if (element != null) {
            this.myTableSetsAddedByUser.add(element);
        }
    }

    @NotNull
    private JBIterable<DbDataSource> getDataSources() {
        JBIterable jBIterable = JBIterable.from(this.myTableSetsAddedByUser).append(this.myTablesAddedByUser.values()).map(DbElement::getDataSource).unique();
        if (jBIterable == null) {
            DbDiagramDataModel.$$$reportNull$$$0(5);
        }
        return jBIterable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshDataModel() {
        Map<DbTable, DbDiagramNode> elementToNodeMap = this.calculateElementToNodeMap();
        Collection<DbEdge> edges = this.calculateEdges(elementToNodeMap);
        Object object = this.nodesAndEdgesLock;
        synchronized (object) {
            this.myNodes = new HashSet<DbDiagramNode>(elementToNodeMap.values());
            this.myEdges = edges;
        }
    }

    @NotNull
    public CompletableFuture<Void> refreshDataModelAsync(@Nullable ProgressIndicator indicator) {
        if (!this.modelBuildingProgress.compareAndSet(null, indicator)) {
            CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
            if (completableFuture == null) {
                DbDiagramDataModel.$$$reportNull$$$0(6);
            }
            return completableFuture;
        }
        this.refreshDataModel();
        CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
        CompletableFuture<Object> completableFuture2 = completableFuture;
        if (completableFuture2 == null) {
            DbDiagramDataModel.$$$reportNull$$$0(7);
        }
        return completableFuture2;
        finally {
            this.modelBuildingProgress.set(null);
        }
    }

    @NotNull
    public ModificationTracker getModificationTracker() {
        DbDiagramDataModel dbDiagramDataModel = this;
        if (dbDiagramDataModel == null) {
            DbDiagramDataModel.$$$reportNull$$$0(8);
        }
        return dbDiagramDataModel;
    }

    @NotNull
    private Map<DbTable, DbDiagramNode> calculateElementToNodeMap() {
        Map<DbTable, DbDiagramNode> map2 = this.getAllTables().stream().collect(Collectors.toMap(Function.identity(), this::createDbNode));
        if (map2 == null) {
            DbDiagramDataModel.$$$reportNull$$$0(9);
        }
        return map2;
    }

    private Collection<DbEdge> calculateEdges(Map<DbTable, DbDiagramNode> elementToNodeMap) {
        ArrayList<DbEdge> result = new ArrayList<DbEdge>();
        boolean virtualFk = Objects.requireNonNull(this.getNodeContentManager()).isCategoryEnabled(DbDiagramProvider.Holder.VIRTUAL_FOREIGN_KEYS);
        for (DbDiagramNode node : elementToNodeMap.values()) {
            DbTable table = node.getIdentifyingElement();
            for (DasForeignKey key : virtualFk ? ModelRelationManager.getForeignKeys((Project)this.getProject(), (DasTable)table) : DasUtil.getForeignKeys((DasTable)table)) {
                String name2 = key.getName();
                DbDiagramNode target = elementToNodeMap.get(this.asDbElement(key.getRefTable()));
                if (target == null) continue;
                String label = DbDiagramDataModel.getFkRelationshipLabel(key);
                result.add(DbDiagramDataModel.createEdge(node, name2, target, label));
            }
        }
        return result;
    }

    @NotNull
    private static DbEdge createEdge(DbDiagramNode from, String name2, DbDiagramNode to, String label) {
        DiagramRelationshipInfoAdapter relationship = new DiagramRelationshipInfoAdapter.Builder().setName("REFERENCES").setLineType(DiagramLineType.SOLID).setTargetArrow(DiagramRelationshipInfo.DELTA).setUpperCenterLabel(label).create();
        return new DbEdge((DiagramNode<DbElement>)from, (DiagramNode<DbElement>)to, StringUtil.notNullize((String)name2), (DiagramRelationshipInfo)relationship);
    }

    @NotNull
    private static String getFkRelationshipLabel(DasForeignKey key) {
        String refColumnsLabel;
        String columnsRefLabel = StringUtil.join((Iterable)key.getColumnsRef().names(), (String)", ");
        Object object = columnsRefLabel.equals(refColumnsLabel = StringUtil.join((Iterable)key.getRefColumns().names(), (String)", ")) ? columnsRefLabel : columnsRefLabel + ":" + refColumnsLabel;
        if (object == null) {
            DbDiagramDataModel.$$$reportNull$$$0(10);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<DbTable> getAllTables() {
        HashSet<DbTable> removedCopy;
        HashSet<DbElement> tableSetsCopy;
        ArrayDeque<DbTable> queue;
        Object object = this.underlyingElementsLock;
        synchronized (object) {
            queue = new ArrayDeque<DbTable>(this.myTablesAddedByUser.values());
            tableSetsCopy = new HashSet<DbElement>(this.myTableSetsAddedByUser);
            removedCopy = new HashSet<DbTable>(this.myTablesRemovedByUser);
        }
        HashSet<DbTable> tables = new HashSet<DbTable>();
        for (DbElement o : tableSetsCopy) {
            if (!o.isValid()) continue;
            for (DbTable object2 : ((JBTreeTraverser)DbImplUtilCore.traverseVisibleObjects((DasDataSource)o.getDataSource()).withRoot((Object)o)).traverse().filter(DbTable.class)) {
                if (!DbDiagramElementManager.isAcceptedAsNodeImpl(object2)) continue;
                this.addTableAndReferences(tables, queue, object2);
            }
        }
        while (!queue.isEmpty()) {
            this.addTableAndReferences(tables, queue, (DbTable)queue.remove());
        }
        tables.remove(null);
        tables.removeAll(removedCopy);
        tables.removeIf(t -> !t.isValid());
        return tables;
    }

    private void addTableAndReferences(Set<DbTable> tables, Queue<DbTable> list, DbTable table) {
        if (!tables.add(table)) {
            return;
        }
        if (!table.isValid()) {
            return;
        }
        for (DasForeignKey info2 : ModelRelationManager.getForeignKeys((Project)this.getProject(), (DasTable)table)) {
            DbTable targetTable = this.asDbElement(info2.getRefTable());
            if (targetTable == null || tables.contains(targetTable)) continue;
            list.add(targetTable);
        }
    }

    @Nullable
    private DbTable asDbElement(@Nullable DasTable obj) {
        if (obj == null) {
            return null;
        }
        DbTable element = (DbTable)ObjectUtils.tryCast((Object)obj, DbTable.class);
        if (element != null) {
            return element;
        }
        return (DbTable)this.getDataSources().filterMap(ds -> (DbTable)ObjectUtils.tryCast((Object)DbImplUtilCore.findElement((DbDataSource)ds, (DasObject)obj), DbTable.class)).first();
    }

    public void dispose() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/diagram/DbDiagramDataModel";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodes";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getEdges";
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/diagram/DbDiagramDataModel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataSources";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "refreshDataModelAsync";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getModificationTracker";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateElementToNodeMap";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getFkRelationshipLabel";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getNodeName";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "removeNode";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 4 -> new IllegalArgumentException(string);
        };
    }
}

