/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.haml.ruby.refactoring;

import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiBinaryFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.PsiFileSystemItemUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.lang.ExtractIncludeDialog;
import com.intellij.refactoring.lang.ExtractIncludeFileBase;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.haml.HAMLLanguage;
import org.jetbrains.plugins.haml.psi.HAMLTokenTypes;
import org.jetbrains.plugins.haml.psi.impl.HAMLTagImpl;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.rails.refactoring.ExtractPartialDialog;

final class HAMLExtractPartialHandler
extends ExtractIncludeFileBase<HAMLTagImpl> {
    HAMLExtractPartialHandler() {
    }

    protected ExtractIncludeDialog createDialog(PsiDirectory containingDirectory, String extractExtension) {
        return new ExtractPartialDialog(containingDirectory, extractExtension);
    }

    @NotNull
    protected String doExtract(PsiDirectory targetDirectory, String targetFileName, HAMLTagImpl first, HAMLTagImpl last, Language includingLanguage) throws IncorrectOperationException {
        PsiElement parent = first.getParent();
        Project project = parent.getProject();
        PsiFile including = first.getContainingFile();
        String newFileText = including.getText().substring(first.getTextRange().getStartOffset(), last.getTextRange().getEndOffset());
        PsiElement prev = first.getPrevSibling();
        if (prev != null && prev.getNode().getElementType() == HAMLTokenTypes.INDENT) {
            newFileText = newFileText.replace("\n" + prev.getText(), "\n");
        }
        PsiFile extracted = targetDirectory.createFile(targetFileName);
        assert (!(extracted instanceof PsiBinaryFile));
        Document doc = PsiDocumentManager.getInstance((Project)project).getDocument(extracted);
        assert (doc != null);
        doc.replaceString(0, doc.getTextLength(), (CharSequence)newFileText);
        PsiDocumentManager.getInstance((Project)project).commitDocument(doc);
        CodeStyleManager.getInstance((Project)extracted.getProject()).adjustLineIndent(extracted, extracted.getTextRange());
        String relativePath = PsiFileSystemItemUtil.findRelativePath((PsiFileSystemItem)including, (PsiFileSystemItem)extracted);
        if (relativePath == null) {
            throw new IncorrectOperationException("Cannot extract!");
        }
        String string = relativePath;
        if (string == null) {
            HAMLExtractPartialHandler.$$$reportNull$$$0(0);
        }
        return string;
    }

    protected void doReplaceRange(String includePath, HAMLTagImpl first, HAMLTagImpl last) {
        ApplicationManager.getApplication().runWriteAction(() -> {
            String partialName = includePath.substring(1);
            int dot = partialName.indexOf(46);
            if (dot >= 0) {
                partialName = partialName.substring(0, dot);
            }
            PsiDocumentManager docManager = PsiDocumentManager.getInstance((Project)first.getProject());
            Document document = docManager.getDocument(first.getContainingFile());
            assert (document != null);
            document.replaceString(first.getTextRange().getStartOffset(), last.getTextRange().getEndOffset(), (CharSequence)("= render :partial => '" + partialName + "'"));
            docManager.commitDocument(document);
        });
    }

    protected boolean verifyChildRange(HAMLTagImpl first, HAMLTagImpl last) {
        return first != null && last != null && first.getParent() == last.getParent();
    }

    protected Pair<HAMLTagImpl, HAMLTagImpl> findPairToExtract(int start, int end) {
        IElementType type;
        PsiElement endElement;
        IElementType type2;
        PsiElement startElement;
        for (startElement = this.myIncludingFile.getViewProvider().findElementAt(start, (Language)HAMLLanguage.INSTANCE); startElement != null && ((type2 = startElement.getNode().getElementType()) == HAMLTokenTypes.WHITESPACE || type2 == HAMLTokenTypes.EOL || type2 == HAMLTokenTypes.INDENT); startElement = startElement.getNextSibling()) {
        }
        if (startElement != null && startElement.getNode().getElementType() == HAMLTokenTypes.FILTER_CONTENT) {
            return null;
        }
        for (endElement = this.myIncludingFile.getViewProvider().findElementAt(end - 1, (Language)HAMLLanguage.INSTANCE); endElement != null && ((type = endElement.getNode().getElementType()) == HAMLTokenTypes.WHITESPACE || type == HAMLTokenTypes.EOL || type == HAMLTokenTypes.INDENT); endElement = endElement.getPrevSibling()) {
        }
        HAMLTagImpl first = (HAMLTagImpl)PsiTreeUtil.getParentOfType((PsiElement)startElement, HAMLTagImpl.class, (boolean)false);
        HAMLTagImpl last = (HAMLTagImpl)PsiTreeUtil.getParentOfType((PsiElement)endElement, HAMLTagImpl.class, (boolean)false);
        return last != null && PsiTreeUtil.isAncestor((PsiElement)first, (PsiElement)last, (boolean)false) ? Pair.create((Object)first, (Object)first) : Pair.create((Object)first, (Object)last);
    }

    @NotNull
    protected Language getLanguageForExtract(PsiElement firstExtracted) {
        HAMLLanguage hAMLLanguage = HAMLLanguage.INSTANCE;
        if (hAMLLanguage == null) {
            HAMLExtractPartialHandler.$$$reportNull$$$0(1);
        }
        return hAMLLanguage;
    }

    public String getActionTitle() {
        return RBundle.message((String)"haml.refactoring.extract.partial.action.title");
    }

    protected String getRefactoringName() {
        return RBundle.message((String)"haml.refactoring.extract.partial.dialog.title");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/plugins/haml/ruby/refactoring/HAMLExtractPartialHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "doExtract";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageForExtract";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

