/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.haml.ruby.psi;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.MultiplePsiFilesPerDocumentFileViewProvider;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import com.intellij.psi.tree.IElementType;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.haml.HAMLLanguage;
import org.jetbrains.plugins.haml.ruby.HAMLRubyElementTypes;
import org.jetbrains.plugins.haml.ruby.psi.impl.HAMLRubyFileImpl;
import org.jetbrains.plugins.ruby.ruby.lang.RubyLanguage;

public final class HAMLFileViewProvider
extends MultiplePsiFilesPerDocumentFileViewProvider
implements TemplateLanguageFileViewProvider {
    private Set<Language> myViews = null;

    public HAMLFileViewProvider(PsiManager manager, VirtualFile virtualFile, boolean physical) {
        super(manager, virtualFile, physical);
    }

    @NotNull
    public Language getBaseLanguage() {
        HAMLLanguage hAMLLanguage = HAMLLanguage.INSTANCE;
        if (hAMLLanguage == null) {
            HAMLFileViewProvider.$$$reportNull$$$0(0);
        }
        return hAMLLanguage;
    }

    @NotNull
    public Language getTemplateDataLanguage() {
        RubyLanguage rubyLanguage = RubyLanguage.INSTANCE;
        if (rubyLanguage == null) {
            HAMLFileViewProvider.$$$reportNull$$$0(1);
        }
        return rubyLanguage;
    }

    @NotNull
    public Set<Language> getLanguages() {
        if (this.myViews == null) {
            LinkedHashSet<Language> views = new LinkedHashSet<Language>(2);
            views.add((Language)HAMLLanguage.INSTANCE);
            views.add((Language)RubyLanguage.INSTANCE);
            this.myViews = views;
        }
        Set<Language> set = this.myViews;
        if (set == null) {
            HAMLFileViewProvider.$$$reportNull$$$0(2);
        }
        return set;
    }

    @NotNull
    protected MultiplePsiFilesPerDocumentFileViewProvider cloneInner(@NotNull VirtualFile copy) {
        if (copy == null) {
            HAMLFileViewProvider.$$$reportNull$$$0(3);
        }
        return new HAMLFileViewProvider((PsiManager)this.getManager(), copy, false);
    }

    public boolean supportsIncrementalReparse(@NotNull Language rootLanguage) {
        if (rootLanguage == null) {
            HAMLFileViewProvider.$$$reportNull$$$0(4);
        }
        return false;
    }

    protected PsiFile createFile(@NotNull Language language) {
        if (language == null) {
            HAMLFileViewProvider.$$$reportNull$$$0(5);
        }
        if (language == this.getTemplateDataLanguage()) {
            return new HAMLRubyFileImpl((FileViewProvider)this);
        }
        if (language == this.getBaseLanguage()) {
            ParserDefinition def = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(language);
            assert (def != null);
            return def.createFile((FileViewProvider)this);
        }
        return null;
    }

    @Nullable
    public IElementType getContentElementType(@NotNull Language language) {
        if (language == null) {
            HAMLFileViewProvider.$$$reportNull$$$0(6);
        }
        return language == this.getTemplateDataLanguage() ? HAMLRubyElementTypes.RUBY_DECLARATIONS_IN_HAML_ROOT : null;
    }

    @NotNull
    public PsiFile getStubBindingRoot() {
        PsiFile psi = this.getPsi((Language)RubyLanguage.INSTANCE);
        assert (psi != null);
        PsiFile psiFile = psi;
        if (psiFile == null) {
            HAMLFileViewProvider.$$$reportNull$$$0(7);
        }
        return psiFile;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3, 4, 5, 6 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/haml/ruby/psi/HAMLFileViewProvider";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copy";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootLanguage";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseLanguage";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplateDataLanguage";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguages";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/haml/ruby/psi/HAMLFileViewProvider";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getStubBindingRoot";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "cloneInner";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "supportsIncrementalReparse";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createFile";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getContentElementType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 3, 4, 5, 6 -> new IllegalArgumentException(string);
        };
    }
}

