/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.haml.ruby;

import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.haml.HAMLFileType;
import org.jetbrains.plugins.haml.HAMLLanguage;
import org.jetbrains.plugins.haml.psi.HAMLTokenTypes;
import org.jetbrains.plugins.haml.ruby.psi.HAMLRubyUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RCompoundStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RExpression;
import org.jetbrains.plugins.ruby.templates.TemplateIntegration;

final class RubyHAMLIntegrationImpl
implements TemplateIntegration {
    RubyHAMLIntegrationImpl() {
    }

    public boolean canModifyPsiInsert(@NotNull FileViewProvider provider) {
        if (provider == null) {
            RubyHAMLIntegrationImpl.$$$reportNull$$$0(0);
        }
        Set languages = provider.getLanguages();
        PsiFile hamlPsiFile = provider.getPsi((Language)HAMLLanguage.INSTANCE);
        return languages.size() == 2 && hamlPsiFile != null;
    }

    @Nullable
    public PsiElement addRubyStatement(@NotNull FileViewProvider provider, @NotNull RCompoundStatement parent, @NotNull PsiElement elementToAdd, @Nullable PsiElement anchor, boolean before) {
        if (provider == null) {
            RubyHAMLIntegrationImpl.$$$reportNull$$$0(1);
        }
        if (parent == null) {
            RubyHAMLIntegrationImpl.$$$reportNull$$$0(2);
        }
        if (elementToAdd == null) {
            RubyHAMLIntegrationImpl.$$$reportNull$$$0(3);
        }
        return HAMLRubyUtil.addRubyStatement(parent, elementToAdd, anchor, before);
    }

    @NotNull
    public String getFileTemplateName() {
        return "Haml File";
    }

    @NotNull
    public FileType getFileType() {
        HAMLFileType hAMLFileType = HAMLFileType.HAML;
        if (hAMLFileType == null) {
            RubyHAMLIntegrationImpl.$$$reportNull$$$0(4);
        }
        return hAMLFileType;
    }

    @NotNull
    public Language getLanguage() {
        HAMLLanguage hAMLLanguage = HAMLLanguage.INSTANCE;
        if (hAMLLanguage == null) {
            RubyHAMLIntegrationImpl.$$$reportNull$$$0(5);
        }
        return hAMLLanguage;
    }

    @Nullable
    public String getTextForI18n(@NotNull Editor editor, @NotNull PsiFile file) {
        if (editor == null) {
            RubyHAMLIntegrationImpl.$$$reportNull$$$0(6);
        }
        if (file == null) {
            RubyHAMLIntegrationImpl.$$$reportNull$$$0(7);
        }
        return (String)ObjectUtils.doIfNotNull((Object)RubyHAMLIntegrationImpl.findTextElementAtCaret(editor, file), element -> element.getText().trim());
    }

    public boolean replaceTextWithI18n(@NotNull Editor editor, @NotNull PsiFile file, @NotNull RExpression expression) {
        PsiElement element;
        if (editor == null) {
            RubyHAMLIntegrationImpl.$$$reportNull$$$0(8);
        }
        if (file == null) {
            RubyHAMLIntegrationImpl.$$$reportNull$$$0(9);
        }
        if (expression == null) {
            RubyHAMLIntegrationImpl.$$$reportNull$$$0(10);
        }
        if ((element = RubyHAMLIntegrationImpl.findTextElementAtCaret(editor, file)) == null) {
            return false;
        }
        PsiElement firstElement = element;
        while (RubyHAMLIntegrationImpl.isWhiteSpaceOrEolOrLineContinuation(firstElement.getPrevSibling())) {
            firstElement = firstElement.getPrevSibling();
        }
        Document document = editor.getDocument();
        int startOffset = firstElement.getTextRange().getStartOffset();
        int endOffset = element.getTextRange().getEndOffset();
        document.replaceString(startOffset, endOffset, (CharSequence)("= " + expression.getText()));
        PsiDocumentManager.getInstance((Project)file.getProject()).commitDocument(document);
        return true;
    }

    public boolean mustCloseRubyBlock() {
        return false;
    }

    private static boolean isWhiteSpaceOrEolOrLineContinuation(@Nullable PsiElement sign) {
        return HAMLTokenTypes.SPACES.contains(PsiUtilCore.getElementType((PsiElement)sign));
    }

    @Nullable
    private static PsiElement findTextElementAtCaret(@NotNull Editor editor, @NotNull PsiFile file) {
        SelectionModel selectionModel;
        if (editor == null) {
            RubyHAMLIntegrationImpl.$$$reportNull$$$0(11);
        }
        if (file == null) {
            RubyHAMLIntegrationImpl.$$$reportNull$$$0(12);
        }
        if ((selectionModel = editor.getSelectionModel()).hasSelection()) {
            return null;
        }
        PsiElement element = file.findElementAt(editor.getCaretModel().getOffset());
        if (element == null || PsiUtilCore.getElementType((PsiElement)element) != HAMLTokenTypes.TEXT) {
            return null;
        }
        return element;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToAdd";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/haml/ruby/RubyHAMLIntegrationImpl";
                break;
            }
            case 6: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 7: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/haml/ruby/RubyHAMLIntegrationImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileType";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "canModifyPsiInsert";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addRubyStatement";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getTextForI18n";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "replaceTextWithI18n";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findTextElementAtCaret";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5 -> new IllegalStateException(string);
        };
    }
}

