/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.projectView_old.v2.nodes.folders;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import icons.RubyIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.rails.database.MigrationParser;
import org.jetbrains.plugins.ruby.rails.facet.configuration.RailsPaths;
import org.jetbrains.plugins.ruby.rails.model.RailsApp;
import org.jetbrains.plugins.ruby.rails.projectView_old.id.NodeId;
import org.jetbrains.plugins.ruby.rails.projectView_old.v2.PreselectGeneratorCondition;
import org.jetbrains.plugins.ruby.rails.projectView_old.v2.nodes.DBSchemaNode;
import org.jetbrains.plugins.ruby.rails.projectView_old.v2.nodes.DBSeedsNode;
import org.jetbrains.plugins.ruby.rails.projectView_old.v2.nodes.FileNode;
import org.jetbrains.plugins.ruby.rails.projectView_old.v2.nodes.MigrationFileNode;
import org.jetbrains.plugins.ruby.rails.projectView_old.v2.nodes.RailsNodeDescriptor;
import org.jetbrains.plugins.ruby.rails.projectView_old.v2.nodes.folders.AbstractFolderNode;
import org.jetbrains.plugins.ruby.rails.projectView_old.v2.nodes.folders.FolderSubFolderNode;
import org.jetbrains.plugins.ruby.utils.VirtualFileUtil;

public class MigrationsFolder
extends AbstractFolderNode {
    public MigrationsFolder(@NotNull Module module, ViewSettings viewSettings) {
        if (module == null) {
            MigrationsFolder.$$$reportNull$$$0(0);
        }
        super(module, MigrationsFolder.getMigrationsRoot(module), "MODELS_SUBTREE", viewSettings);
    }

    public static FolderSubFolderNode createSubFolderNode(Module module, VirtualFile directory, ViewSettings settings) {
        return new FolderSubFolderNode(module, directory, "MODELS_SUBTREE", settings);
    }

    private static VirtualFile getMigrationsRoot(Module module) {
        return RailsPaths.findDefaultFile((Module)module, (String)"db/migrate");
    }

    @Override
    public String getTestPresentation() {
        return MigrationsFolder.getMigrationsFolder();
    }

    @Override
    protected void updateImpl(@NotNull PresentationData data) {
        if (data == null) {
            MigrationsFolder.$$$reportNull$$$0(1);
        }
        data.setPresentableText(MigrationsFolder.getMigrationsFolder());
        data.setIcon(RubyIcons.Rails.ProjectView.MigrationsFolder);
    }

    @Override
    public Condition<AnAction> getPreselectNewActionCondition() {
        return new PreselectGeneratorCondition("migration");
    }

    @Override
    public boolean contains(@NotNull VirtualFile file) {
        if (file == null) {
            MigrationsFolder.$$$reportNull$$$0(2);
        }
        if (super.contains(file)) {
            return true;
        }
        VirtualFile parent = file.getParent();
        if (parent == null) {
            return false;
        }
        if (MigrationsFolder.isFileDBSchema(file, this.getModule())) {
            return true;
        }
        return MigrationsFolder.isFileDBSeeds(file, this.getModule());
    }

    public static boolean isFileDBSchema(VirtualFile file, Module module) {
        if (!"schema.rb".equals(file.getName())) {
            return false;
        }
        return file.getUrl().equals(VirtualFileUtil.buildUrl((String)RailsPaths.getDefaultUrl((Module)module, (String)"db"), (String)"schema.rb"));
    }

    public static boolean isFileDBSeeds(VirtualFile file, Module module) {
        return Objects.equals(RailsPaths.findDefaultFile((Module)module, (String)"db/seeds.rb"), file);
    }

    @Override
    protected Collection<AbstractTreeNode<?>> getChildrenImpl() {
        VirtualFile seeds;
        NodeId nodeId = (NodeId)this.getValue();
        assert (nodeId != null);
        VirtualFile migrDir = this.getVirtualFile();
        assert (migrDir != null);
        Module module = this.getModule();
        ArrayList children = new ArrayList();
        Collection<AbstractTreeNode<?>> contentBasedChildren = super.getChildrenImpl();
        if (contentBasedChildren != null) {
            children.addAll(contentBasedChildren);
        }
        RailsApp app = RailsApp.fromModule((Module)module);
        assert (app != null);
        VirtualFile schema = (VirtualFile)ObjectUtils.doIfNotNull((Object)RailsPaths.findDefaultFile((Module)module, (String)"db"), it -> it.findChild("schema.rb"));
        if (schema != null) {
            children.add((AbstractTreeNode<?>)new DBSchemaNode(module, this.getSettings()));
        }
        if ((seeds = RailsPaths.findDefaultFile((Module)module, (String)"db/seeds.rb")) != null) {
            children.add((AbstractTreeNode<?>)new DBSeedsNode(module, this.getSettings()));
        }
        return children;
    }

    @Override
    protected void processNotDirectoryFile(List<AbstractTreeNode<?>> nodes, VirtualFile file) {
        FileNode fileNode = this.createFileNode(file);
        if (fileNode != null) {
            nodes.add((AbstractTreeNode<?>)fileNode);
        }
    }

    @Override
    @Nullable
    protected FileNode createFileNode(VirtualFile file) {
        NodeId nodeId = (NodeId)this.getValue();
        assert (nodeId != null);
        if (MigrationParser.matchesToMigrationFileNameTemplate((VirtualFile)file)) {
            return new MigrationFileNode(this.getModule(), file, this.getLocationRootMark(), this.getSettings());
        }
        return super.createFileNode(file);
    }

    @Override
    protected AbstractFolderNode createFolderNode(@NotNull Module module, @NotNull VirtualFile directory) {
        if (module == null) {
            MigrationsFolder.$$$reportNull$$$0(3);
        }
        if (directory == null) {
            MigrationsFolder.$$$reportNull$$$0(4);
        }
        NodeId nodeId = (NodeId)this.getValue();
        assert (nodeId != null);
        return MigrationsFolder.createSubFolderNode(module, directory, this.getSettings());
    }

    @Override
    @NotNull
    public RailsNodeDescriptor.SortInfo getSortInformation() {
        RailsNodeDescriptor.SortInfo sortInfo = RailsNodeDescriptor.SortInfo.MIGRATIONS_FOLDER;
        if (sortInfo == null) {
            MigrationsFolder.$$$reportNull$$$0(5);
        }
        return sortInfo;
    }

    @Nls
    private static String getMigrationsFolder() {
        return RBundle.message((String)"rails.project.module.view.nodes.migrations.presentable");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/projectView_old/v2/nodes/folders/MigrationsFolder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/projectView_old/v2/nodes/folders/MigrationsFolder";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSortInformation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "updateImpl";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createFolderNode";
                break;
            }
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }
}

